<?php
/*
 * ربات مدیریت گروه تیتان - نسخه 2.0
 * فایل: settings.php - پردازش کال‌بک و پنل‌ها
 */

require_once __DIR__ . '/config.php';

function handleCallback($callbackQ) {
    $data = $callbackQ->data ?? '';
    $userId = $callbackQ->from->id ?? 0;
    $chatId = $callbackQ->message->chat->id ?? 0;
    $msgId = $callbackQ->message->message_id ?? 0;
    $chatType = $callbackQ->message->chat->type ?? 'private';
    $cbId = $callbackQ->id;

    // ==================== کال‌بک‌های پنل ادمین (PV) ====================
    if (strpos($data, 'dev_') === 0) {
        handleDevCallbacks($data, $userId, $chatId, $msgId, $cbId);
        return;
    }

    // ==================== کال‌بک‌های گروه ====================
    if ($chatType !== 'private') {
        handleGroupCallbacks($data, $userId, $chatId, $msgId, $cbId, $callbackQ);
        return;
    }
}

// ==================== کال‌بک‌های پنل Dev ====================
function handleDevCallbacks($data, $userId, $chatId, $msgId, $cbId) {
    $devs = unserialize(DEV_IDS);
    $userData = getUserData();
    $sudoList = $userData['bot_settings']['sudo_list'] ?? [];

    if (!in_array($userId, $devs) && !in_array($userId, $sudoList)) {
        answerCallback($cbId, "⛔ دسترسی ندارید!", true);
        return;
    }

    switch ($data) {
        case 'dev_main':
            showDevMainPanel($chatId, $msgId);
            break;

        case 'dev_stats':
            showDevStats($chatId, $msgId);
            break;

        case 'dev_settings':
            showDevSettings($chatId, $msgId);
            break;

        case 'dev_texts':
            showDevTexts($chatId, $msgId);
            break;

        case 'dev_sudo_list':
            showSudoList($chatId, $msgId);
            break;

        case 'dev_add_sudo':
            $userData['users'][$userId]['awaiting'] = 'add_sudo';
            saveUserData($userData);
            answerCallback($cbId, "آیدی عددی کاربر مورد نظر را ارسال کنید.", true);
            break;

        case 'dev_remove_sudo':
            $userData['users'][$userId]['awaiting'] = 'remove_sudo';
            saveUserData($userData);
            answerCallback($cbId, "آیدی عددی سودو مورد نظر برای حذف را ارسال کنید.", true);
            break;

        case 'dev_channel_lock':
            $userData['bot_settings']['channel_lock'] = !($userData['bot_settings']['channel_lock'] ?? false);
            saveUserData($userData);
            $st = $userData['bot_settings']['channel_lock'] ? 'فعال' : 'غیرفعال';
            answerCallback($cbId, "قفل کانال {$st} شد.", true);
            showDevSettings($chatId, $msgId);
            break;

        case 'dev_leave_group':
            $userData['users'][$userId]['awaiting'] = 'leave_group';
            saveUserData($userData);
            answerCallback($cbId, "آیدی عددی گروه مورد نظر برای خروج را ارسال کنید.", true);
            break;

        case 'dev_backup':
            $file = createBackup();
            answerCallback($cbId, "✅ بکاپ ایجاد شد:\n" . basename($file), true);
            break;

        case 'dev_block_user':
            $userData['users'][$userId]['awaiting'] = 'block_user';
            saveUserData($userData);
            answerCallback($cbId, "آیدی عددی کاربر مورد نظر برای بلاک ارسال کنید.", true);
            break;

        case 'dev_unblock_user':
            $userData['users'][$userId]['awaiting'] = 'unblock_user';
            saveUserData($userData);
            answerCallback($cbId, "آیدی عددی کاربر مورد نظر برای آن‌بلاک ارسال کنید.", true);
            break;

        case 'dev_set_start':
            $userData['users'][$userId]['awaiting'] = 'set_start_text';
            saveUserData($userData);
            answerCallback($cbId, "متن جدید استارت را ارسال کنید.", true);
            break;

        case 'dev_set_help':
            $userData['users'][$userId]['awaiting'] = 'set_help_text';
            saveUserData($userData);
            answerCallback($cbId, "متن جدید راهنما را ارسال کنید.", true);
            break;

        case 'dev_set_features':
            $userData['users'][$userId]['awaiting'] = 'set_features_text';
            saveUserData($userData);
            answerCallback($cbId, "متن جدید امکانات را ارسال کنید.", true);
            break;

        case 'dev_set_support':
            $userData['users'][$userId]['awaiting'] = 'set_support_text';
            saveUserData($userData);
            answerCallback($cbId, "متن جدید پشتیبانی را ارسال کنید.", true);
            break;

        case 'dev_send_to_groups':
            $userData['users'][$userId]['awaiting'] = 'send_to_groups';
            saveUserData($userData);
            answerCallback($cbId, "پیام مورد نظر برای ارسال به همه گروه‌ها را بفرستید.", true);
            break;

        case 'dev_send_to_users':
            $userData['users'][$userId]['awaiting'] = 'send_to_users';
            saveUserData($userData);
            answerCallback($cbId, "پیام مورد نظر برای ارسال به همه کاربران را بفرستید.", true);
            break;

        case 'dev_fwd_to_groups':
            $userData['users'][$userId]['awaiting'] = 'fwd_to_groups';
            saveUserData($userData);
            answerCallback($cbId, "پیامی که می‌خواهید به همه گروه‌ها فوروارد شود را بفرستید.", true);
            break;

        case 'dev_fwd_to_users':
            $userData['users'][$userId]['awaiting'] = 'fwd_to_users';
            saveUserData($userData);
            answerCallback($cbId, "پیامی که می‌خواهید به همه کاربران فوروارد شود را بفرستید.", true);
            break;

        case 'dev_msg_user':
            $userData['users'][$userId]['awaiting'] = 'msg_user_id';
            saveUserData($userData);
            answerCallback($cbId, "ابتدا آیدی عددی کاربر را ارسال کنید.", true);
            break;

        case 'dev_ad':
            $userData['users'][$userId]['awaiting'] = 'set_ad';
            saveUserData($userData);
            answerCallback($cbId, "متن تبلیغ جدید را ارسال کنید.", true);
            break;

        case 'dev_back_start':
            $keyboard = [
                'keyboard' => [
                    [['text' => "➕ افزودن ربات به گروه"]],
                    [['text' => "🔎 راهنما"], ['text' => "🎖️ دستورات امکانات"]],
                    [['text' => "🫡 پشتیبانی"], ['text' => "😍 تبلیغات رایگان"]],
                    [['text' => "🤖 خرید ربات"], ['text' => "🛠️ ابزارها"]],
                ],
                'resize_keyboard' => true,
            ];
            editMessage($chatId, $msgId, "🤖 به منوی اصلی بازگشتید.");
            sendMessage($chatId, "🏠 منوی اصلی", null, $keyboard);
            break;

        case 'dev_close':
            deleteMessage($chatId, $msgId);
            break;
    }
}

// ==================== نمایش پنل‌های Dev ====================
function showDevMainPanel($chatId, $msgId) {
    $kb = ['inline_keyboard' => [
        [['text' => '📑 آمار کلی ربات 📑', 'callback_data' => 'dev_stats']],
        [
            ['text' => '⚙️ تنظیمات', 'callback_data' => 'dev_settings'],
            ['text' => '📝 تنظیم متون', 'callback_data' => 'dev_texts'],
        ],
        [
            ['text' => '💸 تنظیم تبلیغ', 'callback_data' => 'dev_ad'],
            ['text' => '💌 پیام به کاربر', 'callback_data' => 'dev_msg_user'],
        ],
        [
            ['text' => '🗳️ فوروارد به گروه‌ها', 'callback_data' => 'dev_fwd_to_groups'],
            ['text' => '📮 فوروارد به کاربران', 'callback_data' => 'dev_fwd_to_users'],
        ],
        [
            ['text' => '🗳️ ارسال به گروه‌ها', 'callback_data' => 'dev_send_to_groups'],
            ['text' => '📮 ارسال به کاربران', 'callback_data' => 'dev_send_to_users'],
        ],
        [['text' => '👈 برگشت به منو استارت 👈', 'callback_data' => 'dev_back_start']],
    ]];
    editMessage($chatId, $msgId, "<b>🛠 پنل مدیریت ربات تیتان</b>\n\nبخش مورد نظر را انتخاب کنید:", $kb);
}

function showDevStats($chatId, $msgId) {
    $userData = getUserData();
    $groups = getGroupsList();
    $userCount = count($userData['users'] ?? []);
    $groupCount = count($groups);
    $blockedCount = count($userData['bot_settings']['blocked_users'] ?? []);
    $sudoCount = count($userData['bot_settings']['sudo_list'] ?? []);

    $text = "<b>📑 آمار کلی ربات تیتان</b>\n\n";
    $text .= "👥 کاربران: <b>{$userCount}</b>\n";
    $text .= "💬 گروه‌ها: <b>{$groupCount}</b>\n";
    $text .= "🚫 بلاک‌شده‌ها: <b>{$blockedCount}</b>\n";
    $text .= "👑 سودوها: <b>{$sudoCount}</b>\n";
    $text .= "\n📆 " . jdate('Y/m/d H:i');

    $kb = ['inline_keyboard' => [
        [['text' => '🔄 بروزرسانی', 'callback_data' => 'dev_stats']],
        [['text' => '⏹ برگشت', 'callback_data' => 'dev_main']],
    ]];
    editMessage($chatId, $msgId, $text, $kb);
}

function showDevSettings($chatId, $msgId) {
    $userData = getUserData();
    $chLock = ($userData['bot_settings']['channel_lock'] ?? false) ? '✅' : '❌';
    $kb = ['inline_keyboard' => [
        [
            ['text' => "{$chLock} قفل کانال", 'callback_data' => 'dev_channel_lock'],
            ['text' => '📋 لیست سودو', 'callback_data' => 'dev_sudo_list'],
        ],
        [
            ['text' => '➕ افزودن سودو', 'callback_data' => 'dev_add_sudo'],
            ['text' => '➖ حذف سودو', 'callback_data' => 'dev_remove_sudo'],
        ],
        [
            ['text' => '❌ خروج از گروه', 'callback_data' => 'dev_leave_group'],
            ['text' => '🗂️ بکاپ گروه‌ها', 'callback_data' => 'dev_backup'],
        ],
        [
            ['text' => '🚫 بلاک کاربر', 'callback_data' => 'dev_block_user'],
            ['text' => '✅ آن‌بلاک کاربر', 'callback_data' => 'dev_unblock_user'],
        ],
        [['text' => '⏹ برگشت به منو اصلی', 'callback_data' => 'dev_main']],
    ]];
    editMessage($chatId, $msgId, "<b>⚙️ تنظیمات ربات</b>\n\nبخش مورد نظر را انتخاب کنید:", $kb);
}

function showDevTexts($chatId, $msgId) {
    $kb = ['inline_keyboard' => [
        [['text' => '📝 تنظیم متن استارت', 'callback_data' => 'dev_set_start']],
        [['text' => '📝 تنظیم متن راهنما', 'callback_data' => 'dev_set_help']],
        [['text' => '📝 تنظیم متن امکانات', 'callback_data' => 'dev_set_features']],
        [['text' => '📝 تنظیم متن پشتیبانی', 'callback_data' => 'dev_set_support']],
        [['text' => '⏹ برگشت به منو اصلی', 'callback_data' => 'dev_main']],
    ]];
    editMessage($chatId, $msgId, "<b>📝 تنظیم متون ربات</b>\n\nمتن مورد نظر برای تغییر را انتخاب کنید:", $kb);
}

function showSudoList($chatId, $msgId) {
    $userData = getUserData();
    $sudos = $userData['bot_settings']['sudo_list'] ?? [];
    $text = "<b>📋 لیست سودوها:</b>\n\n";
    if (empty($sudos)) {
        $text .= "<i>هیچ سودویی تعیین نشده.</i>";
    } else {
        foreach ($sudos as $i => $sid) {
            $text .= ($i + 1) . ". <a href='tg://user?id={$sid}'>{$sid}</a>\n";
        }
    }
    $kb = ['inline_keyboard' => [
        [['text' => '⏹ برگشت', 'callback_data' => 'dev_settings']],
    ]];
    editMessage($chatId, $msgId, $text, $kb);
}

// ==================== کال‌بک‌های گروه ====================
function handleGroupCallbacks($data, $userId, $chatId, $msgId, $cbId, $callbackQ) {
    $settings = getGroupSettings($chatId);

    $resStatus = apiRequest('getChatMember', ['chat_id' => $chatId, 'user_id' => $userId]);
    $status = ($resStatus['ok'] ?? false) ? $resStatus['result']['status'] : '';
    $isCreatorOrAdmin = in_array($status, ['creator', 'administrator']);
    $isOwner = ($userId == $settings['owner_id']);
    $devs = unserialize(DEV_IDS);
    $isDev = in_array($userId, $devs);
    $adminLevel = getAdminLevel($settings, $userId);
    $isAdmin = ($isOwner || in_array($userId, $settings['admins']) || $isCreatorOrAdmin || $isDev);

    if (!$isAdmin && !in_array($userId, $settings['specials'])) {
        // بررسی دکمه عضو شدم
        if ($data === 'i_joined') {
            $notJoined = [];
            foreach ($settings['required_channels'] as $ch) {
                $res = apiRequest('getChatMember', ['chat_id' => "@{$ch}", 'user_id' => $userId]);
                $st = ($res['ok'] ?? false) ? $res['result']['status'] : 'left';
                if (in_array($st, ['left', 'kicked'])) $notJoined[] = $ch;
            }
            if (empty($notJoined)) {
                answerCallback($cbId, "✅ عضویت تأیید شد! حالا می‌تونی پیام بفرستی.", true);
                deleteMessage($chatId, $msgId);
            } else {
                answerCallback($cbId, "❌ هنوز عضو همه کانال‌ها نشدید!", true);
            }
            return;
        }
        answerCallback($cbId, "⛔ دسترسی ندارید!", true);
        return;
    }

    // ==================== noop ====================
    if ($data === 'noop') {
        answerCallback($cbId, "", false);
        return;
    }

    // ==================== منوی اصلی گروه ====================
    if ($data === 'main_panel') {
        showGroupMainPanel($chatId, $msgId);
        return;
    }

    // ==================== بستن پنل ====================
    if ($data === 'close_panel') {
        deleteMessage($chatId, $msgId);
        return;
    }

    // ==================== اطلاعات ====================
    if ($data === 'submenu_info') {
        $kb = ['inline_keyboard' => [
            [['text' => '📊 آمار گروه', 'callback_data' => 'grp_stats']],
            [
                ['text' => '👮 مدیران ربات', 'callback_data' => 'list_bot_admins'],
                ['text' => '👥 مدیران گروه', 'callback_data' => 'list_group_admins'],
            ],
            [['text' => '🌟 لیست ویژه‌ها', 'callback_data' => 'list_specials']],
            [
                ['text' => '📢 کانال‌های الزامی', 'callback_data' => 'list_channels'],
                ['text' => '🔇 سکوت‌شدگان', 'callback_data' => 'list_muted'],
            ],
            [['text' => '🚫 لیست مسدودشده‌ها', 'callback_data' => 'list_banned']],
            [
                ['text' => '🏆 فعالترین‌ها', 'callback_data' => 'list_top_active'],
                ['text' => '➕ بیشترین اد', 'callback_data' => 'list_top_adders'],
            ],
            [['text' => '⏹ برگشت', 'callback_data' => 'main_panel']],
        ]];
        editMessage($chatId, $msgId, "<b>🪪 اطلاعات گروه</b>\n\nلطفاً یک گزینه را انتخاب کنید:", $kb);
        return;
    }

    // ==================== آمار گروه ====================
    if ($data === 'grp_stats') {
        $resMembers = apiRequest('getChatMembersCount', ['chat_id' => $chatId]);
        $memberCount = ($resMembers['ok'] ?? false) ? $resMembers['result'] : 0;
        $resAdmins = apiRequest('getChatAdministrators', ['chat_id' => $chatId]);
        $adminCount = ($resAdmins['ok'] ?? false) ? count($resAdmins['result']) : 0;
        $botAdminCount = count($settings['admins']);
        $specialCount = count($settings['specials']);
        $filterCount = count($settings['filter']);
        $warnCount = count($settings['warns']);
        $mutedCount = count($settings['muted_users']);
        $bannedCount = count($settings['banned_users']);
        $channelCount = count($settings['required_channels']);
        $activeLocks = 0;
        foreach ($settings['locks'] as $v) { if ($v !== 'off') $activeLocks++; }
        $welStatus = $settings['welcome_enabled'] ? '✅' : '❌';
        $spamStatus = $settings['anti_spam']['enabled'] ? '✅' : '❌';
        $delStatus = $settings['anti_delete'] ? '✅' : '❌';
        $floodStatus = $settings['anti_flood']['enabled'] ? '✅' : '❌';
        $botStatus = $settings['anti_bot'] ? '✅' : '❌';

        $text = "<b>📊 آمار گروه</b>\n\n";
        $text .= "📅 تاریخ نصب: <code>{$settings['created_at']}</code>\n";
        $text .= "👥 تعداد اعضا: <b>{$memberCount}</b>\n";
        $text .= "👮 مدیران گروه: <b>{$adminCount}</b>\n";
        $text .= "🤖 مدیران ربات: <b>{$botAdminCount}</b>\n";
        $text .= "🌟 ویژه‌ها: <b>{$specialCount}</b>\n";
        $text .= "🔇 سکوت‌شده: <b>{$mutedCount}</b>\n";
        $text .= "🚫 بن‌شده: <b>{$bannedCount}</b>\n\n";
        $text .= "🔒 قفل‌های فعال: <b>{$activeLocks}</b>\n";
        $text .= "📝 فیلترها: <b>{$filterCount}</b>\n";
        $text .= "⚠️ هشدارها: <b>{$warnCount}</b>\n";
        $text .= "📢 کانال‌های الزامی: <b>{$channelCount}</b>\n\n";
        $text .= "👋 خوش‌آمد: {$welStatus}\n";
        $text .= "🛡 ضد اسپم: {$spamStatus}\n";
        $text .= "🗑 ضد حذف: {$delStatus}\n";
        $text .= "🌊 ضد فلوود: {$floodStatus}\n";
        $text .= "🤖 ضد ربات: {$botStatus}";

        $kb = ['inline_keyboard' => [
            [['text' => '🔄 بروزرسانی', 'callback_data' => 'grp_stats']],
            [['text' => '⏹ برگشت', 'callback_data' => 'submenu_info']],
        ]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== لیست مدیران ربات ====================
    if ($data === 'list_bot_admins') {
        $text = "<b>👮 لیست مدیران ربات:</b>\n\n";
        $text .= "👑 مالک: <a href='tg://user?id={$settings['owner_id']}'>{$settings['owner_id']}</a>\n\n";
        if (empty($settings['admins'])) {
            $text .= "<i>هیچ مدیری تعیین نشده.</i>";
        } else {
            foreach ($settings['admins'] as $aid) {
                $lvl = getAdminLevel($settings, $aid);
                $lvlName = getAdminLevelName($lvl);
                $text .= "• <a href='tg://user?id={$aid}'>{$aid}</a> - {$lvlName}\n";
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_info']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== لیست مدیران گروه ====================
    if ($data === 'list_group_admins') {
        $resAdmins = apiRequest('getChatAdministrators', ['chat_id' => $chatId]);
        $text = "<b>👥 لیست مدیران گروه:</b>\n\n";
        if ($resAdmins['ok'] ?? false) {
            foreach ($resAdmins['result'] as $adm) {
                $u = $adm['user'];
                $fn = $u['first_name'] ?? '';
                $un = isset($u['username']) ? "@{$u['username']}" : '';
                $st = $adm['status'] === 'creator' ? '👑' : '👮';
                $text .= "{$st} <a href='tg://user?id={$u['id']}'>{$fn}</a> {$un}\n";
            }
        } else {
            $text .= "<i>خطا در دریافت لیست مدیران.</i>";
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_info']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== لیست ویژه‌ها ====================
    if ($data === 'list_specials') {
        $text = "<b>🌟 لیست کاربران ویژه:</b>\n\n";
        if (empty($settings['specials'])) {
            $text .= "<i>هیچ کاربر ویژه‌ای تعیین نشده.</i>";
        } else {
            foreach ($settings['specials'] as $sid) {
                $text .= "• <a href='tg://user?id={$sid}'>{$sid}</a>\n";
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_info']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== لیست کانال‌ها ====================
    if ($data === 'list_channels') {
        $text = "<b>📢 کانال‌های الزامی:</b>\n\n";
        if (empty($settings['required_channels'])) {
            $text .= "<i>هیچ کانالی تعیین نشده.</i>";
        } else {
            foreach ($settings['required_channels'] as $ch) {
                $text .= "• @{$ch}\n";
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_info']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== لیست سکوت‌شدگان ====================
    if ($data === 'list_muted') {
        $text = "<b>🔇 لیست سکوت‌شدگان:</b>\n\n";
        if (empty($settings['muted_users'])) {
            $text .= "<i>هیچ کاربری سکوت نشده.</i>";
        } else {
            foreach ($settings['muted_users'] as $uid => $mdata) {
                $until = isset($mdata['until']) && $mdata['until'] > 0 ? jdate('Y/m/d H:i', $mdata['until']) : 'دائمی';
                $remaining = '';
                if (isset($mdata['until']) && $mdata['until'] > 0) {
                    $rem = $mdata['until'] - time();
                    if ($rem > 0) {
                        $remMin = intval($rem / 60);
                        $remaining = " ({$remMin} دقیقه باقیمانده)";
                    }
                }
                $text .= "• <a href='tg://user?id={$uid}'>{$uid}</a> - تا: {$until}{$remaining}\n";
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_info']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== لیست مسدودشده‌ها ====================
    if ($data === 'list_banned') {
        $text = "<b>🚫 لیست مسدودشده‌ها:</b>\n\n";
        if (empty($settings['banned_users'])) {
            $text .= "<i>هیچ کاربری مسدود نشده.</i>";
        } else {
            foreach ($settings['banned_users'] as $uid) {
                $text .= "• <a href='tg://user?id={$uid}'>{$uid}</a>\n";
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_info']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== لیست فعالترین‌ها ====================
    if ($data === 'list_top_active') {
        $top = getTopMembers($settings);
        $text = "<b>🏆 لیست فعالترین‌ها:</b>\n\n";
        if (empty($top)) {
            $text .= "<i>هنوز امتیازی ثبت نشده.</i>";
        } else {
            $medals = ['🥇', '🥈', '🥉'];
            $i = 0;
            foreach ($top as $uid => $score) {
                $medal = $medals[$i] ?? ($i + 1) . '.';
                $text .= "{$medal} <a href='tg://user?id={$uid}'>{$uid}</a> - {$score} امتیاز\n";
                $i++;
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_info']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== بیشترین ادکننده ====================
    if ($data === 'list_top_adders') {
        $top = getTopAdders($settings);
        $text = "<b>➕ لیست بیشترین اد‌کننده‌ها:</b>\n\n";
        if (empty($top)) {
            $text .= "<i>هنوز اطلاعاتی ثبت نشده.</i>";
        } else {
            $medals = ['🥇', '🥈', '🥉'];
            $i = 0;
            foreach ($top as $uid => $count) {
                $medal = $medals[$i] ?? ($i + 1) . '.';
                $text .= "{$medal} <a href='tg://user?id={$uid}'>{$uid}</a> - {$count} نفر\n";
                $i++;
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_info']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== قفل‌ها ====================
    if ($data === 'submenu_locks') {
        $kb = ['inline_keyboard' => [
            [['text' => '🔒 قفل‌های ساده', 'callback_data' => 'simple_locks:0']],
            [['text' => '🔐 قفل‌های چند حالته', 'callback_data' => 'multi_locks:0']],
            [['text' => '⏹ برگشت', 'callback_data' => 'main_panel']],
        ]];
        editMessage($chatId, $msgId, "<b>🔒 مدیریت قفل‌ها</b>\n\nنوع مدیریت قفل را انتخاب کنید:", $kb);
        return;
    }

    // ==================== قفل ساده - ۲ صفحه ====================
    if (strpos($data, 'simple_locks:') === 0) {
        $page = (int)substr($data, 13);
        showSimpleLockPage($chatId, $msgId, $settings, $page);
        return;
    }

    // ==================== توگل ساده ====================
    if (strpos($data, 'stoggle:') === 0) {
        $parts = explode(':', $data);
        $key = $parts[1] ?? '';
        $page = (int)($parts[2] ?? 0);
        if (isset($settings['locks'][$key])) {
            $settings['locks'][$key] = ($settings['locks'][$key] !== 'off') ? 'off' : 'delete';
            saveGroupSettings($chatId, $settings);
            $lockNames = getLockNames();
            $name = $lockNames[$key] ?? $key;
            $st = $settings['locks'][$key] !== 'off' ? 'فعال' : 'غیرفعال';
            addLog($chatId, $userId, "تغییر قفل {$name}", null, $st);
            answerCallback($cbId, "قفل {$name} {$st} شد.", false);
            showSimpleLockPage($chatId, $msgId, $settings, $page);
        }
        return;
    }

    // ==================== قفل چند حالته - ۴ صفحه ====================
    if (strpos($data, 'multi_locks:') === 0) {
        $page = (int)substr($data, 12);
        showMultiLockPage($chatId, $msgId, $settings, $page);
        return;
    }

    // ==================== تغییر حالت قفل چند حالته ====================
    if (strpos($data, 'mlock:') === 0) {
        $parts = explode(':', $data);
        $key = $parts[1] ?? '';
        $page = (int)($parts[2] ?? 0);
        if (isset($settings['locks'][$key])) {
            $modes = array_keys(getLockModes());
            $current = $settings['locks'][$key];
            $idx = array_search($current, $modes);
            $next = ($idx === false || $idx >= count($modes) - 1) ? 0 : $idx + 1;
            $settings['locks'][$key] = $modes[$next];
            saveGroupSettings($chatId, $settings);
            $lockNames = getLockNames();
            $lockModes = getLockModes();
            $name = $lockNames[$key] ?? $key;
            $modeName = $lockModes[$settings['locks'][$key]] ?? '?';
            addLog($chatId, $userId, "تغییر قفل {$name}", null, $modeName);
            answerCallback($cbId, "{$name}: {$modeName}", false);
            showMultiLockPage($chatId, $msgId, $settings, $page);
        }
        return;
    }

    // ==================== تنظیمات ====================
    if ($data === 'submenu_settings_main') {
        $kb = ['inline_keyboard' => [
            [['text' => '🚀 مدیریت مودها', 'callback_data' => 'submenu_modes']],
            [['text' => '📝 مدیریت فیلترها', 'callback_data' => 'submenu_filters']],
            [['text' => '👋 تنظیمات خوش‌آمد', 'callback_data' => 'submenu_welcome']],
            [['text' => '🚫 هشدار و بن', 'callback_data' => 'submenu_warns']],
            [
                ['text' => '➕ کانال الزامی', 'callback_data' => 'add_channel'],
                ['text' => '➖ حذف کانال', 'callback_data' => 'remove_channel'],
            ],
            [
                ['text' => '🔗 وایت‌لیست لینک', 'callback_data' => 'link_whitelist'],
                ['text' => '⛔ بلک‌لیست لینک', 'callback_data' => 'link_blacklist'],
            ],
            [['text' => '⏰ زمان‌بندی قفل‌ها', 'callback_data' => 'schedule_settings']],
            [['text' => '📜 لاگ فعالیت‌ها', 'callback_data' => 'show_logs']],
            [['text' => '🛠 تنظیمات گروه', 'callback_data' => 'submenu_settings']],
            [['text' => '⏹ برگشت', 'callback_data' => 'main_panel']],
        ]];
        editMessage($chatId, $msgId, "<b>🛠️ تنظیمات گروه</b>\n\nلطفاً یک گزینه را انتخاب کنید:", $kb);
        return;
    }

    // ==================== مودها ====================
    if ($data === 'submenu_modes') {
        $as = $settings['anti_spam']['enabled'] ? '✅' : '❌';
        $ad = $settings['anti_delete'] ? '✅' : '❌';
        $af = $settings['anti_flood']['enabled'] ? '✅' : '❌';
        $ab = $settings['anti_bot'] ? '✅' : '❌';
        $kb = ['inline_keyboard' => [
            [['text' => "{$as} ضد اسپم", 'callback_data' => 'toggle_antispam']],
            [['text' => "{$ad} ضد حذف", 'callback_data' => 'toggle_antidelete']],
            [['text' => "{$af} ضد فلوود", 'callback_data' => 'toggle_antiflood']],
            [['text' => "{$ab} ضد ربات", 'callback_data' => 'toggle_antibot']],
            [['text' => '⏹ برگشت', 'callback_data' => 'submenu_settings_main']],
        ]];
        editMessage($chatId, $msgId, "<b>🚀 مدیریت مودها</b>\n\nبرای تغییر وضعیت کلیک کنید:", $kb);
        return;
    }

    // ==================== توگل مودها ====================
    if ($data === 'toggle_antispam') {
        if (!hasPermission($settings, $userId, 4)) { answerCallback($cbId, "سطح دسترسی کافی ندارید!", true); return; }
        $settings['anti_spam']['enabled'] = !$settings['anti_spam']['enabled'];
        saveGroupSettings($chatId, $settings);
        addLog($chatId, $userId, 'تغییر ضد اسپم', null, $settings['anti_spam']['enabled'] ? 'فعال' : 'غیرفعال');
        answerCallback($cbId, "ضد اسپم " . ($settings['anti_spam']['enabled'] ? 'فعال' : 'غیرفعال') . " شد.");
        handleGroupCallbacks('submenu_modes', $userId, $chatId, $msgId, $cbId, $callbackQ);
        return;
    }
    if ($data === 'toggle_antidelete') {
        if (!hasPermission($settings, $userId, 4)) { answerCallback($cbId, "سطح دسترسی کافی ندارید!", true); return; }
        $settings['anti_delete'] = !$settings['anti_delete'];
        saveGroupSettings($chatId, $settings);
        addLog($chatId, $userId, 'تغییر ضد حذف', null, $settings['anti_delete'] ? 'فعال' : 'غیرفعال');
        answerCallback($cbId, "ضد حذف " . ($settings['anti_delete'] ? 'فعال' : 'غیرفعال') . " شد.");
        handleGroupCallbacks('submenu_modes', $userId, $chatId, $msgId, $cbId, $callbackQ);
        return;
    }
    if ($data === 'toggle_antiflood') {
        if (!hasPermission($settings, $userId, 4)) { answerCallback($cbId, "سطح دسترسی کافی ندارید!", true); return; }
        $settings['anti_flood']['enabled'] = !$settings['anti_flood']['enabled'];
        saveGroupSettings($chatId, $settings);
        addLog($chatId, $userId, 'تغییر ضد فلوود', null, $settings['anti_flood']['enabled'] ? 'فعال' : 'غیرفعال');
        answerCallback($cbId, "ضد فلوود " . ($settings['anti_flood']['enabled'] ? 'فعال' : 'غیرفعال') . " شد.");
        handleGroupCallbacks('submenu_modes', $userId, $chatId, $msgId, $cbId, $callbackQ);
        return;
    }
    if ($data === 'toggle_antibot') {
        if (!hasPermission($settings, $userId, 4)) { answerCallback($cbId, "سطح دسترسی کافی ندارید!", true); return; }
        $settings['anti_bot'] = !$settings['anti_bot'];
        saveGroupSettings($chatId, $settings);
        addLog($chatId, $userId, 'تغییر ضد ربات', null, $settings['anti_bot'] ? 'فعال' : 'غیرفعال');
        answerCallback($cbId, "ضد ربات " . ($settings['anti_bot'] ? 'فعال' : 'غیرفعال') . " شد.");
        handleGroupCallbacks('submenu_modes', $userId, $chatId, $msgId, $cbId, $callbackQ);
        return;
    }

    // ==================== خوش‌آمدگویی ====================
    if ($data === 'submenu_welcome') {
        $we = $settings['welcome_enabled'] ? '✅' : '❌';
        $hasMedia = !empty($settings['welcome_media']) ? '✅' : '❌';
        $kb = ['inline_keyboard' => [
            [['text' => "{$we} خوش‌آمد", 'callback_data' => 'toggle_welcome']],
            [['text' => '📋 نمایش متن خوش‌آمد', 'callback_data' => 'show_welcome']],
            [['text' => '📝 تنظیم متن خوش‌آمد', 'callback_data' => 'set_welcome_text']],
            [['text' => "{$hasMedia} افزودن عکس/گیف/ویدیو", 'callback_data' => 'set_welcome_media']],
            [['text' => '🔄 بازگشت به پیش‌فرض', 'callback_data' => 'reset_welcome']],
            [['text' => '⏹ برگشت', 'callback_data' => 'submenu_settings_main']],
        ]];
        editMessage($chatId, $msgId, "<b>👋 تنظیمات خوش‌آمدگویی</b>\n\nمتغیرهای قابل استفاده:\n<code>{FIRST_NAME}</code> - نام\n<code>{LAST_NAME}</code> - نام خانوادگی\n<code>{USERNAME}</code> - یوزرنیم\n<code>{USER_ID}</code> - آیدی\n<code>{GROUP_NAME}</code> - نام گروه\n<code>{MEMBER_COUNT}</code> - تعداد اعضا\n<code>{DATE}</code> - تاریخ\n<code>{TIME}</code> - ساعت\n<code>{MENTION}</code> - منشن", $kb);
        return;
    }

    if ($data === 'toggle_welcome') {
        $settings['welcome_enabled'] = !$settings['welcome_enabled'];
        saveGroupSettings($chatId, $settings);
        addLog($chatId, $userId, 'تغییر خوش‌آمد', null, $settings['welcome_enabled'] ? 'فعال' : 'غیرفعال');
        answerCallback($cbId, "خوش‌آمد " . ($settings['welcome_enabled'] ? 'فعال' : 'غیرفعال') . " شد.");
        handleGroupCallbacks('submenu_welcome', $userId, $chatId, $msgId, $cbId, $callbackQ);
        return;
    }

    if ($data === 'show_welcome') {
        $wt = $settings['welcome_text'] ?: getDefaultWelcomeText();
        answerCallback($cbId, "متن خوش‌آمد ارسال شد.", false);
        sendMessage($chatId, "<b>📋 متن خوش‌آمد فعلی:</b>\n\n{$wt}");
        return;
    }

    if ($data === 'set_welcome_text') {
        $settings['awaiting_welcome_text'] = true;
        saveGroupSettings($chatId, $settings);
        answerCallback($cbId, "متن جدید خوش‌آمد را ارسال کنید.", true);
        return;
    }

    if ($data === 'set_welcome_media') {
        $settings['awaiting_welcome_media'] = true;
        saveGroupSettings($chatId, $settings);
        answerCallback($cbId, "عکس، گیف یا ویدیوی مورد نظر را ارسال کنید.", true);
        return;
    }

    if ($data === 'reset_welcome') {
        $settings['welcome_text'] = '';
        $settings['welcome_media'] = null;
        $settings['welcome_media_type'] = null;
        saveGroupSettings($chatId, $settings);
        addLog($chatId, $userId, 'ریست خوش‌آمد');
        answerCallback($cbId, "✅ خوش‌آمد به حالت پیش‌فرض بازگشت.", true);
        return;
    }

    // ==================== فیلترها ====================
    if ($data === 'submenu_filters') {
        $fc = count($settings['filter']);
        $kb = ['inline_keyboard' => [
            [['text' => '📋 لیست فیلترها (' . $fc . ')', 'callback_data' => 'list_filters']],
            [['text' => '⏹ برگشت', 'callback_data' => 'submenu_settings_main']],
        ]];
        editMessage($chatId, $msgId, "<b>📝 مدیریت فیلترها</b>\n\nدستورات:\n<code>/addfilter کلمه</code> - افزودن فیلتر\n<code>/delfilter کلمه</code> - حذف فیلتر\n<code>/filterlist</code> - لیست فیلترها", $kb);
        return;
    }

    if ($data === 'list_filters') {
        $text = "<b>📋 لیست فیلترها:</b>\n\n";
        if (empty($settings['filter'])) {
            $text .= "<i>هیچ فیلتری تعیین نشده.</i>";
        } else {
            foreach ($settings['filter'] as $fw) {
                $text .= "• {$fw}\n";
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_filters']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== هشدارها ====================
    if ($data === 'submenu_warns') {
        $kb = ['inline_keyboard' => [
            [['text' => '📋 لیست هشدارها', 'callback_data' => 'list_warns']],
            [['text' => '⏹ برگشت', 'callback_data' => 'submenu_settings_main']],
        ]];
        editMessage($chatId, $msgId, "<b>🚫 مدیریت هشدار و بن</b>\n\nدستورات:\n• ریپلای + <code>هشدار</code> یا <code>/warn</code>\n• ریپلای + <code>بن</code> یا <code>/ban</code>\n• <code>/unban آیدی</code>\n• <code>/setwarn تعداد</code>\n• <code>/resetwarns آیدی</code>", $kb);
        return;
    }

    if ($data === 'list_warns') {
        $text = "<b>📋 لیست هشدارها:</b>\n\n";
        if (empty($settings['warns'])) {
            $text .= "<i>هیچ هشداری ثبت نشده.</i>";
        } else {
            foreach ($settings['warns'] as $uid => $cnt) {
                $text .= "• <a href='tg://user?id={$uid}'>{$uid}</a> » {$cnt}/{$settings['warn_limit']}\n";
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_warns']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== کانال ====================
    if ($data === 'add_channel') {
        $settings['awaiting_channel'] = true;
        $settings['channel_action'] = 'add';
        saveGroupSettings($chatId, $settings);
        answerCallback($cbId, "یوزرنیم کانال را با @ ارسال کنید.", true);
        return;
    }
    if ($data === 'remove_channel') {
        $settings['awaiting_channel'] = true;
        $settings['channel_action'] = 'remove';
        saveGroupSettings($chatId, $settings);
        answerCallback($cbId, "یوزرنیم کانال را با @ ارسال کنید.", true);
        return;
    }

    // ==================== وایت‌لیست و بلک‌لیست لینک ====================
    if ($data === 'link_whitelist') {
        $text = "<b>🔗 وایت‌لیست لینک:</b>\n\n";
        if (empty($settings['link_whitelist'])) {
            $text .= "<i>خالی</i>";
        } else {
            foreach ($settings['link_whitelist'] as $lnk) {
                $text .= "• {$lnk}\n";
            }
        }
        $text .= "\n\nدستورات:\n<code>/allowlink لینک</code>\n<code>/removelink لینک</code>";
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_settings_main']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }
    if ($data === 'link_blacklist') {
        $text = "<b>⛔ بلک‌لیست لینک:</b>\n\n";
        if (empty($settings['link_blacklist'])) {
            $text .= "<i>خالی</i>";
        } else {
            foreach ($settings['link_blacklist'] as $lnk) {
                $text .= "• {$lnk}\n";
            }
        }
        $kb = ['inline_keyboard' => [[['text' => '⏹ برگشت', 'callback_data' => 'submenu_settings_main']]]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== زمان‌بندی ====================
    if ($data === 'schedule_settings') {
        $sch = $settings['schedule_locks'];
        $en = $sch['enabled'] ? '✅' : '❌';
        $text = "<b>⏰ زمان‌بندی قفل‌ها</b>\n\n";
        $text .= "وضعیت: {$en}\n";
        $text .= "از: <code>{$sch['start']}</code>\n";
        $text .= "تا: <code>{$sch['end']}</code>\n\n";
        $text .= "دستور:\n<code>/schedule HH:MM HH:MM</code>\nمثال: <code>/schedule 00:00 08:00</code>";
        $kb = ['inline_keyboard' => [
            [['text' => "{$en} فعال/غیرفعال", 'callback_data' => 'toggle_schedule']],
            [['text' => '⏹ برگشت', 'callback_data' => 'submenu_settings_main']],
        ]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    if ($data === 'toggle_schedule') {
        $settings['schedule_locks']['enabled'] = !$settings['schedule_locks']['enabled'];
        saveGroupSettings($chatId, $settings);
        addLog($chatId, $userId, 'تغییر زمان‌بندی قفل', null, $settings['schedule_locks']['enabled'] ? 'فعال' : 'غیرفعال');
        answerCallback($cbId, "زمان‌بندی " . ($settings['schedule_locks']['enabled'] ? 'فعال' : 'غیرفعال') . " شد.");
        handleGroupCallbacks('schedule_settings', $userId, $chatId, $msgId, $cbId, $callbackQ);
        return;
    }

    // ==================== لاگ ====================
    if ($data === 'show_logs') {
        $logs = getLogs($chatId, 15);
        $text = "<b>📜 آخرین فعالیت‌ها:</b>\n\n";
        if (empty($logs)) {
            $text .= "<i>هیچ لاگی ثبت نشده.</i>";
        } else {
            foreach ($logs as $log) {
                $text .= "⏰ {$log['time']}\n";
                $text .= "👤 <a href='tg://user?id={$log['admin_id']}'>{$log['admin_id']}</a>\n";
                $text .= "📝 {$log['action']}";
                if ($log['target_id']) $text .= " → <a href='tg://user?id={$log['target_id']}'>{$log['target_id']}</a>";
                if ($log['details']) $text .= " ({$log['details']})";
                $text .= "\n─────\n";
            }
        }
        $kb = ['inline_keyboard' => [
            [['text' => '🔄 بروزرسانی', 'callback_data' => 'show_logs']],
            [['text' => '⏹ برگشت', 'callback_data' => 'submenu_settings_main']],
        ]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== تنظیمات گروه ====================
    if ($data === 'submenu_settings') {
        $kb = ['inline_keyboard' => [
            [['text' => '🔄 بازنشانی تنظیمات', 'callback_data' => 'reset_settings']],
            [['text' => '⏹ برگشت', 'callback_data' => 'submenu_settings_main']],
        ]];
        editMessage($chatId, $msgId, "<b>🛠 تنظیمات گروه</b>", $kb);
        return;
    }

    if ($data === 'reset_settings') {
        if (!$isOwner && !$isDev) { answerCallback($cbId, "فقط مالک!", true); return; }
        $new = getDefaultGroupSettings();
        $new['owner_id'] = $settings['owner_id'];
        $new['created_at'] = $settings['created_at'];
        saveGroupSettings($chatId, $new);
        addLog($chatId, $userId, 'ریست تنظیمات');
        answerCallback($cbId, "✅ تنظیمات بازنشانی شد.", true);
        return;
    }

    // ==================== راهنما - منو اصلی ====================
    if ($data === 'show_help') {
        $kb = ['inline_keyboard' => [
            [['text' => '👮 دستورات مدیریتی', 'callback_data' => 'help_management']],
            [['text' => '🔒 دستورات قفل‌ها', 'callback_data' => 'help_locks']],
            [['text' => '📢 دستورات عمومی', 'callback_data' => 'help_general']],
            [['text' => '🛠 دستورات کاربردی', 'callback_data' => 'help_utility']],
            [['text' => '⏹ برگشت', 'callback_data' => 'main_panel']],
        ]];
        editMessage($chatId, $msgId, "<b>📖 راهنمای ربات تیتان</b>\n\nدسته‌بندی مورد نظر را انتخاب کنید:", $kb);
        return;
    }

    // ==================== راهنما - مدیریتی ====================
    if ($data === 'help_management') {
        $text = "<b>👮 دستورات مدیریتی</b>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣ نصب ربات</b>\n";
        $text .= "🔹 فارسی: <code>نصب</code> | <code>پیکربندی</code>\n";
        $text .= "🔹 انگلیسی: <code>/add</code> | <code>/install</code>\n";
        $text .= "📝 فقط سازنده گروه می‌تواند نصب کند\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>2️⃣ نمایش پنل مدیریت</b>\n";
        $text .= "🔹 فارسی: <code>پنل</code>\n";
        $text .= "🔹 انگلیسی: <code>/panel</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>3️⃣ افزودن مدیر (با سطح)</b>\n";
        $text .= "🔹 فارسی: ریپلای + <code>ادمین</code> یا <code>ادمین 3</code>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/admin</code> یا <code>/admin 3</code>\n";
        $text .= "📝 سطوح: ۱-ناظر | ۲-هشداردهنده | ۳-مدیر | ۴-ارشد | ۵-نایب مالک\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>4️⃣ حذف مدیر</b>\n";
        $text .= "🔹 فارسی: ریپلای + <code>حذف ادمین</code>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/removeadmin</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>5️⃣ افزودن کاربر ویژه</b>\n";
        $text .= "🔹 فارسی: ریپلای + <code>ویژه</code>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/special</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>6️⃣ حذف کاربر ویژه</b>\n";
        $text .= "🔹 فارسی: ریپلای + <code>حذف ویژه</code>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/removespecial</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>7️⃣ هشدار به کاربر</b>\n";
        $text .= "🔹 فارسی: ریپلای + <code>هشدار</code>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/warn</code>\n";
        $text .= "📝 نیاز به سطح ۲ به بالا\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>8️⃣ مسدود کردن (بن)</b>\n";
        $text .= "🔹 فارسی: ریپلای + <code>بن</code>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/ban</code>\n";
        $text .= "📝 نیاز به سطح ۳ به بالا\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>9️⃣ آن‌بن کاربر</b>\n";
        $text .= "🔹 انگلیسی: <code>/unban آیدی‌عددی</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>🔟 سکوت کردن (سایلنت)</b>\n";
        $text .= "🔹 فارسی: ریپلای + <code>سایلنت</code> (دائمی) | <code>سایلنت 30</code> (۳۰ دقیقه)\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/mute</code> | <code>/mute 30</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣1️⃣ لغو سکوت</b>\n";
        $text .= "🔹 فارسی: ریپلای + <code>آنسایلنت</code>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/unmute</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣2️⃣ تنظیم حد هشدار</b>\n";
        $text .= "🔹 انگلیسی: <code>/setwarn تعداد</code>\n";
        $text .= "📝 مثال: <code>/setwarn 5</code> (بین ۱ تا ۲۰)\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣3️⃣ ریست هشدار کاربر</b>\n";
        $text .= "🔹 انگلیسی: <code>/resetwarns آیدی‌عددی</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣4️⃣ پاک‌سازی پیام‌ها</b>\n";
        $text .= "🔹 انگلیسی: <code>/purge تعداد</code>\n";
        $text .= "📝 حداکثر ۱۰۰ پیام | نیاز به سطح ۴\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣5️⃣ پین کردن پیام</b>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/pin</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣6️⃣ آن‌پین کردن</b>\n";
        $text .= "🔹 انگلیسی: <code>/unpin</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣7️⃣ تگ همه مدیران</b>\n";
        $text .= "🔹 انگلیسی: <code>/tagall</code>\n";

        $kb = ['inline_keyboard' => [
            [['text' => '⏹ برگشت به راهنما', 'callback_data' => 'show_help']],
        ]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== راهنما - قفل‌ها ====================
    if ($data === 'help_locks') {
        $text = "<b>🔒 دستورات قفل‌ها</b>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣ قفل کردن</b>\n";
        $text .= "🔹 فارسی: <code>قفل نام‌قفل</code>\n";
        $text .= "🔹 انگلیسی: <code>/lock نام‌قفل</code>\n";
        $text .= "📝 مثال: <code>قفل لینک</code> | <code>/lock link</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>2️⃣ بازکردن قفل</b>\n";
        $text .= "🔹 فارسی: <code>بازکردن نام‌قفل</code>\n";
        $text .= "🔹 انگلیسی: <code>/unlock نام‌قفل</code>\n";
        $text .= "📝 مثال: <code>بازکردن لینک</code> | <code>/unlock link</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>3️⃣ قفل همه</b>\n";
        $text .= "🔹 فارسی: <code>قفل همه</code>\n";
        $text .= "🔹 انگلیسی: <code>/lockall</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>4️⃣ بازکردن همه</b>\n";
        $text .= "🔹 فارسی: <code>بازکردن همه</code>\n";
        $text .= "🔹 انگلیسی: <code>/unlockall</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>5️⃣ حالت‌های قفل (۶ حالت):</b>\n";
        $text .= "⚪ خاموش | 🗑 حذف پیام | ⚠️ اخراج\n";
        $text .= "🔇 سکوت | 🚫 مسدود | ⛔ محدود\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>6️⃣ لیست قفل‌های موجود:</b>\n";
        $text .= "لینک/link | هشتگ/hashtag | منشن/mention\n";
        $text .= "انگلیسی/english | عربی/arabic | ربات/bot\n";
        $text .= "فوروارد/forward | صدا/audio | ویس/voice\n";
        $text .= "استیکر/sticker | گیف/gif | عکس/photo\n";
        $text .= "ویدیو/video | فایل/document | نظرسنجی/poll\n";
        $text .= "مخاطب/contact | مکان/location | متن/text\n";
        $text .= "ویدیو نوت/video_note | اینلاین/inline\n";
        $text .= "شماره/phone | ایموجی زیاد/emoji\n";
        $text .= "متن طولانی/long | بدون متن/no_text\n";
        $text .= "کپشن/caption | ویرایش/edit | بازی/game\n";
        $text .= "فاکتور/invoice | لوکیشن لایو/live_location\n";
        $text .= "تاس/dice | اسپویلر/spoiler | تاپیک/topic\n";
        $text .= "استیکر پریمیوم/premium_sticker\n";
        $text .= "ایموجی سفارشی/custom_emoji | استوری/story\n";

        $kb = ['inline_keyboard' => [
            [['text' => '⏹ برگشت به راهنما', 'callback_data' => 'show_help']],
        ]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== راهنما - عمومی ====================
    if ($data === 'help_general') {
        $text = "<b>📢 دستورات عمومی</b>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣ فعال/غیرفعال ضد اسپم</b>\n";
        $text .= "🔹 انگلیسی: <code>/antispam on</code> | <code>/antispam off</code>\n";
        $text .= "📝 نیاز به سطح ۴ | جلوگیری از ارسال پیام سریع\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>2️⃣ فعال/غیرفعال ضد حذف</b>\n";
        $text .= "🔹 انگلیسی: <code>/antidelete on</code> | <code>/antidelete off</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>3️⃣ فعال/غیرفعال ضد فلوود</b>\n";
        $text .= "🔹 انگلیسی: <code>/antiflood on</code> | <code>/antiflood off</code>\n";
        $text .= "📝 جلوگیری از فوروارد بیش از حد\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>4️⃣ فعال/غیرفعال ضد ربات</b>\n";
        $text .= "🔹 انگلیسی: <code>/antibot on</code> | <code>/antibot off</code>\n";
        $text .= "📝 جلوگیری از اضافه شدن ربات‌ها\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>5️⃣ خوش‌آمدگویی فعال/غیرفعال</b>\n";
        $text .= "🔹 انگلیسی: <code>/welcome on</code> | <code>/welcome off</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>6️⃣ تنظیم متن خوش‌آمد</b>\n";
        $text .= "🔹 انگلیسی: <code>/setwelcome متن</code>\n";
        $text .= "📝 متغیرها: {FIRST_NAME} {LAST_NAME} {USERNAME} {USER_ID} {GROUP_NAME} {MEMBER_COUNT} {DATE} {TIME} {MENTION}\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>7️⃣ تنظیم عکس/گیف/ویدیو خوش‌آمد</b>\n";
        $text .= "🔹 ریپلای روی مدیا + <code>/setwelcome</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>8️⃣ بازگشت خوش‌آمد به پیش‌فرض</b>\n";
        $text .= "🔹 انگلیسی: <code>/resetwelcome</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>9️⃣ کانال الزامی</b>\n";
        $text .= "📝 از پنل تنظیمات → افزودن/حذف کانال\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>🔟 زمان‌بندی قفل‌ها</b>\n";
        $text .= "🔹 انگلیسی: <code>/schedule 00:00 08:00</code>\n";
        $text .= "📝 قفل خودکار در ساعت مشخص\n";

        $kb = ['inline_keyboard' => [
            [['text' => '⏹ برگشت به راهنما', 'callback_data' => 'show_help']],
        ]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }

    // ==================== راهنما - کاربردی ====================
    if ($data === 'help_utility') {
        $text = "<b>🛠 دستورات کاربردی</b>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣ اطلاعات کاربر</b>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/info</code> یا <code>/info</code>\n";
        $text .= "📝 نمایش نام، آیدی، سطح، امتیاز، هشدار و...\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>2️⃣ رتبه‌بندی فعالترین‌ها</b>\n";
        $text .= "🔹 انگلیسی: <code>/top</code>\n";
        $text .= "📝 نمایش ۱۰ کاربر فعال گروه\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>3️⃣ گزارش پیام</b>\n";
        $text .= "🔹 انگلیسی: ریپلای + <code>/report</code>\n";
        $text .= "📝 گزارش به مالک گروه | حداکثر ۳ بار در روز\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>4️⃣ افزودن فیلتر کلمه</b>\n";
        $text .= "🔹 انگلیسی: <code>/addfilter کلمه</code>\n";
        $text .= "📝 پیام‌های حاوی کلمه فیلترشده حذف می‌شوند\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>5️⃣ حذف فیلتر</b>\n";
        $text .= "🔹 انگلیسی: <code>/delfilter کلمه</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>6️⃣ لیست فیلترها</b>\n";
        $text .= "🔹 انگلیسی: <code>/filterlist</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>7️⃣ مجاز کردن لینک</b>\n";
        $text .= "🔹 انگلیسی: <code>/allowlink لینک</code>\n";
        $text .= "📝 لینک مشخص‌شده از قفل لینک مستثنی می‌شود\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>8️⃣ حذف لینک مجاز</b>\n";
        $text .= "🔹 انگلیسی: <code>/removelink لینک</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>9️⃣ لیست لینک‌های مجاز</b>\n";
        $text .= "🔹 انگلیسی: <code>/linklist</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>🔟 مجاز کردن ربات</b>\n";
        $text .= "🔹 انگلیسی: <code>/allowbot @یوزرنیم</code>\n";
        $text .= "📝 ربات مشخص‌شده از ضد ربات مستثنی می‌شود\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣1️⃣ حذف ربات از مجاز</b>\n";
        $text .= "🔹 انگلیسی: <code>/removebot @یوزرنیم</code>\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣2️⃣ لاگ فعالیت‌ها</b>\n";
        $text .= "🔹 انگلیسی: <code>/logs</code>\n";
        $text .= "📝 نمایش آخرین فعالیت‌های مدیران\n";
        $text .= "━━━━━━━━━━━━━━━\n\n";

        $text .= "<b>1️⃣3️⃣ پینگ ربات</b>\n";
        $text .= "🔹 فارسی: <code>پینگ</code>\n";
        $text .= "🔹 انگلیسی: <code>ping</code> | <code>/ping</code>\n";
        $text .= "📝 بررسی آنلاین بودن ربات\n";

        $kb = ['inline_keyboard' => [
            [['text' => '⏹ برگشت به راهنما', 'callback_data' => 'show_help']],
        ]];
        editMessage($chatId, $msgId, $text, $kb);
        return;
    }
}

// ==================== نمایش پنل اصلی گروه ====================
function showGroupMainPanel($chatId, $msgId) {
    $kb = ['inline_keyboard' => [
        [
            ['text' => '🪪 اطلاعات', 'callback_data' => 'submenu_info'],
            ['text' => '🔒 قفل‌ها', 'callback_data' => 'submenu_locks'],
        ],
        [
            ['text' => '🛠️ تنظیمات', 'callback_data' => 'submenu_settings_main'],
            ['text' => '🔍 راهنما', 'callback_data' => 'show_help'],
        ],
        [['text' => '❌ بستن پنل', 'callback_data' => 'close_panel']],
    ]];
    editMessage($chatId, $msgId, "<b>🤖 پنل مدیریت تیتان 🥇</b>\n\nبخش مورد نظر خود را انتخاب کنید:\n┈┅━ صفحه اصلی ━┅┈", $kb);
}

// ==================== قفل ساده - ۲ صفحه ====================
function showSimpleLockPage($chatId, $msgId, $settings, $page) {
    $lockNames = getLockNames();
    $allKeys = array_keys($lockNames);
    $total = count($allKeys);
    $perPage = (int)ceil($total / 2);
    $totalPages = 2;

    if ($page < 0) $page = 0;
    if ($page >= $totalPages) $page = $totalPages - 1;

    $start = $page * $perPage;
    $pageKeys = array_slice($allKeys, $start, $perPage);
    $p1 = $page + 1;

    $buttons = [];
    foreach ($pageKeys as $key) {
        $name = $lockNames[$key];
        $icon = $settings['locks'][$key] !== 'off' ? '🔒' : '🔓';
        $buttons[] = [['text' => "{$icon} {$name}", 'callback_data' => "stoggle:{$key}:{$page}"]];
    }

    // دکمه‌های ناوبری
    $nav = [];
    if ($page > 0) $nav[] = ['text' => '◀️ صفحه قبل', 'callback_data' => 'simple_locks:' . ($page - 1)];
    $nav[] = ['text' => "📄 {$p1}/{$totalPages}", 'callback_data' => 'noop'];
    if ($page < $totalPages - 1) $nav[] = ['text' => 'صفحه بعد ▶️', 'callback_data' => 'simple_locks:' . ($page + 1)];
    $buttons[] = $nav;

    $buttons[] = [['text' => '✅ تأیید و بستن', 'callback_data' => 'submenu_locks']];

    editMessage($chatId, $msgId,
        "<b>🔒 قفل‌های ساده</b>\n\n📄 صفحه {$p1} از {$totalPages}\n\nبرای تغییر وضعیت کلیک کنید:",
        ['inline_keyboard' => $buttons]
    );
}

// ==================== قفل چند حالته - ۴ صفحه ====================
function showMultiLockPage($chatId, $msgId, $settings, $page) {
    $lockNames = getLockNames();
    $lockModes = getLockModes();
    $allKeys = array_keys($lockNames);
    $total = count($allKeys);
    $perPage = (int)ceil($total / 4);
    $totalPages = 4;

    if ($page < 0) $page = 0;
    if ($page >= $totalPages) $page = $totalPages - 1;

    $start = $page * $perPage;
    $pageKeys = array_slice($allKeys, $start, $perPage);
    $p1 = $page + 1;

    $buttons = [];
    foreach ($pageKeys as $key) {
        $name = $lockNames[$key];
        $mode = $settings['locks'][$key] ?? 'off';
        $modeText = $lockModes[$mode] ?? '⚪ خاموش';
        $buttons[] = [['text' => "{$name}: {$modeText}", 'callback_data' => "mlock:{$key}:{$page}"]];
    }

    // دکمه‌های ناوبری
    $nav = [];
    if ($page > 0) $nav[] = ['text' => '◀️ صفحه قبل', 'callback_data' => 'multi_locks:' . ($page - 1)];
    $nav[] = ['text' => "📄 {$p1}/{$totalPages}", 'callback_data' => 'noop'];
    if ($page < $totalPages - 1) $nav[] = ['text' => 'صفحه بعد ▶️', 'callback_data' => 'multi_locks:' . ($page + 1)];
    $buttons[] = $nav;

    $buttons[] = [['text' => '✅ تأیید و بستن', 'callback_data' => 'submenu_locks']];

    editMessage($chatId, $msgId,
        "<b>🔐 قفل‌های چند حالته</b>\n\n📄 صفحه {$p1} از {$totalPages}\n\nبا کلیک روی هر قفل حالت آن تغییر می‌کند:\n⚪خاموش → 🗑حذف → ⚠️اخراج → 🔇سکوت → 🚫مسدود → ⛔محدود",
        ['inline_keyboard' => $buttons]
    );
}
?>