<?php
/*
 * ربات مدیریت گروه تیتان - نسخه 2.0
 * نویسنده: طاها محمدی - تیم تیتان
 * فایل: index.php - فایل اصلی پردازش پیام‌ها
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/settings.php';

// ==================== دریافت آپدیت ====================
$update = json_decode(file_get_contents('php://input'));
if (!$update) exit;

if (isset($update->callback_query)) {
    handleCallback($update->callback_query);
    exit;
}

if (isset($update->edited_message)) {
    handleEditedMessage($update->edited_message);
    exit;
}

if (isset($update->message->new_chat_members)) {
    handleNewMembers($update->message);
    exit;
}

if (isset($update->message->left_chat_member)) {
    handleLeftMember($update->message);
    exit;
}

if (isset($update->message)) {
    handleMessage($update->message);
    exit;
}

// ==================================================================================
function handleMessage($message) {
    $chatId = $message->chat->id ?? 0;
    $chatType = $message->chat->type ?? 'private';
    $userId = $message->from->id ?? 0;
    $msgId = $message->message_id ?? 0;
    $text = $message->text ?? ($message->caption ?? '');
    $textLower = mb_strtolower(trim($text));

    if ($chatType === 'private') {
        handlePrivateMessage($message, $chatId, $userId, $msgId, $text, $textLower);
    } else {
        handleGroupMessage($message, $chatId, $userId, $msgId, $text, $textLower);
    }
}

// ==================================================================================
//                          پیام‌های خصوصی
// ==================================================================================
function handlePrivateMessage($message, $chatId, $userId, $msgId, $text, $textLower) {
    $userData = getUserData();
    $devs = unserialize(DEV_IDS);
    $sudoList = $userData['bot_settings']['sudo_list'] ?? [];
    $blockedUsers = $userData['bot_settings']['blocked_users'] ?? [];

    if (in_array($userId, $blockedUsers)) {
        sendMessage($chatId, "⛔ شما از استفاده ربات مسدود شده‌اید.");
        return;
    }

    if (!isset($userData['users'][$userId])) {
        $userData['users'][$userId] = [
            'first_name' => $message->from->first_name ?? '',
            'username' => $message->from->username ?? '',
            'joined_at' => jdate('Y/m/d H:i'),
            'awaiting' => null,
        ];
        saveUserData($userData);
    }

    if ($userData['bot_settings']['channel_lock'] ?? false) {
        $channelId = '@' . ($userData['bot_settings']['channel_id'] ?? CHANNEL);
        $res = apiRequest('getChatMember', ['chat_id' => $channelId, 'user_id' => $userId]);
        $st = ($res['ok'] ?? false) ? $res['result']['status'] : 'left';
        if (in_array($st, ['left', 'kicked']) && !in_array($userId, $devs) && !in_array($userId, $sudoList)) {
            $kb = ['inline_keyboard' => [
                [['text' => '📢 عضویت در کانال', 'url' => "https://t.me/" . CHANNEL]],
            ]];
            sendMessage($chatId, "⚠️ برای استفاده از ربات ابتدا در کانال ما عضو شوید:", null, $kb);
            return;
        }
    }

    $awaiting = $userData['users'][$userId]['awaiting'] ?? null;
    if ($awaiting) {
        handleAwaiting($message, $chatId, $userId, $msgId, $text, $awaiting, $userData);
        return;
    }

    $isDev = in_array($userId, $devs);
    $isSudo = in_array($userId, $sudoList);

    switch (true) {
        case ($textLower === '/start' || $textLower === 'شروع'):
            $startText = $userData['bot_settings']['start_text'] ?? getDefaultBotSettings()['start_text'];
            $keyboard = [
                'keyboard' => [
                    [['text' => "➕ افزودن ربات به گروه"]],
                    [['text' => "🔎 راهنما"], ['text' => "🎖️ دستورات امکانات"]],
                    [['text' => "🫡 پشتیبانی"], ['text' => "😍 تبلیغات رایگان"]],
                    [['text' => "🤖 خرید ربات"], ['text' => "🛠️ ابزارها"]],
                ],
                'resize_keyboard' => true,
            ];
            sendMessage($chatId, $startText, null, $keyboard);
            break;

        case ($textLower === '/panel' || $textLower === 'پنل' || $textLower === 'پنل مدیریت'):
            if ($isDev || $isSudo) {
                $kb = ['inline_keyboard' => [
                    [['text' => '📑 آمار کلی ربات 📑', 'callback_data' => 'dev_stats']],
                    [
                        ['text' => '⚙️ تنظیمات', 'callback_data' => 'dev_settings'],
                        ['text' => '📝 تنظیم متون', 'callback_data' => 'dev_texts'],
                    ],
                    [
                        ['text' => '💸 تنظیم تبلیغ', 'callback_data' => 'dev_ad'],
                        ['text' => '💌 پیام به کاربر', 'callback_data' => 'dev_msg_user'],
                    ],
                    [
                        ['text' => '🗳️ فوروارد به گروه‌ها', 'callback_data' => 'dev_fwd_to_groups'],
                        ['text' => '📮 فوروارد به کاربران', 'callback_data' => 'dev_fwd_to_users'],
                    ],
                    [
                        ['text' => '🗳️ ارسال به گروه‌ها', 'callback_data' => 'dev_send_to_groups'],
                        ['text' => '📮 ارسال به کاربران', 'callback_data' => 'dev_send_to_users'],
                    ],
                    [['text' => '👈 برگشت به منو استارت 👈', 'callback_data' => 'dev_back_start']],
                ]];
                sendMessage($chatId, "<b>🛠 پنل مدیریت ربات تیتان</b>\n\nبخش مورد نظر را انتخاب کنید:", null, $kb);
            } else {
                sendMessage($chatId, "⛔ شما دسترسی به پنل مدیریت ندارید.");
            }
            break;

        case ($textLower === '➕ افزودن ربات به گروه' || $textLower === 'افزودن ربات به گروه'):
            $botLink = "https://t.me/" . BOT_USERNAME . "?startgroup=true";
            $kb = ['inline_keyboard' => [
                [['text' => '➕ افزودن به گروه', 'url' => $botLink]],
            ]];
            sendMessage($chatId, "🤖 برای افزودن ربات به گروه روی دکمه زیر کلیک کنید:\n\n⚠️ توجه: ربات باید مدیر (admin) گروه شود تا بتواند به درستی کار کند.", null, $kb);
            break;

        case ($textLower === '🔎 راهنما' || $textLower === 'راهنما' || $textLower === '/help'):
            $helpText = $userData['bot_settings']['help_text'] ?? '';
            if (empty($helpText)) {
                $helpText = "<b>📖 راهنمای ربات تیتان</b>\n\n";
                $helpText .= "🤖 این ربات یک ربات مدیریت گروه حرفه‌ای است.\n\n";
                $helpText .= "<b>🔹 قابلیت‌ها:</b>\n";
                $helpText .= "• مدیریت قفل‌ها (۳۵+ نوع قفل)\n";
                $helpText .= "• ضد اسپم، ضد فلوود، ضد حذف\n";
                $helpText .= "• سیستم هشدار و بن\n";
                $helpText .= "• خوش‌آمدگویی سفارشی\n";
                $helpText .= "• فیلتر کلمات\n";
                $helpText .= "• کانال الزامی\n";
                $helpText .= "• سیستم امتیازدهی\n";
                $helpText .= "• سطح‌بندی مدیران (۵ سطح)\n";
                $helpText .= "• زمان‌بندی قفل‌ها\n";
                $helpText .= "• لاگ فعالیت‌ها\n\n";
                $helpText .= "📢 کانال: @" . CHANNEL;
            }
            sendMessage($chatId, $helpText);
            break;

        case ($textLower === '🎖️ دستورات امکانات' || $textLower === 'امکانات' || $textLower === '/features'):
            $featuresText = $userData['bot_settings']['features_text'] ?? '';
            if (empty($featuresText)) {
                $featuresText = "<b>🎖️ امکانات ربات تیتان</b>\n\n";
                $featuresText .= "🔒 <b>قفل‌ها (۳۵+ نوع):</b>\n";
                $featuresText .= "لینک، هشتگ، منشن، انگلیسی، عربی، فوروارد، ربات، صدا، ویس، استیکر، گیف، عکس، ویدیو، فایل، نظرسنجی، مخاطب، مکان، متن، ویدیو نوت، اینلاین، شماره، ایموجی زیاد، متن طولانی، بدون متن، کپشن، ویرایش، بازی، فاکتور، لوکیشن لایو، تاس، اسپویلر، تاپیک، استیکر پریمیوم، ایموجی سفارشی، استوری\n\n";
                $featuresText .= "🛡 <b>حفاظت:</b>\n";
                $featuresText .= "ضد اسپم، ضد فلوود، ضد حذف، ضد ربات\n\n";
                $featuresText .= "👮 <b>مدیریت:</b>\n";
                $featuresText .= "۵ سطح مدیریت، هشدار، بن، سکوت زماندار\n\n";
                $featuresText .= "📝 <b>سایر:</b>\n";
                $featuresText .= "فیلتر کلمات، خوش‌آمد سفارشی، کانال الزامی، امتیازدهی، زمان‌بندی\n\n";
                $featuresText .= "📢 @" . CHANNEL;
            }
            sendMessage($chatId, $featuresText);
            break;

        case ($textLower === '🫡 پشتیبانی' || $textLower === 'پشتیبانی' || $textLower === '/support'):
            $supportText = $userData['bot_settings']['support_text'] ?? getDefaultBotSettings()['support_text'];
            sendMessage($chatId, $supportText);
            break;

        case ($textLower === '😍 تبلیغات رایگان' || $textLower === 'تبلیغات'):
            $adText = $userData['bot_settings']['ad_text'] ?? "📢 برای تبلیغات با ما در ارتباط باشید:\n\n📞 @" . CHANNEL;
            sendMessage($chatId, $adText);
            break;

        case ($textLower === '🤖 خرید ربات' || $textLower === 'خرید ربات'):
            sendMessage($chatId, "🤖 <b>خرید ربات مدیریت گروه</b>\n\n💰 برای خرید ربات اختصاصی با پشتیبانی تماس بگیرید:\n\n📞 @" . CHANNEL);
            break;

        case ($textLower === '🛠️ ابزارها' || $textLower === 'ابزارها' || $textLower === '/tools'):
            $kb = [
                'keyboard' => [
                    [['text' => '📊 آمار من'], ['text' => '🆔 آیدی من']],
                    [['text' => '📅 تاریخ و ساعت'], ['text' => '🔗 لینک پروفایل']],
                    [['text' => '🏠 بازگشت به منوی اصلی']],
                ],
                'resize_keyboard' => true,
            ];
            sendMessage($chatId, "🛠️ <b>ابزارها</b>\n\nابزار مورد نظر را انتخاب کنید:", null, $kb);
            break;

        case ($textLower === '📊 آمار من' || $textLower === 'آمار من'):
            $joinDate = $userData['users'][$userId]['joined_at'] ?? 'نامشخص';
            $t = "<b>📊 اطلاعات شما:</b>\n\n";
            $t .= "👤 نام: <b>" . ($message->from->first_name ?? '') . "</b>\n";
            $t .= "🆔 آیدی: <code>{$userId}</code>\n";
            $t .= "📛 یوزرنیم: " . (isset($message->from->username) ? "@{$message->from->username}" : "ندارد") . "\n";
            $t .= "📅 تاریخ عضویت: <b>{$joinDate}</b>\n";
            $t .= "🔰 وضعیت: " . ($isDev ? "👑 توسعه‌دهنده" : ($isSudo ? "⭐ سودو" : "👤 کاربر عادی"));
            sendMessage($chatId, $t);
            break;

        case ($textLower === '🆔 آیدی من' || $textLower === 'آیدی من' || $textLower === '/id'):
            sendMessage($chatId, "🆔 آیدی عددی شما:\n<code>{$userId}</code>");
            break;

        case ($textLower === '📅 تاریخ و ساعت' || $textLower === 'تاریخ'):
            sendMessage($chatId, "📅 تاریخ: <b>" . jdate('Y/m/d') . "</b>\n⏰ ساعت: <b>" . jdate('H:i:s') . "</b>");
            break;

        case ($textLower === '🔗 لینک پروفایل' || $textLower === 'لینک پروفایل'):
            $link = "tg://user?id={$userId}";
            sendMessage($chatId, "🔗 لینک پروفایل شما:\n<a href='{$link}'>کلیک کنید</a>\n\nیا:\n<code>{$link}</code>");
            break;

        case ($textLower === '🏠 بازگشت به منوی اصلی' || $textLower === 'بازگشت'):
            $keyboard = [
                'keyboard' => [
                    [['text' => "➕ افزودن ربات به گروه"]],
                    [['text' => "🔎 راهنما"], ['text' => "🎖️ دستورات امکانات"]],
                    [['text' => "🫡 پشتیبانی"], ['text' => "😍 تبلیغات رایگان"]],
                    [['text' => "🤖 خرید ربات"], ['text' => "🛠️ ابزارها"]],
                ],
                'resize_keyboard' => true,
            ];
            sendMessage($chatId, "🏠 منوی اصلی", null, $keyboard);
            break;

        default:
            sendMessage($chatId, "🤖 از دکمه‌های منو استفاده کنید.\n\nبرای شروع: /start");
            break;
    }
}

// ==================================================================================
//                      پردازش حالت‌های انتظار
// ==================================================================================
function handleAwaiting($message, $chatId, $userId, $msgId, $text, $awaiting, $userData) {
    $devs = unserialize(DEV_IDS);

    switch ($awaiting) {
        case 'add_sudo':
            $targetId = (int)trim($text);
            if ($targetId <= 0) {
                sendMessage($chatId, "❌ آیدی نامعتبر است.");
            } else {
                if (!isset($userData['bot_settings']['sudo_list'])) $userData['bot_settings']['sudo_list'] = [];
                if (in_array($targetId, $userData['bot_settings']['sudo_list'])) {
                    sendMessage($chatId, "⚠️ این کاربر قبلاً سودو است.");
                } else {
                    $userData['bot_settings']['sudo_list'][] = $targetId;
                    sendMessage($chatId, "✅ کاربر <code>{$targetId}</code> به لیست سودو اضافه شد.");
                }
            }
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'remove_sudo':
            $targetId = (int)trim($text);
            if (($key = array_search($targetId, $userData['bot_settings']['sudo_list'])) !== false) {
                unset($userData['bot_settings']['sudo_list'][$key]);
                $userData['bot_settings']['sudo_list'] = array_values($userData['bot_settings']['sudo_list']);
                sendMessage($chatId, "✅ کاربر <code>{$targetId}</code> از لیست سودو حذف شد.");
            } else {
                sendMessage($chatId, "❌ این کاربر در لیست سودو نیست.");
            }
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'leave_group':
            $groupId = (int)trim($text);
            if ($groupId >= 0) {
                sendMessage($chatId, "❌ آیدی گروه باید عدد منفی باشد.");
            } else {
                $res = apiRequest('leaveChat', ['chat_id' => $groupId]);
                if ($res['ok'] ?? false) {
                    sendMessage($chatId, "✅ از گروه <code>{$groupId}</code> خارج شد.");
                } else {
                    sendMessage($chatId, "❌ خطا در خروج از گروه.");
                }
            }
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'block_user':
            $targetId = (int)trim($text);
            if ($targetId <= 0) {
                sendMessage($chatId, "❌ آیدی نامعتبر.");
            } else {
                if (!in_array($targetId, $userData['bot_settings']['blocked_users'])) {
                    $userData['bot_settings']['blocked_users'][] = $targetId;
                    sendMessage($chatId, "✅ کاربر <code>{$targetId}</code> بلاک شد.");
                } else {
                    sendMessage($chatId, "⚠️ این کاربر قبلاً بلاک است.");
                }
            }
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'unblock_user':
            $targetId = (int)trim($text);
            if (($key = array_search($targetId, $userData['bot_settings']['blocked_users'])) !== false) {
                unset($userData['bot_settings']['blocked_users'][$key]);
                $userData['bot_settings']['blocked_users'] = array_values($userData['bot_settings']['blocked_users']);
                sendMessage($chatId, "✅ کاربر <code>{$targetId}</code> آن‌بلاک شد.");
            } else {
                sendMessage($chatId, "❌ این کاربر بلاک نیست.");
            }
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'set_start_text':
            $userData['bot_settings']['start_text'] = $text;
            sendMessage($chatId, "✅ متن استارت تنظیم شد.");
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'set_help_text':
            $userData['bot_settings']['help_text'] = $text;
            sendMessage($chatId, "✅ متن راهنما تنظیم شد.");
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'set_features_text':
            $userData['bot_settings']['features_text'] = $text;
            sendMessage($chatId, "✅ متن امکانات تنظیم شد.");
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'set_support_text':
            $userData['bot_settings']['support_text'] = $text;
            sendMessage($chatId, "✅ متن پشتیبانی تنظیم شد.");
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'set_ad':
            $userData['bot_settings']['ad_text'] = $text;
            sendMessage($chatId, "✅ متن تبلیغ تنظیم شد.");
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'send_to_groups':
            $groups = getGroupsList();
            $sent = 0; $failed = 0;
            foreach ($groups as $gid => $ginfo) {
                $res = sendMessage($gid, $text);
                if ($res && ($res['ok'] ?? false)) $sent++;
                else $failed++;
                usleep(100000);
            }
            sendMessage($chatId, "✅ ارسال تمام شد.\n\n📤 موفق: {$sent}\n❌ ناموفق: {$failed}");
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'send_to_users':
            $sent = 0; $failed = 0;
            foreach ($userData['users'] as $uid => $uinfo) {
                $res = sendMessage($uid, $text);
                if ($res && ($res['ok'] ?? false)) $sent++;
                else $failed++;
                usleep(100000);
            }
            sendMessage($chatId, "✅ ارسال تمام شد.\n\n📤 موفق: {$sent}\n❌ ناموفق: {$failed}");
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'fwd_to_groups':
            $groups = getGroupsList();
            $sent = 0; $failed = 0;
            foreach ($groups as $gid => $ginfo) {
                $res = forwardMessage($gid, $chatId, $msgId);
                if ($res && ($res['ok'] ?? false)) $sent++;
                else $failed++;
                usleep(100000);
            }
            sendMessage($chatId, "✅ فوروارد تمام شد.\n\n📤 موفق: {$sent}\n❌ ناموفق: {$failed}");
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'fwd_to_users':
            $sent = 0; $failed = 0;
            foreach ($userData['users'] as $uid => $uinfo) {
                $res = forwardMessage($uid, $chatId, $msgId);
                if ($res && ($res['ok'] ?? false)) $sent++;
                else $failed++;
                usleep(100000);
            }
            sendMessage($chatId, "✅ فوروارد تمام شد.\n\n📤 موفق: {$sent}\n❌ ناموفق: {$failed}");
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            break;

        case 'msg_user_id':
            $targetId = (int)trim($text);
            if ($targetId <= 0) {
                sendMessage($chatId, "❌ آیدی نامعتبر.");
                $userData['users'][$userId]['awaiting'] = null;
            } else {
                $userData['users'][$userId]['awaiting'] = 'msg_user_text';
                $userData['users'][$userId]['msg_target'] = $targetId;
                sendMessage($chatId, "✅ حالا متن پیام را ارسال کنید:");
            }
            saveUserData($userData);
            break;

        case 'msg_user_text':
            $targetId = $userData['users'][$userId]['msg_target'] ?? 0;
            if ($targetId > 0) {
                $res = sendMessage($targetId, "📨 <b>پیام از مدیریت:</b>\n\n{$text}");
                if ($res && ($res['ok'] ?? false)) {
                    sendMessage($chatId, "✅ پیام به کاربر <code>{$targetId}</code> ارسال شد.");
                } else {
                    sendMessage($chatId, "❌ خطا در ارسال پیام. احتمالاً کاربر ربات را بلاک کرده.");
                }
            }
            $userData['users'][$userId]['awaiting'] = null;
            unset($userData['users'][$userId]['msg_target']);
            saveUserData($userData);
            break;

        default:
            $userData['users'][$userId]['awaiting'] = null;
            saveUserData($userData);
            sendMessage($chatId, "⚠️ عملیات لغو شد. از منو استفاده کنید.");
            break;
    }
}

// ==================================================================================
//                          پیام‌های گروه
// ==================================================================================
function handleGroupMessage($message, $chatId, $userId, $msgId, $text, $textLower) {
    $settings = getGroupSettings($chatId);

    $groupName = $message->chat->title ?? '';
    $groupUsername = $message->chat->username ?? '';
    if ($groupName && $settings['group_name'] !== $groupName) {
        $settings['group_name'] = $groupName;
    }
    if ($groupUsername && $settings['group_username'] !== $groupUsername) {
        $settings['group_username'] = $groupUsername;
    }

    $isOwner = ($userId == $settings['owner_id']);
    $devs = unserialize(DEV_IDS);
    $isDev = in_array($userId, $devs);
    $isAdmin = ($isOwner || in_array($userId, $settings['admins']) || $isDev);
    $isSpecial = in_array($userId, $settings['specials']);
    $adminLevel = getAdminLevel($settings, $userId);

    $resStatus = apiRequest('getChatMember', ['chat_id' => $chatId, 'user_id' => $userId]);
    $tgStatus = ($resStatus['ok'] ?? false) ? $resStatus['result']['status'] : '';
    $isTgAdmin = in_array($tgStatus, ['creator', 'administrator']);
    if ($isTgAdmin) $isAdmin = true;

    $settings = checkMutedUsers($settings, $chatId);

    if (isset($settings['muted_users'][$userId])) {
        deleteMessage($chatId, $msgId);
        return;
    }

    if (in_array($userId, $settings['banned_users'])) {
        apiRequest('banChatMember', ['chat_id' => $chatId, 'user_id' => $userId]);
        return;
    }

    if (!$isAdmin && !$isSpecial && !empty($settings['required_channels'])) {
        $notJoined = [];
        foreach ($settings['required_channels'] as $ch) {
            $res = apiRequest('getChatMember', ['chat_id' => "@{$ch}", 'user_id' => $userId]);
            $st = ($res['ok'] ?? false) ? $res['result']['status'] : 'left';
            if (in_array($st, ['left', 'kicked'])) $notJoined[] = $ch;
        }
        if (!empty($notJoined)) {
            deleteMessage($chatId, $msgId);
            $buttons = [];
            foreach ($notJoined as $ch) {
                $buttons[] = [['text' => "📢 عضویت در @{$ch}", 'url' => "https://t.me/{$ch}"]];
            }
            $buttons[] = [['text' => '✅ عضو شدم', 'callback_data' => 'i_joined']];
            $kb = ['inline_keyboard' => $buttons];
            $mention = "<a href='tg://user?id={$userId}'>" . ($message->from->first_name ?? 'کاربر') . "</a>";
            sendMessage($chatId, "⚠️ {$mention} عزیز!\n\nبرای ارسال پیام ابتدا در کانال‌های زیر عضو شوید:", null, $kb);
            return;
        }
    }

    if (!$isAdmin && !$isSpecial) {
        $lockAction = checkLocks($settings, $message);
        if ($lockAction !== 'off') {
            applyLockAction($lockAction, $chatId, $userId, $msgId);
            return;
        }

        if (checkFilters($settings, $text)) {
            deleteMessage($chatId, $msgId);
            $mention = "<a href='tg://user?id={$userId}'>" . ($message->from->first_name ?? 'کاربر') . "</a>";
            sendMessage($chatId, "⚠️ {$mention} پیام شما حاوی کلمات فیلتر‌شده بود و حذف شد.");
            return;
        }

        if (isSpam($settings, $chatId, $userId)) {
            deleteMessage($chatId, $msgId);
            apiRequest('restrictChatMember', [
                'chat_id' => $chatId,
                'user_id' => $userId,
                'permissions' => json_encode([
                    'can_send_messages' => false,
                    'can_send_media_messages' => false,
                    'can_send_polls' => false,
                    'can_send_other_messages' => false,
                    'can_add_web_page_previews' => false,
                ]),
                'until_date' => time() + 300,
            ]);
            $mention = "<a href='tg://user?id={$userId}'>" . ($message->from->first_name ?? 'کاربر') . "</a>";
            sendMessage($chatId, "🛡 {$mention} به دلیل اسپم به مدت ۵ دقیقه سکوت شد.");
            addLog($chatId, 0, 'اسپم - سکوت خودکار', $userId, '5 دقیقه');
            return;
        }

        if ($settings['anti_flood']['enabled'] && (isset($message->forward_from) || isset($message->forward_from_chat))) {
            if (!isset($settings['anti_flood']['users'][$userId])) {
                $settings['anti_flood']['users'][$userId] = ['count' => 0, 'last' => time()];
            }
            $now = time();
            if ($now - $settings['anti_flood']['users'][$userId]['last'] < 60) {
                $settings['anti_flood']['users'][$userId]['count']++;
            } else {
                $settings['anti_flood']['users'][$userId] = ['count' => 1, 'last' => $now];
            }

            if ($settings['anti_flood']['users'][$userId]['count'] > $settings['anti_flood']['max_forward']) {
                deleteMessage($chatId, $msgId);
                $mention = "<a href='tg://user?id={$userId}'>" . ($message->from->first_name ?? 'کاربر') . "</a>";
                sendMessage($chatId, "🌊 {$mention} فوروارد بیش از حد! لطفاً کمتر فوروارد کنید.");
                $settings['anti_flood']['users'][$userId]['count'] = 0;
            }
            saveGroupSettings($chatId, $settings);
        }
    }

    if (!$isAdmin) {
        $settings = addScore($settings, $userId, 1, $chatId);
        saveGroupSettings($chatId, $settings);
    }

    // بررسی awaiting های گروه
    if ($isAdmin && ($settings['awaiting_welcome_text'] ?? false)) {
        $settings['welcome_text'] = $text;
        $settings['awaiting_welcome_text'] = false;
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "✅ متن خوش‌آمد تنظیم شد.", $msgId);
        return;
    }

    if ($isAdmin && ($settings['awaiting_welcome_media'] ?? false)) {
        $mediaId = null;
        $mediaType = null;
        if (isset($message->photo)) {
            $photos = $message->photo;
            $mediaId = end($photos)->file_id;
            $mediaType = 'photo';
        } elseif (isset($message->animation)) {
            $mediaId = $message->animation->file_id;
            $mediaType = 'animation';
        } elseif (isset($message->video)) {
            $mediaId = $message->video->file_id;
            $mediaType = 'video';
        }

        if ($mediaId) {
            $settings['welcome_media'] = $mediaId;
            $settings['welcome_media_type'] = $mediaType;
            if (isset($message->caption) && $message->caption) {
                $settings['welcome_text'] = $message->caption;
            }
            $settings['awaiting_welcome_media'] = false;
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ مدیای خوش‌آمد تنظیم شد.", $msgId);
        } else {
            sendMessage($chatId, "❌ لطفاً عکس، گیف یا ویدیو ارسال کنید.", $msgId);
        }
        return;
    }

    if ($isAdmin && ($settings['awaiting_channel'] ?? false)) {
        $channel = str_replace('@', '', trim($text));
        if (empty($channel)) {
            sendMessage($chatId, "❌ یوزرنیم نامعتبر.", $msgId);
        } else {
            $action = $settings['channel_action'] ?? 'add';
            if ($action === 'add') {
                if (!in_array($channel, $settings['required_channels'])) {
                    $settings['required_channels'][] = $channel;
                    sendMessage($chatId, "✅ کانال @{$channel} به لیست کانال‌های الزامی اضافه شد.", $msgId);
                    addLog($chatId, $userId, 'افزودن کانال الزامی', null, "@{$channel}");
                } else {
                    sendMessage($chatId, "⚠️ این کانال قبلاً اضافه شده.", $msgId);
                }
            } else {
                $key = array_search($channel, $settings['required_channels']);
                if ($key !== false) {
                    unset($settings['required_channels'][$key]);
                    $settings['required_channels'] = array_values($settings['required_channels']);
                    sendMessage($chatId, "✅ کانال @{$channel} حذف شد.", $msgId);
                    addLog($chatId, $userId, 'حذف کانال الزامی', null, "@{$channel}");
                } else {
                    sendMessage($chatId, "❌ این کانال در لیست نیست.", $msgId);
                }
            }
        }
        $settings['awaiting_channel'] = false;
        $settings['channel_action'] = '';
        saveGroupSettings($chatId, $settings);
        return;
    }

    handleGroupCommands($message, $chatId, $userId, $msgId, $text, $textLower, $settings, $isAdmin, $isOwner, $isDev, $adminLevel);
}

// ==================================================================================
//                        دستورات گروه
// ==================================================================================
function handleGroupCommands($message, $chatId, $userId, $msgId, $text, $textLower, $settings, $isAdmin, $isOwner, $isDev, $adminLevel) {
    $replyMsg = $message->reply_to_message ?? null;
    $replyUserId = $replyMsg->from->id ?? 0;

    // ==================== نصب ====================
    if (in_array($textLower, ['نصب', 'پیکربندی', '/add', '/install'])) {
        if ($isOwner || $isDev) {
            sendMessage($chatId, "⚠️ ربات قبلاً نصب شده.", $msgId);
            return;
        }
        $resStatus = apiRequest('getChatMember', ['chat_id' => $chatId, 'user_id' => $userId]);
        $status = ($resStatus['ok'] ?? false) ? $resStatus['result']['status'] : '';
        if ($status !== 'creator') {
            sendMessage($chatId, "⚠️ فقط سازنده گروه می‌تواند ربات را نصب کند.", $msgId);
            return;
        }
        $settings['owner_id'] = $userId;
        $settings['created_at'] = jdate('Y/m/d H:i');
        $settings['group_name'] = $message->chat->title ?? '';
        $settings['group_username'] = $message->chat->username ?? '';
        saveGroupSettings($chatId, $settings);

        addGroupToList($chatId, $message->chat->title ?? '', $message->chat->username ?? '');
        addLog($chatId, $userId, 'نصب ربات');

        // ===== پیام نصب جدید =====
        $installText = "💻 ربات با موفقیت نصب شده است.\n\n";
        $installText .= "┈┅┅━آغاز نصب━┅┅┈\n\n";
        $installText .= "✨مالکان و مدیران با موفقیت ترفیع یافتند ، درصورت دیلیتی مالک گروه ، مدیرانی که دسترسی کامل دارند به عنوان مالک ربات برگزیده می‌شوند ⬩\n\n";
        $installText .= "🔒 قفل های پیشفرض لینک ، فوروارد ، ربات فعال شدند ⬩\n\n";
        $installText .= "📆 جهت تنظیم ربات دستور پنل یا راهنما را ارسال کنید ⬩\n\n";
        $installText .= "┈┅┅━اتمام نصب━┅┅┈\n\n";
        $installText .= "⛔️ از طریق دکمه های زیر درخواست پشتیبانی کنید ⬩";

        $botLink = "https://t.me/" . BOT_USERNAME . "?startgroup=true";
        $kb = ['inline_keyboard' => [
            [['text' => '📞 ارتباط مستقیم با سازنده', 'url' => 'https://t.me/hamsterIIR']],
            [
                ['text' => '📢 کانال', 'url' => 'https://t.me/TITANN0098'],
                ['text' => '💬 گروه', 'url' => 'https://t.me/pantehr2026'],
            ],
            [['text' => '➕ افزودن ربات به گروه جدید', 'url' => $botLink]],
        ]];
        sendMessage($chatId, $installText, null, $kb);
        return;
    }

    // ==================== پنل ====================
    if (in_array($textLower, ['پنل', '/panel'])) {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        $kb = ['inline_keyboard' => [
            [
                ['text' => '🪪 اطلاعات', 'callback_data' => 'submenu_info'],
                ['text' => '🔒 قفل‌ها', 'callback_data' => 'submenu_locks'],
            ],
            [
                ['text' => '🛠️ تنظیمات', 'callback_data' => 'submenu_settings_main'],
                ['text' => '🔍 راهنما', 'callback_data' => 'show_help'],
            ],
            [['text' => '❌ بستن پنل', 'callback_data' => 'close_panel']],
        ]];
        sendMessage($chatId, "<b>🤖 پنل مدیریت تیتان 🥇</b>\n\nبخش مورد نظر خود را انتخاب کنید:\n┈┅━ صفحه اصلی ━┅┈", null, $kb);
        return;
    }

    // ==================== ادمین ====================
    if (preg_match('/^(ادمین|\/admin)\s*(\d*)$/u', $textLower, $m)) {
        if (!$isOwner && !$isDev && !hasPermission($settings, $userId, 5)) {
            sendMessage($chatId, "⛔ فقط مالک یا نایب مالک!", $msgId);
            return;
        }
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام کاربر ریپلای بزنید.", $msgId); return; }
        $level = !empty($m[2]) ? (int)$m[2] : 3;
        if ($level < 1 || $level > 5) { sendMessage($chatId, "⚠️ سطح باید بین ۱ تا ۵ باشد.", $msgId); return; }
        if ($level >= $adminLevel && !$isOwner && !$isDev) {
            sendMessage($chatId, "⚠️ نمی‌توانید سطح برابر یا بالاتر از خود تعیین کنید.", $msgId);
            return;
        }

        $targetId = $replyUserId;
        if (!in_array($targetId, $settings['admins'])) {
            $settings['admins'][] = $targetId;
        }
        $settings['admin_levels'][$targetId] = $level;
        saveGroupSettings($chatId, $settings);

        $levelName = getAdminLevelName($level);
        $mention = "<a href='tg://user?id={$targetId}'>" . ($replyMsg->from->first_name ?? $targetId) . "</a>";
        sendMessage($chatId, "✅ {$mention} به عنوان مدیر ربات با سطح {$levelName} ({$level}) تعیین شد.", $msgId);
        addLog($chatId, $userId, 'افزودن مدیر', $targetId, "سطح {$level}");
        return;
    }

    // ==================== حذف ادمین ====================
    if (in_array($textLower, ['حذف ادمین', '/removeadmin'])) {
        if (!$isOwner && !$isDev && !hasPermission($settings, $userId, 5)) {
            sendMessage($chatId, "⛔ فقط مالک یا نایب مالک!", $msgId);
            return;
        }
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام مدیر ریپلای بزنید.", $msgId); return; }
        $targetId = $replyUserId;
        $key = array_search($targetId, $settings['admins']);
        if ($key !== false) {
            unset($settings['admins'][$key]);
            $settings['admins'] = array_values($settings['admins']);
            unset($settings['admin_levels'][$targetId]);
            saveGroupSettings($chatId, $settings);
            $mention = "<a href='tg://user?id={$targetId}'>" . ($replyMsg->from->first_name ?? $targetId) . "</a>";
            sendMessage($chatId, "✅ {$mention} از لیست مدیران حذف شد.", $msgId);
            addLog($chatId, $userId, 'حذف مدیر', $targetId);
        } else {
            sendMessage($chatId, "❌ این کاربر مدیر ربات نیست.", $msgId);
        }
        return;
    }

    // ==================== ویژه ====================
    if ($textLower === 'ویژه' || $textLower === '/special') {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام کاربر ریپلای بزنید.", $msgId); return; }
        $targetId = $replyUserId;
        if (!in_array($targetId, $settings['specials'])) {
            $settings['specials'][] = $targetId;
            saveGroupSettings($chatId, $settings);
            $mention = "<a href='tg://user?id={$targetId}'>" . ($replyMsg->from->first_name ?? $targetId) . "</a>";
            sendMessage($chatId, "✅ {$mention} به لیست کاربران ویژه اضافه شد.", $msgId);
            addLog($chatId, $userId, 'افزودن ویژه', $targetId);
        } else {
            sendMessage($chatId, "⚠️ این کاربر قبلاً ویژه است.", $msgId);
        }
        return;
    }

    if (in_array($textLower, ['حذف ویژه', '/removespecial'])) {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام کاربر ریپلای بزنید.", $msgId); return; }
        $targetId = $replyUserId;
        $key = array_search($targetId, $settings['specials']);
        if ($key !== false) {
            unset($settings['specials'][$key]);
            $settings['specials'] = array_values($settings['specials']);
            saveGroupSettings($chatId, $settings);
            $mention = "<a href='tg://user?id={$targetId}'>" . ($replyMsg->from->first_name ?? $targetId) . "</a>";
            sendMessage($chatId, "✅ {$mention} از لیست ویژه حذف شد.", $msgId);
            addLog($chatId, $userId, 'حذف ویژه', $targetId);
        } else {
            sendMessage($chatId, "❌ این کاربر ویژه نیست.", $msgId);
        }
        return;
    }

    // ==================== هشدار ====================
    if (in_array($textLower, ['هشدار', '/warn'])) {
        if (!$isAdmin || !hasPermission($settings, $userId, 2)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام کاربر ریپلای بزنید.", $msgId); return; }
        $targetId = $replyUserId;
        if (in_array($targetId, $settings['admins']) || $targetId == $settings['owner_id']) {
            sendMessage($chatId, "⚠️ نمی‌توانید به مدیر هشدار بدهید!", $msgId);
            return;
        }

        if (!isset($settings['warns'][$targetId])) $settings['warns'][$targetId] = 0;
        $settings['warns'][$targetId]++;
        $warnCount = $settings['warns'][$targetId];
        $warnLimit = $settings['warn_limit'];
        $mention = "<a href='tg://user?id={$targetId}'>" . ($replyMsg->from->first_name ?? $targetId) . "</a>";

        if ($warnCount >= $warnLimit) {
            apiRequest('banChatMember', ['chat_id' => $chatId, 'user_id' => $targetId]);
            if (!in_array($targetId, $settings['banned_users'])) {
                $settings['banned_users'][] = $targetId;
            }
            unset($settings['warns'][$targetId]);
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "🚫 {$mention} به دلیل رسیدن به حداکثر هشدار ({$warnLimit}) مسدود شد!", $msgId);
            addLog($chatId, $userId, 'بن (حداکثر هشدار)', $targetId);
        } else {
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "⚠️ {$mention} هشدار دریافت کرد!\n\n📊 هشدار: {$warnCount}/{$warnLimit}", $msgId);
            addLog($chatId, $userId, 'هشدار', $targetId, "{$warnCount}/{$warnLimit}");
        }
        return;
    }

    // ==================== بن ====================
    if (in_array($textLower, ['بن', '/ban'])) {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام کاربر ریپلای بزنید.", $msgId); return; }
        $targetId = $replyUserId;
        if (in_array($targetId, $settings['admins']) || $targetId == $settings['owner_id']) {
            sendMessage($chatId, "⚠️ نمی‌توانید مدیر را بن کنید!", $msgId);
            return;
        }
        apiRequest('banChatMember', ['chat_id' => $chatId, 'user_id' => $targetId]);
        if (!in_array($targetId, $settings['banned_users'])) {
            $settings['banned_users'][] = $targetId;
        }
        saveGroupSettings($chatId, $settings);
        $mention = "<a href='tg://user?id={$targetId}'>" . ($replyMsg->from->first_name ?? $targetId) . "</a>";
        sendMessage($chatId, "🚫 {$mention} مسدود شد!", $msgId);
        addLog($chatId, $userId, 'بن', $targetId);
        return;
    }

    // ==================== آن‌بن ====================
    if (preg_match('/^(\/unban)\s+(\d+)$/i', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $targetId = (int)$m[2];
        apiRequest('unbanChatMember', ['chat_id' => $chatId, 'user_id' => $targetId, 'only_if_banned' => true]);
        $key = array_search($targetId, $settings['banned_users']);
        if ($key !== false) {
            unset($settings['banned_users'][$key]);
            $settings['banned_users'] = array_values($settings['banned_users']);
        }
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "✅ کاربر <code>{$targetId}</code> آن‌بن شد.", $msgId);
        addLog($chatId, $userId, 'آن‌بن', $targetId);
        return;
    }

    // ==================== سایلنت ====================
    if (preg_match('/^(سایلنت|\/mute)\s*(\d*)$/u', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 2)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام کاربر ریپلای بزنید.", $msgId); return; }
        $targetId = $replyUserId;
        if (in_array($targetId, $settings['admins']) || $targetId == $settings['owner_id']) {
            sendMessage($chatId, "⚠️ نمی‌توانید مدیر را سکوت کنید!", $msgId);
            return;
        }

        $duration = !empty($m[2]) ? (int)$m[2] : 0;
        $untilDate = $duration > 0 ? time() + ($duration * 60) : 0;

        $params = [
            'chat_id' => $chatId,
            'user_id' => $targetId,
            'permissions' => json_encode([
                'can_send_messages' => false,
                'can_send_media_messages' => false,
                'can_send_polls' => false,
                'can_send_other_messages' => false,
                'can_add_web_page_previews' => false,
            ]),
        ];
        if ($untilDate > 0) $params['until_date'] = $untilDate;
        apiRequest('restrictChatMember', $params);

        $settings['muted_users'][$targetId] = [
            'until' => $untilDate,
            'by' => $userId,
            'at' => time(),
        ];
        saveGroupSettings($chatId, $settings);

        $mention = "<a href='tg://user?id={$targetId}'>" . ($replyMsg->from->first_name ?? $targetId) . "</a>";
        $durationText = $duration > 0 ? "{$duration} دقیقه" : 'دائمی';
        sendMessage($chatId, "🔇 {$mention} سکوت شد!\n⏱ مدت: {$durationText}", $msgId);
        addLog($chatId, $userId, 'سکوت', $targetId, $durationText);
        return;
    }

    // ==================== آن‌سایلنت ====================
    if (in_array($textLower, ['آن‌سایلنت', 'آنسایلنت', '/unmute'])) {
        if (!$isAdmin || !hasPermission($settings, $userId, 2)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام کاربر ریپلای بزنید.", $msgId); return; }
        $targetId = $replyUserId;

        apiRequest('restrictChatMember', [
            'chat_id' => $chatId,
            'user_id' => $targetId,
            'permissions' => json_encode([
                'can_send_messages' => true,
                'can_send_media_messages' => true,
                'can_send_polls' => true,
                'can_send_other_messages' => true,
                'can_add_web_page_previews' => true,
                'can_invite_users' => true,
            ]),
        ]);
        unset($settings['muted_users'][$targetId]);
        saveGroupSettings($chatId, $settings);

        $mention = "<a href='tg://user?id={$targetId}'>" . ($replyMsg->from->first_name ?? $targetId) . "</a>";
        sendMessage($chatId, "🔊 {$mention} از حالت سکوت خارج شد.", $msgId);
        addLog($chatId, $userId, 'لغو سکوت', $targetId);
        return;
    }

    // ==================== قفل دستوری ====================
    if (preg_match('/^(قفل|\/lock)\s+(.+)$/u', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $lockTarget = trim($m[2]);
        $lockResult = applyLockCommand($settings, $lockTarget, 'delete');
        if ($lockResult['success']) {
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "🔒 {$lockResult['name']} قفل شد.", $msgId);
            addLog($chatId, $userId, "قفل {$lockResult['name']}");
        } else {
            sendMessage($chatId, "❌ قفل نامعتبر: {$lockTarget}", $msgId);
        }
        return;
    }

    // ==================== بازکردن قفل ====================
    if (preg_match('/^(بازکردن|\/unlock)\s+(.+)$/u', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $lockTarget = trim($m[2]);
        $lockResult = applyLockCommand($settings, $lockTarget, 'off');
        if ($lockResult['success']) {
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "🔓 {$lockResult['name']} باز شد.", $msgId);
            addLog($chatId, $userId, "بازکردن {$lockResult['name']}");
        } else {
            sendMessage($chatId, "❌ قفل نامعتبر: {$lockTarget}", $msgId);
        }
        return;
    }

    // ==================== قفل همه / بازکردن همه ====================
    if (in_array($textLower, ['قفل همه', '/lockall'])) {
        if (!$isOwner && !$isDev) { sendMessage($chatId, "⛔ فقط مالک!", $msgId); return; }
        foreach ($settings['locks'] as $k => &$v) { $v = 'delete'; }
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "🔒 همه قفل‌ها فعال شدند.", $msgId);
        addLog($chatId, $userId, 'قفل همه');
        return;
    }

    if (in_array($textLower, ['بازکردن همه', '/unlockall'])) {
        if (!$isOwner && !$isDev) { sendMessage($chatId, "⛔ فقط مالک!", $msgId); return; }
        foreach ($settings['locks'] as $k => &$v) { $v = 'off'; }
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "🔓 همه قفل‌ها غیرفعال شدند.", $msgId);
        addLog($chatId, $userId, 'بازکردن همه');
        return;
    }

    // ==================== ضد اسپم ====================
    if (preg_match('/^\/antispam\s+(on|off)$/i', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 4)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $settings['anti_spam']['enabled'] = ($m[1] === 'on');
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "🛡 ضد اسپم " . ($m[1] === 'on' ? 'فعال' : 'غیرفعال') . " شد.", $msgId);
        addLog($chatId, $userId, 'تغییر ضد اسپم', null, $m[1]);
        return;
    }

    // ==================== ضد حذف ====================
    if (preg_match('/^\/antidelete\s+(on|off)$/i', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 4)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $settings['anti_delete'] = ($m[1] === 'on');
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "🗑 ضد حذف " . ($m[1] === 'on' ? 'فعال' : 'غیرفعال') . " شد.", $msgId);
        addLog($chatId, $userId, 'تغییر ضد حذف', null, $m[1]);
        return;
    }

    // ==================== ضد فلوود ====================
    if (preg_match('/^\/antiflood\s+(on|off)$/i', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 4)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $settings['anti_flood']['enabled'] = ($m[1] === 'on');
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "🌊 ضد فلوود " . ($m[1] === 'on' ? 'فعال' : 'غیرفعال') . " شد.", $msgId);
        addLog($chatId, $userId, 'تغییر ضد فلوود', null, $m[1]);
        return;
    }

    // ==================== ضد ربات ====================
    if (preg_match('/^\/antibot\s+(on|off)$/i', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 4)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $settings['anti_bot'] = ($m[1] === 'on');
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "🤖 ضد ربات " . ($m[1] === 'on' ? 'فعال' : 'غیرفعال') . " شد.", $msgId);
        addLog($chatId, $userId, 'تغییر ضد ربات', null, $m[1]);
        return;
    }

    // ==================== فیلتر ====================
    if (preg_match('/^\/addfilter\s+(.+)$/iu', $text, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $word = trim($m[1]);
        if (!in_array($word, $settings['filter'])) {
            $settings['filter'][] = $word;
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ کلمه «{$word}» به فیلتر اضافه شد.", $msgId);
            addLog($chatId, $userId, 'افزودن فیلتر', null, $word);
        } else {
            sendMessage($chatId, "⚠️ این کلمه قبلاً در فیلتر است.", $msgId);
        }
        return;
    }

    if (preg_match('/^\/delfilter\s+(.+)$/iu', $text, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $word = trim($m[1]);
        $key = array_search($word, $settings['filter']);
        if ($key !== false) {
            unset($settings['filter'][$key]);
            $settings['filter'] = array_values($settings['filter']);
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ کلمه «{$word}» از فیلتر حذف شد.", $msgId);
            addLog($chatId, $userId, 'حذف فیلتر', null, $word);
        } else {
            sendMessage($chatId, "❌ این کلمه در فیلتر نیست.", $msgId);
        }
        return;
    }

    if ($textLower === '/filterlist') {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        $t = "📋 لیست فیلترها:\n\n";
        if (empty($settings['filter'])) {
            $t .= "خالی";
        } else {
            foreach ($settings['filter'] as $fw) {
                $t .= "• {$fw}\n";
            }
        }
        sendMessage($chatId, $t, $msgId);
        return;
    }

    // ==================== تنظیم حد هشدار ====================
    if (preg_match('/^\/setwarn\s+(\d+)$/i', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $limit = (int)$m[1];
        if ($limit < 1 || $limit > 20) {
            sendMessage($chatId, "⚠️ حد هشدار باید بین ۱ تا ۲۰ باشد.", $msgId);
            return;
        }
        $settings['warn_limit'] = $limit;
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "✅ حد هشدار به {$limit} تنظیم شد.", $msgId);
        addLog($chatId, $userId, 'تنظیم حد هشدار', null, $limit);
        return;
    }

    // ==================== ریست هشدارها ====================
    if (preg_match('/^\/resetwarns\s+(\d+)$/i', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $targetId = (int)$m[1];
        unset($settings['warns'][$targetId]);
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "✅ هشدارهای کاربر <code>{$targetId}</code> ریست شد.", $msgId);
        addLog($chatId, $userId, 'ریست هشدار', $targetId);
        return;
    }

    // ==================== مدیریت لینک ====================
    if (preg_match('/^\/allowlink\s+(.+)$/iu', $text, $m)) {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        $link = trim($m[1]);
        if (!in_array($link, $settings['link_whitelist'])) {
            $settings['link_whitelist'][] = $link;
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ لینک «{$link}» مجاز شد.", $msgId);
            addLog($chatId, $userId, 'مجاز لینک', null, $link);
        } else {
            sendMessage($chatId, "⚠️ این لینک قبلاً مجاز است.", $msgId);
        }
        return;
    }

    if (preg_match('/^\/removelink\s+(.+)$/iu', $text, $m)) {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        $link = trim($m[1]);
        $key = array_search($link, $settings['link_whitelist']);
        if ($key !== false) {
            unset($settings['link_whitelist'][$key]);
            $settings['link_whitelist'] = array_values($settings['link_whitelist']);
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ لینک «{$link}» از لیست مجاز حذف شد.", $msgId);
        } else {
            sendMessage($chatId, "❌ این لینک در لیست مجاز نیست.", $msgId);
        }
        return;
    }

    if ($textLower === '/linklist') {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        $t = "🔗 لینک‌های مجاز:\n\n";
        if (empty($settings['link_whitelist'])) {
            $t .= "خالی";
        } else {
            foreach ($settings['link_whitelist'] as $lnk) {
                $t .= "• {$lnk}\n";
            }
        }
        sendMessage($chatId, $t, $msgId);
        return;
    }

    // ==================== خوش‌آمد دستوری ====================
    if (preg_match('/^\/setwelcome\s+(.+)$/ius', $text, $m)) {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        if ($replyMsg && isset($replyMsg->photo)) {
            $photos = $replyMsg->photo;
            $settings['welcome_media'] = end($photos)->file_id;
            $settings['welcome_media_type'] = 'photo';
        }
        $settings['welcome_text'] = trim($m[1]);
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "✅ متن خوش‌آمد تنظیم شد.", $msgId);
        addLog($chatId, $userId, 'تنظیم متن خوش‌آمد');
        return;
    }

    if ($textLower === '/setwelcome' && $replyMsg) {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        if (isset($replyMsg->photo)) {
            $photos = $replyMsg->photo;
            $settings['welcome_media'] = end($photos)->file_id;
            $settings['welcome_media_type'] = 'photo';
            if (isset($replyMsg->caption)) $settings['welcome_text'] = $replyMsg->caption;
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ عکس خوش‌آمد تنظیم شد.", $msgId);
            addLog($chatId, $userId, 'تنظیم عکس خوش‌آمد');
        } elseif (isset($replyMsg->animation)) {
            $settings['welcome_media'] = $replyMsg->animation->file_id;
            $settings['welcome_media_type'] = 'animation';
            if (isset($replyMsg->caption)) $settings['welcome_text'] = $replyMsg->caption;
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ گیف خوش‌آمد تنظیم شد.", $msgId);
            addLog($chatId, $userId, 'تنظیم گیف خوش‌آمد');
        } elseif (isset($replyMsg->video)) {
            $settings['welcome_media'] = $replyMsg->video->file_id;
            $settings['welcome_media_type'] = 'video';
            if (isset($replyMsg->caption)) $settings['welcome_text'] = $replyMsg->caption;
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ ویدیو خوش‌آمد تنظیم شد.", $msgId);
            addLog($chatId, $userId, 'تنظیم ویدیو خوش‌آمد');
        }
        return;
    }

    if ($textLower === '/resetwelcome') {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        $settings['welcome_text'] = '';
        $settings['welcome_media'] = null;
        $settings['welcome_media_type'] = null;
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "✅ خوش‌آمد به حالت پیش‌فرض بازگشت.", $msgId);
        addLog($chatId, $userId, 'ریست خوش‌آمد');
        return;
    }

    if (preg_match('/^\/welcome\s+(on|off)$/i', $textLower, $m)) {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        $settings['welcome_enabled'] = ($m[1] === 'on');
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "👋 خوش‌آمد " . ($m[1] === 'on' ? 'فعال' : 'غیرفعال') . " شد.", $msgId);
        addLog($chatId, $userId, 'تغییر خوش‌آمد', null, $m[1]);
        return;
    }

    // ==================== زمان‌بندی ====================
    if (preg_match('/^\/schedule\s+(\d{1,2}:\d{2})\s+(\d{1,2}:\d{2})$/i', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 4)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $settings['schedule_locks']['start'] = $m[1];
        $settings['schedule_locks']['end'] = $m[2];
        $settings['schedule_locks']['enabled'] = true;
        saveGroupSettings($chatId, $settings);
        sendMessage($chatId, "⏰ زمان‌بندی قفل‌ها تنظیم شد:\nاز {$m[1]} تا {$m[2]}", $msgId);
        addLog($chatId, $userId, 'تنظیم زمان‌بندی', null, "{$m[1]} - {$m[2]}");
        return;
    }

    // ==================== پین ====================
    if ($textLower === '/pin') {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام مورد نظر ریپلای بزنید.", $msgId); return; }
        apiRequest('pinChatMessage', ['chat_id' => $chatId, 'message_id' => $replyMsg->message_id]);
        sendMessage($chatId, "📌 پیام پین شد.", $msgId);
        addLog($chatId, $userId, 'پین پیام');
        return;
    }

    if ($textLower === '/unpin') {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        apiRequest('unpinChatMessage', ['chat_id' => $chatId]);
        sendMessage($chatId, "📌 پیام آن‌پین شد.", $msgId);
        addLog($chatId, $userId, 'آن‌پین');
        return;
    }

    // ==================== پاک‌سازی ====================
    if (preg_match('/^\/purge\s+(\d+)$/i', $textLower, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 4)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $count = min((int)$m[1], 100);
        for ($i = 0; $i < $count; $i++) {
            deleteMessage($chatId, $msgId - $i);
        }
        $tmpMsg = sendMessage($chatId, "🗑 {$count} پیام حذف شد.");
        addLog($chatId, $userId, 'پاک‌سازی پیام', null, "{$count} پیام");
        sleep(3);
        if ($tmpMsg && ($tmpMsg['ok'] ?? false)) {
            deleteMessage($chatId, $tmpMsg['result']['message_id']);
        }
        return;
    }

    // ==================== گزارش ====================
    if ($textLower === '/report') {
        if (!$replyMsg) { sendMessage($chatId, "⚠️ روی پیام مورد نظر ریپلای بزنید.", $msgId); return; }
        $reportLimit = $settings['report_limit'] ?? 3;
        $today = date('Y-m-d');
        if (!isset($settings['report_counts'][$userId])) {
            $settings['report_counts'][$userId] = ['date' => $today, 'count' => 0];
        }
        if ($settings['report_counts'][$userId]['date'] !== $today) {
            $settings['report_counts'][$userId] = ['date' => $today, 'count' => 0];
        }
        if ($settings['report_counts'][$userId]['count'] >= $reportLimit) {
            sendMessage($chatId, "⚠️ شما به حداکثر گزارش روزانه رسیده‌اید.", $msgId);
            return;
        }
        $settings['report_counts'][$userId]['count']++;
        saveGroupSettings($chatId, $settings);

        $ownerId = $settings['owner_id'];
        $reporter = "<a href='tg://user?id={$userId}'>" . ($message->from->first_name ?? 'کاربر') . "</a>";
        $reported = "<a href='tg://user?id={$replyUserId}'>" . ($replyMsg->from->first_name ?? 'کاربر') . "</a>";
        $groupTitle = $message->chat->title ?? '';

        $t = "🚨 <b>گزارش جدید!</b>\n\n";
        $t .= "👤 گزارش‌دهنده: {$reporter}\n";
        $t .= "🎯 کاربر گزارش‌شده: {$reported}\n";
        $t .= "💬 گروه: {$groupTitle}\n";
        if (isset($replyMsg->text)) $t .= "\n📝 پیام: <code>" . mb_substr($replyMsg->text, 0, 200) . "</code>";

        sendMessage($ownerId, $t);
        sendMessage($chatId, "✅ گزارش شما به مالک ارسال شد.", $msgId);
        return;
    }

    // ==================== اطلاعات کاربر ====================
    if ($textLower === '/info') {
        $targetUser = $replyMsg ? $replyMsg->from : $message->from;
        $targetId = $targetUser->id ?? 0;
        $firstName = $targetUser->first_name ?? '';
        $lastName = $targetUser->last_name ?? '';
        $username = $targetUser->username ?? '';

        $score = $settings['scores'][$targetId] ?? 0;
        $warnCount = $settings['warns'][$targetId] ?? 0;
        $isMuted = isset($settings['muted_users'][$targetId]) ? '✅' : '❌';
        $isBanned = in_array($targetId, $settings['banned_users']) ? '✅' : '❌';
        $isSpecialUser = in_array($targetId, $settings['specials']) ? '✅' : '❌';
        $isAdminUser = in_array($targetId, $settings['admins']) ? '✅' : '❌';
        $level = getAdminLevel($settings, $targetId);
        $levelName = getAdminLevelName($level);

        $t = "<b>👤 اطلاعات کاربر:</b>\n\n";
        $t .= "📛 نام: <b>{$firstName} {$lastName}</b>\n";
        $t .= "🆔 آیدی: <code>{$targetId}</code>\n";
        $t .= "📎 یوزرنیم: " . ($username ? "@{$username}" : "ندارد") . "\n";
        $t .= "🏅 سطح: {$levelName}\n";
        $t .= "⭐ امتیاز: <b>{$score}</b>\n";
        $t .= "⚠️ هشدار: <b>{$warnCount}/{$settings['warn_limit']}</b>\n";
        $t .= "👮 مدیر: {$isAdminUser}\n";
        $t .= "🌟 ویژه: {$isSpecialUser}\n";
        $t .= "🔇 سکوت: {$isMuted}\n";
        $t .= "🚫 مسدود: {$isBanned}\n";
        $t .= "\n🔗 <a href='tg://user?id={$targetId}'>لینک پروفایل</a>";
        sendMessage($chatId, $t, $msgId);
        return;
    }

    // ==================== رتبه‌بندی ====================
    if ($textLower === '/top') {
        $top = getTopMembers($settings);
        $t = "<b>🏆 رتبه‌بندی فعالترین‌ها:</b>\n\n";
        if (empty($top)) {
            $t .= "<i>هنوز امتیازی ثبت نشده.</i>";
        } else {
            $medals = ['🥇', '🥈', '🥉'];
            $i = 0;
            foreach ($top as $uid => $score) {
                $medal = $medals[$i] ?? ($i + 1) . '.';
                $t .= "{$medal} <a href='tg://user?id={$uid}'>{$uid}</a> - {$score} امتیاز\n";
                $i++;
            }
        }
        sendMessage($chatId, $t, $msgId);
        return;
    }

    // ==================== تگ همه ====================
    if ($textLower === '/tagall') {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $resMembers = apiRequest('getChatAdministrators', ['chat_id' => $chatId]);
        if ($resMembers['ok'] ?? false) {
            $t = "📢 <b>تگ مدیران:</b>\n\n";
            foreach ($resMembers['result'] as $adm) {
                $u = $adm['user'];
                if (!($u['is_bot'] ?? false)) {
                    $t .= "<a href='tg://user?id={$u['id']}'>" . ($u['first_name'] ?? '') . "</a>\n";
                }
            }
            sendMessage($chatId, $t);
        }
        return;
    }

    // ==================== لاگ ====================
    if ($textLower === '/logs') {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        $logs = getLogs($chatId, 15);
        $t = "<b>📜 آخرین فعالیت‌ها:</b>\n\n";
        if (empty($logs)) {
            $t .= "<i>هیچ لاگی ثبت نشده.</i>";
        } else {
            foreach ($logs as $log) {
                $t .= "⏰ {$log['time']}\n";
                $t .= "👤 <a href='tg://user?id={$log['admin_id']}'>{$log['admin_id']}</a>\n";
                $t .= "📝 {$log['action']}";
                if ($log['target_id']) $t .= " → <a href='tg://user?id={$log['target_id']}'>{$log['target_id']}</a>";
                if ($log['details']) $t .= " ({$log['details']})";
                $t .= "\n─────\n";
            }
        }
        sendMessage($chatId, $t, $msgId);
        return;
    }

    // ==================== مجاز کردن ربات ====================
    if (preg_match('/^\/allowbot\s+@?(.+)$/i', $text, $m)) {
        if (!$isAdmin || !hasPermission($settings, $userId, 3)) {
            sendMessage($chatId, "⛔ سطح دسترسی کافی ندارید!", $msgId);
            return;
        }
        $botUsername = strtolower(trim($m[1]));
        if (!in_array($botUsername, $settings['allowed_bots'])) {
            $settings['allowed_bots'][] = $botUsername;
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ ربات @{$botUsername} مجاز شد.", $msgId);
            addLog($chatId, $userId, 'مجاز ربات', null, "@{$botUsername}");
        } else {
            sendMessage($chatId, "⚠️ این ربات قبلاً مجاز است.", $msgId);
        }
        return;
    }

    if (preg_match('/^\/removebot\s+@?(.+)$/i', $text, $m)) {
        if (!$isAdmin) { sendMessage($chatId, "⛔ دسترسی ندارید!", $msgId); return; }
        $botUsername = strtolower(trim($m[1]));
        $key = array_search($botUsername, $settings['allowed_bots']);
        if ($key !== false) {
            unset($settings['allowed_bots'][$key]);
            $settings['allowed_bots'] = array_values($settings['allowed_bots']);
            saveGroupSettings($chatId, $settings);
            sendMessage($chatId, "✅ ربات @{$botUsername} از لیست مجاز حذف شد.", $msgId);
        } else {
            sendMessage($chatId, "❌ این ربات در لیست مجاز نیست.", $msgId);
        }
        return;
    }

    // ==================== پاسخ‌های رندم ====================
    $botNames = ['ربات', 'تیتان', 'titan', '@' . BOT_USERNAME, BOT_USERNAME];
    foreach ($botNames as $bn) {
        if (mb_stripos($textLower, $bn) !== false) {
            sendMessage($chatId, getRandomBotResponse(), $msgId);
            return;
        }
    }

    // ==================== پینگ ====================
    if (in_array($textLower, ['پینگ', 'ping', '/ping'])) {
        sendMessage($chatId, getRandomPingResponse(), $msgId);
        return;
    }

    // ==================== تراختور ====================
    if (mb_stripos($textLower, 'تراختور') !== false || mb_stripos($textLower, 'تراکتور') !== false) {
        sendMessage($chatId, getRandomTractorResponse(), $msgId);
        return;
    }
}

// ==================================================================================
//                        مدیریت اعضای جدید
// ==================================================================================
function handleNewMembers($message) {
    $chatId = $message->chat->id;
    $settings = getGroupSettings($chatId);
    $addedBy = $message->from->id ?? 0;

    foreach ($message->new_chat_members as $newUser) {
        $newUserId = $newUser->id ?? 0;

        // ضد ربات
        if (($newUser->is_bot ?? false) && $settings['anti_bot']) {
            $botUsername = strtolower($newUser->username ?? '');
            if ($botUsername !== strtolower(BOT_USERNAME) && !in_array($botUsername, $settings['allowed_bots'])) {
                apiRequest('banChatMember', ['chat_id' => $chatId, 'user_id' => $newUserId]);
                sleep(1);
                apiRequest('unbanChatMember', ['chat_id' => $chatId, 'user_id' => $newUserId, 'only_if_banned' => true]);
                sendMessage($chatId, "🤖 ربات @{$botUsername} به دلیل فعال بودن ضد ربات اخراج شد.");
                addLog($chatId, 0, 'اخراج ربات', $newUserId, "@{$botUsername}");
                continue;
            }
        }

        // بررسی بن
        if (in_array($newUserId, $settings['banned_users'])) {
            apiRequest('banChatMember', ['chat_id' => $chatId, 'user_id' => $newUserId]);
            continue;
        }

        // شمارش اد
        if ($addedBy && $addedBy !== $newUserId) {
            if (!isset($settings['add_counts'][$addedBy])) $settings['add_counts'][$addedBy] = 0;
            $settings['add_counts'][$addedBy]++;
            $settings = addScore($settings, $addedBy, 3, $chatId);
        }

        // خوش‌آمدگویی
        if ($settings['welcome_enabled'] && !($newUser->is_bot ?? false)) {
            $resMembers = apiRequest('getChatMembersCount', ['chat_id' => $chatId]);
            $memberCount = ($resMembers['ok'] ?? false) ? $resMembers['result'] : 0;

            $welcomeText = $settings['welcome_text'] ?: getDefaultWelcomeText();
            $welcomeText = formatWelcomeText($welcomeText, $newUser, $chatId, $memberCount);

            if ($settings['welcome_media']) {
                switch ($settings['welcome_media_type']) {
                    case 'photo':
                        sendPhoto($chatId, $settings['welcome_media'], $welcomeText);
                        break;
                    case 'animation':
                        sendAnimation($chatId, $settings['welcome_media'], $welcomeText);
                        break;
                    case 'video':
                        sendVideo($chatId, $settings['welcome_media'], $welcomeText);
                        break;
                    default:
                        sendMessage($chatId, $welcomeText);
                }
            } else {
                sendMessage($chatId, $welcomeText);
            }
        }
    }
    saveGroupSettings($chatId, $settings);
}

// ==================================================================================
function handleLeftMember($message) {
    // اختیاری
}

// ==================================================================================
function handleEditedMessage($message) {
    $chatId = $message->chat->id ?? 0;
    $chatType = $message->chat->type ?? 'private';
    if ($chatType === 'private') return;

    $settings = getGroupSettings($chatId);
    $userId = $message->from->id ?? 0;
    $msgId = $message->message_id ?? 0;

    $isAdmin = ($userId == $settings['owner_id'] || in_array($userId, $settings['admins']));
    $devs = unserialize(DEV_IDS);
    if (in_array($userId, $devs)) $isAdmin = true;
    $isSpecial = in_array($userId, $settings['specials']);
    if ($isAdmin || $isSpecial) return;

    if ($settings['locks']['edit'] !== 'off') {
        applyLockAction($settings['locks']['edit'], $chatId, $userId, $msgId);
        return;
    }

    $lockAction = checkLocks($settings, $message);
    if ($lockAction !== 'off') {
        applyLockAction($lockAction, $chatId, $userId, $msgId);
        return;
    }

    $text = $message->text ?? ($message->caption ?? '');
    if (checkFilters($settings, $text)) {
        deleteMessage($chatId, $msgId);
    }
}

// ==================================================================================
function applyLockCommand(&$settings, $lockTarget, $mode) {
    $lockMap = getLockNameToKey();
    if ($lockTarget === 'همه' || $lockTarget === 'all') {
        foreach ($settings['locks'] as $k => &$v) { $v = $mode; }
        return ['success' => true, 'name' => 'همه قفل‌ها'];
    }
    $key = $lockMap[$lockTarget] ?? null;
    if ($key && isset($settings['locks'][$key])) {
        $settings['locks'][$key] = $mode;
        $lockNames = getLockNames();
        return ['success' => true, 'name' => $lockNames[$key] ?? $key];
    }
    return ['success' => false, 'name' => ''];
}

function getLockNameToKey() {
    return [
        'لینک' => 'link', 'هشتگ' => 'hashtag', 'منشن' => 'mention',
        'انگلیسی' => 'english', 'عربی' => 'arabic', 'ربات' => 'bot',
        'فوروارد' => 'forward', 'صدا' => 'audio', 'ویس' => 'voice',
        'استیکر' => 'sticker', 'گیف' => 'gif', 'عکس' => 'photo',
        'ویدیو' => 'video', 'فایل' => 'document', 'نظرسنجی' => 'poll',
        'مخاطب' => 'contact', 'مکان' => 'location', 'متن' => 'text',
        'ویدیو نوت' => 'video_note', 'اینلاین' => 'inline', 'شماره' => 'phone',
        'ایموجی زیاد' => 'emoji_flood', 'متن طولانی' => 'long_text',
        'بدون متن' => 'no_text', 'کپشن' => 'caption', 'ریپلای' => 'reply',
        'ویرایش' => 'edit', 'بازی' => 'game', 'فاکتور' => 'invoice',
        'لوکیشن لایو' => 'live_location', 'تاس' => 'dice', 'اسپویلر' => 'spoiler',
        'تاپیک' => 'topic', 'استیکر پریمیوم' => 'premium_sticker',
        'ایموجی سفارشی' => 'custom_emoji', 'استوری' => 'story',
        'link' => 'link', 'hashtag' => 'hashtag', 'mention' => 'mention',
        'english' => 'english', 'arabic' => 'arabic', 'bot' => 'bot',
        'forward' => 'forward', 'audio' => 'audio', 'voice' => 'voice',
        'sticker' => 'sticker', 'gif' => 'gif', 'photo' => 'photo',
        'video' => 'video', 'document' => 'document', 'file' => 'document',
        'poll' => 'poll', 'contact' => 'contact', 'location' => 'location',
        'text' => 'text', 'video_note' => 'video_note', 'inline' => 'inline',
        'phone' => 'phone', 'emoji' => 'emoji_flood', 'long' => 'long_text',
        'caption' => 'caption', 'reply' => 'reply', 'edit' => 'edit',
        'game' => 'game', 'invoice' => 'invoice', 'dice' => 'dice',
        'spoiler' => 'spoiler', 'topic' => 'topic', 'story' => 'story',
    ];
}
?>