<?php
/*
 * ربات مدیریت گروه تیتان - نسخه 2.0
 * نویسنده: طاها محمدی - تیم تیتان
 * کانال: @bottelgram1011
 * ربات: @TITAN0_0BOT
 * فایل: config.php - تنظیمات و توابع پایه
 */

// ==================== تنظیمات اصلی ====================
define('BOT_TOKEN', '8416268625:AAGPZ_nLPAZBV4gsA1gLr6aZu5hQqHVKeZ8');
define('BOT_USERNAME', 'TITAN0_14BOT');
define('CHANNEL', 'Confingfree2025');
define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');
define('DATA_FOLDER', __DIR__ . '/data/');
define('DEV_IDS', serialize([1049800789]));

// ==================== امنیت IP ====================
$telegram_ip_ranges = [
    ['lower' => '149.154.160.0', 'upper' => '149.154.175.255'],
    ['lower' => '91.108.4.0', 'upper' => '91.108.7.255'],
    ['lower' => '91.108.56.0', 'upper' => '91.108.59.255'],
    ['lower' => '185.76.151.0', 'upper' => '185.76.151.255'],
];

if (php_sapi_name() !== 'cli') {
    $ip = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    if (filter_var($ip, FILTER_VALIDATE_IP)) {
        $ip_dec = (float)sprintf("%u", ip2long($ip));
        $allowed = false;
        foreach ($telegram_ip_ranges as $range) {
            $lo = (float)sprintf("%u", ip2long($range['lower']));
            $hi = (float)sprintf("%u", ip2long($range['upper']));
            if ($ip_dec >= $lo && $ip_dec <= $hi) {
                $allowed = true;
                break;
            }
        }
        if (!$allowed) {
            http_response_code(403);
            exit("Access Denied");
        }
    }
}

// ==================== ایجاد پوشه‌ها ====================
if (!file_exists(DATA_FOLDER)) mkdir(DATA_FOLDER, 0777, true);
if (!file_exists(DATA_FOLDER . 'logs/')) mkdir(DATA_FOLDER . 'logs/', 0777, true);
if (!file_exists(DATA_FOLDER . 'backups/')) mkdir(DATA_FOLDER . 'backups/', 0777, true);

// ==================== include jdf ====================
if (file_exists(__DIR__ . '/jdf.php')) {
    include_once __DIR__ . '/jdf.php';
}

if (!function_exists('jdate')) {
    function jdate($format, $timestamp = null) {
        if ($timestamp === null) $timestamp = time();
        return date($format, $timestamp);
    }
}

// ==================== تابع API تلگرام ====================
function apiRequest($method, $params = []) {
    $ch = curl_init();
    $url = API_URL . $method;
    $hasFile = false;
    foreach ($params as $v) {
        if ($v instanceof CURLFile) {
            $hasFile = true;
            break;
        }
    }
    if ($hasFile) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    } else {
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params, JSON_UNESCAPED_UNICODE));
    }
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_POST, true);
    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log("CURL Error [{$method}]: " . curl_error($ch));
        curl_close($ch);
        return null;
    }
    curl_close($ch);
    return json_decode($result, true);
}

// ==================== توابع ارسال پیام ====================
function sendMessage($chatId, $text, $replyTo = null, $keyboard = null, $parseMode = 'HTML') {
    $params = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => $parseMode,
        'disable_web_page_preview' => true,
    ];
    if ($replyTo) $params['reply_to_message_id'] = $replyTo;
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    return apiRequest('sendMessage', $params);
}

function sendPhoto($chatId, $photo, $caption = '', $replyTo = null, $keyboard = null) {
    $params = [
        'chat_id' => $chatId,
        'photo' => $photo,
        'caption' => $caption,
        'parse_mode' => 'HTML',
    ];
    if ($replyTo) $params['reply_to_message_id'] = $replyTo;
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    return apiRequest('sendPhoto', $params);
}

function sendAnimation($chatId, $animation, $caption = '', $replyTo = null, $keyboard = null) {
    $params = [
        'chat_id' => $chatId,
        'animation' => $animation,
        'caption' => $caption,
        'parse_mode' => 'HTML',
    ];
    if ($replyTo) $params['reply_to_message_id'] = $replyTo;
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    return apiRequest('sendAnimation', $params);
}

function sendVideo($chatId, $video, $caption = '', $replyTo = null, $keyboard = null) {
    $params = [
        'chat_id' => $chatId,
        'video' => $video,
        'caption' => $caption,
        'parse_mode' => 'HTML',
    ];
    if ($replyTo) $params['reply_to_message_id'] = $replyTo;
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    return apiRequest('sendVideo', $params);
}

function editMessage($chatId, $msgId, $text, $keyboard = null) {
    $params = [
        'chat_id' => $chatId,
        'message_id' => $msgId,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true,
    ];
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    return apiRequest('editMessageText', $params);
}

function deleteMessage($chatId, $msgId) {
    return apiRequest('deleteMessage', ['chat_id' => $chatId, 'message_id' => $msgId]);
}

function answerCallback($cbId, $text, $alert = false) {
    return apiRequest('answerCallbackQuery', [
        'callback_query_id' => $cbId,
        'text' => $text,
        'show_alert' => $alert,
    ]);
}

function forwardMessage($chatId, $fromChat, $msgId) {
    return apiRequest('forwardMessage', [
        'chat_id' => $chatId,
        'from_chat_id' => $fromChat,
        'message_id' => $msgId,
    ]);
}

function copyMessage($chatId, $fromChat, $msgId) {
    return apiRequest('copyMessage', [
        'chat_id' => $chatId,
        'from_chat_id' => $fromChat,
        'message_id' => $msgId,
    ]);
}

// ==================== مدیریت فایل JSON با قفل ====================
function readJson($file) {
    if (!file_exists($file)) return null;
    $fp = fopen($file, 'r');
    if (!$fp) return null;
    flock($fp, LOCK_SH);
    $content = stream_get_contents($fp);
    flock($fp, LOCK_UN);
    fclose($fp);
    $data = json_decode($content, true);
    return is_array($data) ? $data : null;
}

function writeJson($file, $data) {
    $fp = fopen($file, 'c');
    if (!$fp) return false;
    flock($fp, LOCK_EX);
    ftruncate($fp, 0);
    fwrite($fp, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    fflush($fp);
    flock($fp, LOCK_UN);
    fclose($fp);
    return true;
}

// ==================== مدیریت کاربران پی‌وی ====================
function getUserData() {
    $file = DATA_FOLDER . 'users.json';
    $data = readJson($file);
    if (!$data) $data = ['users' => [], 'bot_settings' => getDefaultBotSettings()];
    if (!isset($data['bot_settings'])) $data['bot_settings'] = getDefaultBotSettings();
    return $data;
}

function saveUserData($data) {
    writeJson(DATA_FOLDER . 'users.json', $data);
}

function getDefaultBotSettings() {
    return [
        'start_text' => "🤖 ربات مدیریت گروه تیتان TITAN\n\n💬 به برترین ربات #مدیریت گروه با امکانات بی‌نظیر خوش آمدید!\n\n📞 برای شروع از دکمه‌های زیر استفاده کنید.\n\nا┈┅┅━✦━┅┅┈\n📢 @" . CHANNEL,
        'help_text' => "",
        'features_text' => "",
        'support_text' => "🫡 پشتیبانی\n\nنظرات شما باعث دلگرمی ماست❤️\n➖➖➖➖➖\nانتقادات، پیشنهادات و نظرات خود را ارسال کنید✔️",
        'sudo_list' => [],
        'blocked_users' => [],
        'channel_lock' => false,
        'channel_id' => CHANNEL,
    ];
}

// ==================== تنظیمات گروه ====================
function getDefaultLocks() {
    return [
        'link' => 'delete',
        'hashtag' => 'off',
        'mention' => 'off',
        'english' => 'off',
        'arabic' => 'off',
        'bot' => 'delete',
        'forward' => 'delete',
        'audio' => 'off',
        'voice' => 'off',
        'sticker' => 'off',
        'gif' => 'off',
        'photo' => 'off',
        'video' => 'off',
        'document' => 'off',
        'poll' => 'off',
        'contact' => 'off',
        'location' => 'off',
        'text' => 'off',
        'video_note' => 'off',
        'inline' => 'off',
        'phone' => 'off',
        'emoji_flood' => 'off',
        'long_text' => 'off',
        'no_text' => 'off',
        'caption' => 'off',
        'reply' => 'off',
        'edit' => 'off',
        'game' => 'off',
        'invoice' => 'off',
        'live_location' => 'off',
        'dice' => 'off',
        'spoiler' => 'off',
        'topic' => 'off',
        'premium_sticker' => 'off',
        'custom_emoji' => 'off',
        'story' => 'off',
    ];
}

function getLockModes() {
    return [
        'off' => '⚪ خاموش',
        'delete' => '🗑 حذف پیام',
        'kick' => '⚠️ اخراج کاربر',
        'mute' => '🔇 سکوت کردن',
        'ban' => '🚫 مسدود کردن',
        'restrict' => '⛔ محدود کردن',
    ];
}

function getLockNames() {
    return [
        'link' => 'لینک‌ها',
        'hashtag' => 'هشتگ‌ها',
        'mention' => 'منشن‌ها',
        'english' => 'متن انگلیسی',
        'arabic' => 'متن عربی',
        'bot' => 'ربات‌ها',
        'forward' => 'فوروارد',
        'audio' => 'فایل صوتی',
        'voice' => 'ویس‌ها',
        'sticker' => 'استیکرها',
        'gif' => 'گیف‌ها',
        'photo' => 'تصاویر',
        'video' => 'ویدئوها',
        'document' => 'فایل‌ها',
        'poll' => 'نظرسنجی',
        'contact' => 'مخاطبان',
        'location' => 'مکان‌ها',
        'text' => 'متن‌ها',
        'video_note' => 'ویدیو نوت',
        'inline' => 'اینلاین',
        'phone' => 'شماره تلفن',
        'emoji_flood' => 'ایموجی زیاد',
        'long_text' => 'متن طولانی',
        'no_text' => 'پیام بدون متن',
        'caption' => 'کپشن‌ها',
        'reply' => 'ریپلای',
        'edit' => 'ویرایش پیام',
        'game' => 'بازی‌ها',
        'invoice' => 'فاکتورها',
        'live_location' => 'لوکیشن لایو',
        'dice' => 'تاس/دایس',
        'spoiler' => 'اسپویلر',
        'topic' => 'تاپیک‌ها',
        'premium_sticker' => 'استیکر پریمیوم',
        'custom_emoji' => 'ایموجی سفارشی',
        'story' => 'استوری‌ها',
    ];
}

function getGroupSettings($chatId) {
    $file = DATA_FOLDER . "{$chatId}.json";
    $data = readJson($file);
    if ($data && is_array($data)) {
        $default = getDefaultGroupSettings();
        foreach ($default as $k => $v) {
            if (!isset($data[$k])) $data[$k] = $v;
        }
        if (!isset($data['locks']) || !is_array($data['locks'])) {
            $data['locks'] = getDefaultLocks();
        } else {
            $dl = getDefaultLocks();
            foreach ($dl as $lk => $lv) {
                if (!isset($data['locks'][$lk])) $data['locks'][$lk] = $lv;
            }
        }
        return $data;
    }
    return getDefaultGroupSettings();
}

function getDefaultGroupSettings() {
    return [
        'owner_id' => 0,
        'admins' => [],
        'admin_levels' => [],
        'specials' => [],
        'locks' => getDefaultLocks(),
        'filter' => [],
        'warns' => [],
        'warn_limit' => 3,
        'anti_spam' => [
            'enabled' => false,
            'msg_per_sec' => 5,
            'time_window' => 10,
            'users' => [],
        ],
        'anti_delete' => false,
        'anti_bot' => true,
        'allowed_bots' => [],
        'welcome_enabled' => true,
        'welcome_text' => '',
        'welcome_media' => null,
        'welcome_media_type' => null,
        'anti_flood' => ['enabled' => false, 'max_forward' => 3],
        'created_at' => jdate('Y/m/d H:i'),
        'members' => [],
        'required_channels' => [],
        'awaiting_channel' => false,
        'channel_action' => '',
        'scores' => [],
        'daily_scores' => [],
        'add_counts' => [],
        'muted_users' => [],
        'banned_users' => [],
        'link_whitelist' => [],
        'link_blacklist' => [],
        'link_mode' => 'blacklist',
        'schedule_locks' => ['enabled' => false, 'start' => '00:00', 'end' => '08:00'],
        'report_limit' => 3,
        'report_counts' => [],
        'awaiting_welcome_text' => false,
        'awaiting_welcome_media' => false,
        'group_name' => '',
        'group_username' => '',
    ];
}

function saveGroupSettings($chatId, $settings) {
    writeJson(DATA_FOLDER . "{$chatId}.json", $settings);
}

// ==================== سیستم لاگ ====================
function addLog($chatId, $adminId, $action, $targetId = null, $details = '') {
    $file = DATA_FOLDER . "logs/{$chatId}_log.json";
    $logs = readJson($file);
    if (!$logs) $logs = [];

    $log = [
        'time' => jdate('Y/m/d H:i:s'),
        'timestamp' => time(),
        'admin_id' => $adminId,
        'action' => $action,
        'target_id' => $targetId,
        'details' => $details,
    ];

    array_unshift($logs, $log);
    if (count($logs) > 500) $logs = array_slice($logs, 0, 500);
    writeJson($file, $logs);
}

function getLogs($chatId, $limit = 20) {
    $file = DATA_FOLDER . "logs/{$chatId}_log.json";
    $logs = readJson($file);
    if (!$logs) return [];
    return array_slice($logs, 0, $limit);
}

// ==================== سیستم امتیازدهی ====================
function addScore($settings, $userId, $points, $chatId) {
    if (!isset($settings['scores'][$userId])) $settings['scores'][$userId] = 0;
    if (!isset($settings['daily_scores'][$userId])) $settings['daily_scores'][$userId] = ['date' => date('Y-m-d'), 'points' => 0];

    $today = date('Y-m-d');
    if ($settings['daily_scores'][$userId]['date'] !== $today) {
        $settings['daily_scores'][$userId] = ['date' => $today, 'points' => 0];
    }

    if ($settings['daily_scores'][$userId]['points'] < 50) {
        $add = min($points, 50 - $settings['daily_scores'][$userId]['points']);
        $settings['scores'][$userId] += $add;
        $settings['daily_scores'][$userId]['points'] += $add;
    }

    return $settings;
}

function removeScore($settings, $userId, $points) {
    if (!isset($settings['scores'][$userId])) $settings['scores'][$userId] = 0;
    $settings['scores'][$userId] -= $points;
    return $settings;
}

function getTopMembers($settings, $limit = 10) {
    $scores = $settings['scores'] ?? [];
    arsort($scores);
    return array_slice($scores, 0, $limit, true);
}

function getTopAdders($settings, $limit = 10) {
    $adds = $settings['add_counts'] ?? [];
    arsort($adds);
    return array_slice($adds, 0, $limit, true);
}

// ==================== سطح‌بندی مدیران ====================
function getAdminLevel($settings, $userId) {
    if ($userId == $settings['owner_id']) return 5;
    $devs = unserialize(DEV_IDS);
    if (in_array($userId, $devs)) return 5;
    return $settings['admin_levels'][$userId] ?? 0;
}

function getAdminLevelName($level) {
    switch ($level) {
        case 1: return '👁 ناظر';
        case 2: return '⚠️ هشداردهنده';
        case 3: return '👮 مدیر';
        case 4: return '🎖 مدیر ارشد';
        case 5: return '👑 نایب مالک';
        default: return '👤 عادی';
    }
}

function hasPermission($settings, $userId, $requiredLevel) {
    $level = getAdminLevel($settings, $userId);
    return $level >= $requiredLevel;
}

// ==================== بررسی سکوت زماندار ====================
function checkMutedUsers($settings, $chatId) {
    $changed = false;
    $now = time();
    foreach ($settings['muted_users'] as $uid => $muteData) {
        if (isset($muteData['until']) && $muteData['until'] > 0 && $now >= $muteData['until']) {
            apiRequest('restrictChatMember', [
                'chat_id' => $chatId,
                'user_id' => $uid,
                'permissions' => json_encode([
                    'can_send_messages' => true,
                    'can_send_media_messages' => true,
                    'can_send_polls' => true,
                    'can_send_other_messages' => true,
                    'can_add_web_page_previews' => true,
                    'can_change_info' => false,
                    'can_invite_users' => true,
                    'can_pin_messages' => false,
                ]),
            ]);
            unset($settings['muted_users'][$uid]);
            $changed = true;
        }
    }
    if ($changed) saveGroupSettings($chatId, $settings);
    return $settings;
}

// ==================== بررسی قفل‌ها ====================
function checkLocks($settings, $message) {
    $fromId = $message->from->id ?? 0;
    if ($fromId == $settings['owner_id']) return 'off';
    if (in_array($fromId, $settings['admins'])) return 'off';
    if (in_array($fromId, $settings['specials'])) return 'off';
    $devs = unserialize(DEV_IDS);
    if (in_array($fromId, $devs)) return 'off';

    $text = $message->text ?? ($message->caption ?? '');
    $locks = $settings['locks'];

    if ($settings['schedule_locks']['enabled']) {
        $now = date('H:i');
        $start = $settings['schedule_locks']['start'];
        $end = $settings['schedule_locks']['end'];
        if (isInTimeRange($now, $start, $end)) {
            return 'delete';
        }
    }

    if ($locks['link'] !== 'off' && preg_match('/https?:\/\/|t\.me\/|www\.|\.com|\.ir|\.org|\.net/i', $text)) {
        if (!isLinkAllowed($settings, $text)) {
            return $locks['link'];
        }
    }
    if ($locks['hashtag'] !== 'off' && strpos($text, '#') !== false) return $locks['hashtag'];
    if ($locks['mention'] !== 'off' && preg_match('/@[a-zA-Z0-9_]{5,}/', $text)) return $locks['mention'];
    if ($locks['english'] !== 'off' && preg_match('/[a-zA-Z]{3,}/', $text)) return $locks['english'];
    if ($locks['arabic'] !== 'off' && preg_match('/[\x{0600}-\x{06FF}]/u', $text) && !preg_match('/[\x{0621}-\x{064A}]/u', $text)) return $locks['arabic'];
    if ($locks['bot'] !== 'off' && isset($message->from->is_bot) && $message->from->is_bot) return $locks['bot'];
    if ($locks['forward'] !== 'off' && (isset($message->forward_from) || isset($message->forward_from_chat) || isset($message->forward_date))) return $locks['forward'];
    if ($locks['audio'] !== 'off' && isset($message->audio)) return $locks['audio'];
    if ($locks['voice'] !== 'off' && isset($message->voice)) return $locks['voice'];
    if ($locks['sticker'] !== 'off' && isset($message->sticker)) return $locks['sticker'];
    if ($locks['gif'] !== 'off' && isset($message->animation)) return $locks['gif'];
    if ($locks['photo'] !== 'off' && isset($message->photo)) return $locks['photo'];
    if ($locks['video'] !== 'off' && isset($message->video)) return $locks['video'];
    if ($locks['document'] !== 'off' && isset($message->document)) return $locks['document'];
    if ($locks['poll'] !== 'off' && isset($message->poll)) return $locks['poll'];
    if ($locks['contact'] !== 'off' && isset($message->contact)) return $locks['contact'];
    if ($locks['location'] !== 'off' && isset($message->location) && !isset($message->location->live_period)) return $locks['location'];
    if ($locks['text'] !== 'off' && isset($message->text) && $message->text !== '' && !preg_match('/^\//', $message->text)) return $locks['text'];
    if ($locks['video_note'] !== 'off' && isset($message->video_note)) return $locks['video_note'];
    if ($locks['inline'] !== 'off' && isset($message->via_bot)) return $locks['inline'];
    if ($locks['phone'] !== 'off' && preg_match('/(\+?98|0)?9\d{9}/', $text)) return $locks['phone'];
    if ($locks['emoji_flood'] !== 'off') {
        preg_match_all('/[\x{1F600}-\x{1F64F}\x{1F300}-\x{1F5FF}\x{1F680}-\x{1F6FF}\x{1F1E0}-\x{1F1FF}\x{2600}-\x{26FF}\x{2700}-\x{27BF}]/u', $text, $m);
        if (count($m[0]) > 5) return $locks['emoji_flood'];
    }
    if ($locks['long_text'] !== 'off' && mb_strlen($text) > 500) return $locks['long_text'];
    if ($locks['no_text'] !== 'off' && (!isset($message->text) || $message->text === '') && !isset($message->caption)) return $locks['no_text'];
    if ($locks['caption'] !== 'off' && isset($message->caption) && $message->caption !== '') return $locks['caption'];
    if ($locks['edit'] !== 'off' && isset($message->edit_date)) return $locks['edit'];
    if ($locks['game'] !== 'off' && isset($message->game)) return $locks['game'];
    if ($locks['invoice'] !== 'off' && isset($message->invoice)) return $locks['invoice'];
    if ($locks['live_location'] !== 'off' && isset($message->location->live_period)) return $locks['live_location'];
    if ($locks['dice'] !== 'off' && isset($message->dice)) return $locks['dice'];
    if ($locks['spoiler'] !== 'off' && isset($message->has_media_spoiler)) return $locks['spoiler'];
    if ($locks['premium_sticker'] !== 'off' && isset($message->sticker->premium_animation)) return $locks['premium_sticker'];
    if ($locks['custom_emoji'] !== 'off' && isset($message->entities)) {
        foreach ($message->entities as $ent) {
            if ($ent->type === 'custom_emoji') return $locks['custom_emoji'];
        }
    }
    if ($locks['story'] !== 'off' && isset($message->story)) return $locks['story'];

    return 'off';
}

// ==================== ضد لینک هوشمند ====================
function isLinkAllowed($settings, $text) {
    if (!empty($settings['group_username'])) {
        if (stripos($text, 't.me/' . $settings['group_username']) !== false) return true;
    }
    foreach ($settings['required_channels'] as $ch) {
        if (stripos($text, 't.me/' . $ch) !== false) return true;
    }
    foreach ($settings['link_whitelist'] as $wl) {
        if (stripos($text, $wl) !== false) return true;
    }
    if ($settings['link_mode'] === 'blacklist') {
        foreach ($settings['link_blacklist'] as $bl) {
            if (stripos($text, $bl) !== false) return false;
        }
        return false;
    }
    return false;
}

// ==================== زمان‌بندی ====================
function isInTimeRange($now, $start, $end) {
    if ($start <= $end) {
        return ($now >= $start && $now < $end);
    } else {
        return ($now >= $start || $now < $end);
    }
}

// ==================== اعمال مجازات قفل ====================
function applyLockAction($action, $chatId, $userId, $msgId) {
    deleteMessage($chatId, $msgId);
    switch ($action) {
        case 'kick':
            apiRequest('banChatMember', ['chat_id' => $chatId, 'user_id' => $userId]);
            sleep(1);
            apiRequest('unbanChatMember', ['chat_id' => $chatId, 'user_id' => $userId, 'only_if_banned' => true]);
            break;
        case 'mute':
            apiRequest('restrictChatMember', [
                'chat_id' => $chatId,
                'user_id' => $userId,
                'permissions' => json_encode([
                    'can_send_messages' => false,
                    'can_send_media_messages' => false,
                    'can_send_polls' => false,
                    'can_send_other_messages' => false,
                    'can_add_web_page_previews' => false,
                ]),
            ]);
            break;
        case 'ban':
            apiRequest('banChatMember', ['chat_id' => $chatId, 'user_id' => $userId]);
            break;
        case 'restrict':
            apiRequest('restrictChatMember', [
                'chat_id' => $chatId,
                'user_id' => $userId,
                'permissions' => json_encode([
                    'can_send_messages' => false,
                    'can_send_media_messages' => false,
                    'can_send_polls' => false,
                    'can_send_other_messages' => false,
                    'can_add_web_page_previews' => false,
                    'can_change_info' => false,
                    'can_invite_users' => false,
                    'can_pin_messages' => false,
                ]),
            ]);
            break;
    }
}

// ==================== فیلتر کلمات ====================
function checkFilters($settings, $text) {
    foreach ($settings['filter'] as $word) {
        if (mb_stripos($text, $word) !== false) return true;
    }
    return false;
}

// ==================== ضد اسپم ====================
function isSpam($settings, $chatId, $fromId) {
    if (!$settings['anti_spam']['enabled']) return false;
    $now = time();
    $window = $settings['anti_spam']['time_window'];
    $maxMsg = $settings['anti_spam']['msg_per_sec'];

    if (!isset($settings['anti_spam']['users'][$fromId])) {
        $settings['anti_spam']['users'][$fromId] = [];
    }

    $timestamps = array_filter($settings['anti_spam']['users'][$fromId], function ($t) use ($now, $window) {
        return ($now - $t) < $window;
    });
    $timestamps[] = $now;
    $settings['anti_spam']['users'][$fromId] = array_values($timestamps);

    foreach ($settings['anti_spam']['users'] as $uid => $ts) {
        $ts = array_filter($ts, function ($t) use ($now) { return ($now - $t) < 60; });
        if (empty($ts)) unset($settings['anti_spam']['users'][$uid]);
        else $settings['anti_spam']['users'][$uid] = array_values($ts);
    }

    saveGroupSettings($chatId, $settings);
    return count($timestamps) > $maxMsg;
}

// ==================== خوش‌آمدگویی ====================
function getDefaultWelcomeText() {
    return "✨ به گروه <b>{GROUP_NAME}</b> خوش اومدی!\n\n"
        . "🎉 <a href='tg://user?id={USER_ID}'>{FIRST_NAME}</a> عزیز، کنارمون باش و لذت ببر! 😍\n\n"
        . "👥 تعداد اعضا: <b>{MEMBER_COUNT}</b> نفر\n"
        . "📆 تاریخ: <b>{DATE}</b>\n"
        . "⏰ ساعت: <b>{TIME}</b>\n\n"
        . "📜 لطفاً قوانین گروه رو رعایت کن!\n"
        . "┈┅┅━ 🤖 TITAN ━┅┅┈";
}

function formatWelcomeText($text, $user, $chatId, $memberCount = 0) {
    $firstName = $user->first_name ?? '';
    $lastName = $user->last_name ?? '';
    $username = $user->username ?? '';
    $userId = $user->id ?? 0;

    $chatInfo = apiRequest('getChat', ['chat_id' => $chatId]);
    $groupName = ($chatInfo['ok'] ?? false) ? ($chatInfo['result']['title'] ?? '') : '';

    $mention = "<a href='tg://user?id={$userId}'>{$firstName}</a>";

    $replacements = [
        '{FIRST_NAME}' => $firstName,
        '{LAST_NAME}' => $lastName,
        '{USERNAME}' => $username ? "@{$username}" : $firstName,
        '{USER_ID}' => $userId,
        '{GROUP_NAME}' => $groupName,
        '{MEMBER_COUNT}' => $memberCount,
        '{DATE}' => jdate('Y/m/d'),
        '{TIME}' => jdate('H:i'),
        '{MENTION}' => $mention,
        '{NEWLINE}' => "\n",
    ];

    return str_replace(array_keys($replacements), array_values($replacements), $text);
}

// ==================== پاسخ‌های رندم (بدون آیدی) ====================
function getRandomBotResponse() {
    $r = [
        "تا تیتان اینجاست غم نداشته باش 🤖",
        "🫡🫡 دستور بده فرمانده 🫡🫡",
        "🥰🥰 جانم عشقم من اینجام 😘😘",
        "ها؟ باز این اومد اعصابمون داغون کنه 😫",
        "چقدر صدام میکنی دیونه کردی منو اهههه 😮‍💨",
        "انلاینم هر وقت بگی در خدمتم 🤗",
        "این همه منو صدا میکنی خسته نمیشی؟ 😮‍💨😭😭",
        "چیه بزبزقندی 😅",
    ];
    return $r[array_rand($r)];
}

function getRandomPingResponse() {
    $r = [
        "✪ ربات روشن می‌باشد! ✪\n⏳ زمان پاسخ‌دهی 0.6 ثانیه ⌛️\n┈┅┅━ TITAN ━┅┅┈\n▐ 📥 دریافت ≻ 0.9 ثانیه\n▐ ♻️ ارسال ≺ 0.7 ثانیه\n┈┅⬩◆ پینگ سرور: عالی ◆⬩┅┈",
        "༺ مُدیریَت آنْلاٰین میبٰاشَد! ༻\n⭑ا⭑★TITAN★⭑ا⭑\n🕞 زمان پاسخ دهی 0.3 ثانیه 🕞\n►◆✪ سرعت سرور: عالی ✪◆◄",
    ];
    return $r[array_rand($r)];
}

function getRandomTractorResponse() {
    $r = [
        "تراختور منه جاندی هم جاندی هیجاندی 🚜",
        "یاشاسین تراختور یاشاسین آذربایجان 🚜🎖️",
        "چکیلیون تراختور گلیر حریفلری بیر بیر دلیر 🚜🚜",
    ];
    return $r[array_rand($r)];
}

// ==================== لیست گروه‌ها ====================
function getGroupsList() {
    $file = DATA_FOLDER . 'groups_list.json';
    $data = readJson($file);
    return $data ?: [];
}

function addGroupToList($chatId, $name, $username = '') {
    $file = DATA_FOLDER . 'groups_list.json';
    $groups = readJson($file) ?: [];
    $groups[$chatId] = [
        'name' => $name,
        'username' => $username,
        'added_at' => jdate('Y/m/d H:i'),
        'timestamp' => time(),
    ];
    writeJson($file, $groups);
}

// ==================== بکاپ ====================
function createBackup() {
    $backupFile = DATA_FOLDER . 'backups/backup_' . date('Y-m-d_H-i-s') . '.json';
    $allData = [];
    $files = glob(DATA_FOLDER . '*.json');
    foreach ($files as $f) {
        $name = basename($f);
        $allData[$name] = readJson($f);
    }
    writeJson($backupFile, $allData);
    return $backupFile;
}
?>