<?php
// ==================== نویسنده: تیم تیتان TITAN ====================
// طاها تیتان TAHA TITAN | امیر تیتان EWMIR TITAN
// کانال تیم: https://t.me/Confingfree2025
// کانال تیم: https://t.me/sourcetitan
// ==================================================================

error_reporting(0);
ob_start();

// =====================================================
// ============= تنظیمات اصلی ربات ====================
// =====================================================

define('API_KEY', 'X8505030237:AAFtPxgEeJ_1A1myHdrHfVhQ_fvhCjpVUV0');
$usernamebot = 'TITAN0_12BOT';
$botname = 'تیتان سورس';
$owner_id = 1049800789;

// =====================================================
// ============= توابع اصلی ===========================
// =====================================================

function bot($method, $dats = []) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://api.telegram.org/bot' . API_KEY . '/' . $method);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dats);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res);
}

function convert($string) {
    if (empty($string)) return '';
    $persian = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $arabic = ['٩','٨','٧','٦','٥','٤','٣','٢','١','٠'];
    $num = range(0, 9);
    $s = str_replace($persian, $num, $string);
    return str_replace($arabic, $num, $s);
}

function saveJson($file, $data) {
    $dir = dirname($file);
    if (!empty($dir) && $dir != '.' && !is_dir($dir)) @mkdir($dir, 0755, true);
    file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

function Save($filename, $TXTdata) {
    $dir = dirname($filename);
    if (!empty($dir) && $dir != '.' && !is_dir($dir)) @mkdir($dir, 0755, true);
    file_put_contents($filename, $TXTdata);
}

function safeJsonRead($file) {
    if (file_exists($file) && is_readable($file)) {
        $content = @file_get_contents($file);
        if ($content !== false && !empty($content)) {
            $data = json_decode($content, true);
            if (is_array($data)) return $data;
        }
    }
    return [];
}

function safeFileRead($file, $default = '') {
    if (file_exists($file) && is_readable($file)) {
        $content = @file_get_contents($file);
        return ($content !== false) ? trim($content) : $default;
    }
    return $default;
}

function top($number, $invite) {
    if (!is_dir('file')) return '';
    $usersscan = @scandir('file');
    if (!$usersscan) return '';
    $usersscan = array_diff($usersscan, ['.', '..']);
    $userlistsave = [];
    foreach ($usersscan as $userlist) {
        if (!is_file("file/$userlist")) continue;
        $users = safeJsonRead("file/$userlist");
        $userlistsave[$userlist] = isset($users[$invite]) ? $users[$invite] : 0;
    }
    if (empty($userlistsave)) return '';
    arsort($userlistsave, SORT_NUMERIC);
    $charkhesharray = array_keys($userlistsave);
    if (isset($charkhesharray[$number])) {
        return str_replace('.json', '', $charkhesharray[$number]);
    }
    return '';
}

function getUserStep($user) {
    return isset($user['step']) ? $user['step'] : 'none';
}

function initUser() {
    return [
        'step' => 'none',
        'member' => 0,
        'like' => '0',
        'file' => '0',
        'coin' => 0,
    ];
}

function ensureUserExists($userId) {
    if (!file_exists("users/$userId.json")) {
        $user = initUser();
        saveJson("users/$userId.json", $user);
        return $user;
    }
    return safeJsonRead("users/$userId.json");
}

function isAdmin($userId, $list, $owner_id) {
    return ($userId == $owner_id || in_array($userId, $list['admins']) || in_array("$userId", $list['admins']));
}

function isOwner($userId, $owner_id) {
    return ($userId == $owner_id);
}

function getSetting($key, $default = '') {
    $settings = safeJsonRead("data/settings.json");
    return isset($settings[$key]) ? $settings[$key] : $default;
}

function setSetting($key, $value) {
    $settings = safeJsonRead("data/settings.json");
    $settings[$key] = $value;
    saveJson("data/settings.json", $settings);
}

function getStats($key, $default = 0) {
    $stats = safeJsonRead("data/stats.json");
    return isset($stats[$key]) ? $stats[$key] : $default;
}

function addStats($key, $amount = 1) {
    $stats = safeJsonRead("data/stats.json");
    if (!isset($stats[$key])) $stats[$key] = 0;
    $stats[$key] = $stats[$key] + $amount;
    saveJson("data/stats.json", $stats);
}

function getCustomText($key, $default) {
    $texts = safeJsonRead("data/texts.json");
    return isset($texts[$key]) ? $texts[$key] : $default;
}

function setCustomText($key, $value) {
    $texts = safeJsonRead("data/texts.json");
    $texts[$key] = $value;
    saveJson("data/texts.json", $texts);
}

function makeFileInlineKeyboard($fileId, $download, $limit, $like, $coindownload, $usernamebot, $botname) {
    return json_encode([
        'inline_keyboard' => [
            [['text' => '📂 دریافت سورس', 'url' => "https://t.me/$usernamebot?start=file_$fileId"]],
            [['text' => "📥 دانلود رایگان: $download از $limit", 'callback_data' => 'download']],
            [
                ['text' => "❤️ ($like)", 'callback_data' => "like_$fileId"],
                ['text' => "🤖 ربات", 'url' => "https://t.me/$usernamebot?start=start"]
            ],
            [['text' => "💎 تیتانیوم مورد نیاز = $coindownload", 'url' => "https://t.me/$usernamebot?start=start"]],
        ]
    ]);
}

// =====================================================
// ============= کیبوردها =============================
// =====================================================

function getUserKeyboard($isOwner = false) {
    $keyboard = [
        [['text' => '📤 ارسال سورس']],
        [['text' => '🔥 محبوب ترین ها'], ['text' => '🆕 جدیدترین ها']],
        [['text' => '👤 حساب کاربری'], ['text' => '💎 افزایش تیتانیوم']],
        [['text' => '📞 پشتیبانی'], ['text' => '📖 راهنما']],
    ];
    if ($isOwner) {
        $keyboard[] = [['text' => '🔐 پنل مدیریت']];
    }
    return json_encode(['keyboard' => $keyboard, 'resize_keyboard' => true]);
}

function getAdminPanelKeyboard() {
    return json_encode([
        'keyboard' => [
            [['text' => '💎 بخش تیتانیوم']],
            [['text' => '📊 آمار ربات'], ['text' => '👤 ادمین ها']],
            [['text' => '📤 آپلود سورس'], ['text' => '🗑 حذف سورس']],
            [['text' => '✏️ ویرایش سورس'], ['text' => '📝 تنظیم کانال']],
            [['text' => '📋 تنظیم متون'], ['text' => '🔍 مشخصات کاربر']],
            [['text' => '📨 فوروارد همگانی'], ['text' => '📩 ارسال همگانی']],
            [['text' => '🚫 مسدود کردن'], ['text' => '✅ رفع مسدودیت']],
            [['text' => '👥 منو کاربران']],
        ],
        'resize_keyboard' => true,
    ]);
}

function getTitaniumKeyboard() {
    return json_encode([
        'keyboard' => [
            [['text' => '📤 تیتانیوم همگانی']],
            [['text' => '➕ ارسال تیتانیوم'], ['text' => '➖ کسر تیتانیوم']],
            [['text' => '⚙️ تنظیمات امتیاز']],
            [['text' => '🔙 بازگشت']],
        ],
        'resize_keyboard' => true,
    ]);
}

function getScoreSettingsKeyboard() {
    return json_encode([
        'keyboard' => [
            [['text' => '🏆 امتیاز تایید سورس'], ['text' => '👥 امتیاز زیر مجموعه']],
            [['text' => '🚪 امتیاز موقع ورود'], ['text' => '❤️ امتیاز لایک پست']],
            [['text' => '🔙 برگشت']],
        ],
        'resize_keyboard' => true,
    ]);
}

function getTextsKeyboard() {
    return json_encode([
        'keyboard' => [
            [['text' => '📞 متن پشتیبانی'], ['text' => '▶️ متن استارت']],
            [['text' => '🗣 متن بنر زیرمجموعه‌گیری']],
            [['text' => '📖 متن راهنما'], ['text' => '📤 متن ارسال سورس']],
            [['text' => '🔙 برگشت']],
        ],
        'resize_keyboard' => true,
    ]);
}

function getBackKeyboard() {
    return json_encode([
        'keyboard' => [[['text' => '🔙 بازگشت']]],
        'resize_keyboard' => true,
    ]);
}

function getAdminBackKeyboard() {
    return json_encode([
        'keyboard' => [[['text' => '🔙 برگشت']]],
        'resize_keyboard' => true,
    ]);
}

function getYesNoKeyboard() {
    return json_encode([
        'keyboard' => [[['text' => '✅ بله'], ['text' => '❌ خیر']]],
        'resize_keyboard' => true,
    ]);
}

// =====================================================
// ============= ایجاد پوشه‌ها و فایل‌ها ==============
// =====================================================

$dirs = ['users', 'data', 'file', 'lib'];
foreach ($dirs as $d) {
    if (!is_dir($d)) @mkdir($d, 0755, true);
}

if (!file_exists("data/block.json")) saveJson("data/block.json", ['list' => []]);
if (!file_exists("lib/list.json")) saveJson("lib/list.json", ['admins' => [$owner_id]]);
if (!file_exists("sendfile.json")) saveJson("sendfile.json", []);
if (!file_exists("Lite.txt")) Save("Lite.txt", "2050/10/05");
if (!file_exists("lib/channel1.txt")) Save("lib/channel1.txt", "Confingfree2025");
if (!file_exists("lib/channel2.txt")) Save("lib/channel2.txt", "sourcetitan");
if (!file_exists("data/settings.json")) saveJson("data/settings.json", [
    'score_approve' => 3,
    'score_invite' => 1,
    'score_join' => 0,
    'score_like' => 0,
]);
if (!file_exists("data/stats.json")) saveJson("data/stats.json", [
    'total_likes' => 0,
    'total_downloads' => 0,
    'approved_sources' => 0,
    'rejected_sources' => 0,
]);
if (!file_exists("data/texts.json")) saveJson("data/texts.json", []);

$list = safeJsonRead("lib/list.json");
if (!isset($list['admins'])) $list['admins'] = [];
if (!in_array($owner_id, $list['admins']) && !in_array("$owner_id", $list['admins'])) {
    $list['admins'][] = $owner_id;
    saveJson("lib/list.json", $list);
}

// =====================================================
// ============= دریافت آپدیت =========================
// =====================================================

$update = json_decode(file_get_contents('php://input'));
if (!$update) die();

$isMessage = isset($update->message);
$isCallback = isset($update->callback_query);
if (!$isMessage && !$isCallback) die();

$message = null; $message_id = 0; $text = ''; $chat_id = 0; $tc = '';
$first_name = ''; $from_id = 0; $user = []; $block = [];

if ($isMessage) {
    $message = $update->message;
    $message_id = isset($message->message_id) ? $message->message_id : 0;
    $text = convert(isset($message->text) ? $message->text : '');
    $chat_id = isset($message->chat->id) ? $message->chat->id : 0;
    $tc = isset($message->chat->type) ? $message->chat->type : '';
    $first_name = isset($message->from->first_name) ? $message->from->first_name : '';
    $from_id = isset($message->from->id) ? $message->from->id : 0;
    if ($from_id > 0) {
        $user = safeJsonRead("users/$from_id.json");
        $block = safeJsonRead("data/block.json");
    }
}

$callback_query = null; $callback_query_id = ''; $data = '';
$fromid = 0; $messageid = 0; $chatid = 0;

if ($isCallback) {
    $callback_query = $update->callback_query;
    $callback_query_id = isset($callback_query->id) ? $callback_query->id : '';
    $data = isset($callback_query->data) ? $callback_query->data : '';
    $fromid = isset($callback_query->from->id) ? $callback_query->from->id : 0;
    $messageid = isset($callback_query->message->message_id) ? $callback_query->message->message_id : 0;
    $chatid = isset($callback_query->message->chat->id) ? $callback_query->message->chat->id : 0;
    if ($fromid > 0) {
        $user = safeJsonRead("users/$fromid.json");
        $block = safeJsonRead("data/block.json");
    }
}

$datas = safeJsonRead("sendfile.json");
$list = safeJsonRead("lib/list.json");
if (!isset($list['admins'])) $list['admins'] = [];

$channel1 = safeFileRead("lib/channel1.txt", "Confingfree2025");
$channel2 = safeFileRead("lib/channel2.txt", "sourcetitan");

$currentId = $isMessage ? $from_id : $fromid;

$home = getUserKeyboard(isOwner($currentId, $owner_id));
$back = getBackKeyboard();
$adminBack = getAdminBackKeyboard();
$adminPanelKeyboard = getAdminPanelKeyboard();

// متن‌های پیشفرض
$defaultStartText = "✅ ربات $botname جهت دریافت سورس های داخل کانال و همچنین پشتیبانی کاربران ایجاد شده است\n\n☑️ اگر سورس را نمیتوانید دریافت کنید یا از دست داده اید میتوانید از بخش افزایش تیتانیوم استفاده کنید.\n👇🏻 از منوی پایین انتخاب کنید\n\n👨‍💻 نویسنده: تیم تیتان TITAN\n📣 @Confingfree2025 | @sourcetitan";
$defaultSupportText = "👮🏻 پشتیبانی $botname\n\n• لطفا سوال یا پیام خود را ارسال کنید 👇🏻\n\n👨‍💻 تیم تیتان TITAN";
$defaultGuideText = "📢 کانال تیم تیتان TITAN مرجع انواع سورس کد‌های مختلف\n📂 بانک انواع سورس کد‌ها به صورت کاملا تست شده\n\n✅ سورس انواع ربات‌ها، قالب‌ها و اسکریپت‌های تست شده و حرفه‌ای\n\n☑️ با ما همراه باشید\n🌟 هر روز کلی سورس کد و اسکریپت منتظر شماست!\n\n📣 @$channel1\n📣 @$channel2\n🤖 ربات: @$usernamebot\n\n👨‍💻 تیم تیتان TITAN";
$defaultSendSourceText = "💎 به بخش ارسال سورس خوش آمدید!\n\n✈️ سورس خود را ارسال کنید و پس از تایید ادمین‌ها، در کانال قرار می‌گیرد و تیتانیوم دریافت میکنید.\n\n✅ هیچ تگ یا نامی از مرجع‌های دیگر نباید باشد.\n\n🌄 حالا یک عکس بعنوان بنر سورس ارسال کنید:\n\n👨‍💻 تیم تیتان TITAN";
$defaultInviteText = "📢 کانال تیم تیتان TITAN مرجع انواع سورس کد\n\n✅ سورس انواع ربات‌ها، قالب‌ها و اسکریپت‌ها\n🌟 هر روز کلی سورس کد منتظر شماست!";

$maintext = getCustomText('start', $defaultStartText);

// بررسی مسدودی
if (!isset($block['list'])) $block['list'] = [];
if (in_array($currentId, $block['list']) || in_array("$currentId", $block['list'])) die();

// بررسی لایسنس
date_default_timezone_set('Asia/Tehran');
$sharge = safeFileRead("Lite.txt", "2050/10/05");
$sec = strtotime($sharge) - strtotime(date('Y/m/d'));
$d0ays = intval($sec / 86400);
if ($d0ays < 1) {
    bot('sendMessage', ['chat_id' => $currentId, 'text' => "⚠️ مدت زمان اشتراک ربات به پایان رسیده است.\n\n👨‍💻 تیم تیتان TITAN"]);
    die();
}

// =====================================================
// ============= پردازش MESSAGE ========================
// =====================================================

if ($isMessage && $from_id > 0 && $tc == 'private') {

    $userStep = getUserStep($user);

    // === /start file_XXX ===
    if (preg_match('/^\/start file_(.*)/', $text, $match)) {
        $user = ensureUserExists($from_id);
        $memberCheck = bot('getChatMember', ['chat_id' => "@$channel2", 'user_id' => $from_id]);
        $memberStatus = isset($memberCheck->result->status) ? $memberCheck->result->status : 'left';

        if ($memberStatus != 'left') {
            $fileId = $match[1];
            if (file_exists("file/$fileId.json")) {
                $file = safeJsonRead("file/$fileId.json");
                if (!isset($file['members'])) $file['members'] = [];
                if (!isset($file['likes'])) $file['likes'] = [];
                $fileLike = isset($file['like']) ? $file['like'] : 0;
                $fileDownload = isset($file['download']) ? (int)$file['download'] : 0;
                $fileLimit = isset($file['limit']) ? (int)$file['limit'] : 0;
                $fileCoin = isset($file['coindownload']) ? (float)$file['coindownload'] : 0;
                $fileCaption = isset($file['caption']) ? $file['caption'] : '';
                $fileFileId = isset($file['file']) ? $file['file'] : '';

                if (in_array($from_id, $file['members'])) {
                    bot('sendDocument', [
                        'chat_id' => $from_id, 'document' => $fileFileId, 'caption' => $fileCaption,
                        'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❤️ ($fileLike)", 'callback_data' => "like_$fileId"]]]])
                    ]);
                } elseif ($fileDownload < $fileLimit) {
                    bot('sendDocument', [
                        'chat_id' => $from_id, 'document' => $fileFileId, 'caption' => $fileCaption,
                        'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❤️ ($fileLike)", 'callback_data' => "like_$fileId"]]]])
                    ]);
                    $download = $fileDownload + 1;
                    bot('editMessageReplyMarkup', [
                        'chat_id' => "@$channel1", 'message_id' => $fileId,
                        'reply_markup' => makeFileInlineKeyboard($fileId, $download, $fileLimit, $fileLike, $fileCoin, $usernamebot, $botname)
                    ]);
                    $file['members'][] = $from_id;
                    $file['download'] = "$download";
                    saveJson("file/$fileId.json", $file);
                    $user['file'] = (string)((int)$user['file'] + 1);
                    saveJson("users/$from_id.json", $user);
                    addStats('total_downloads');
                } elseif ((float)$user['coin'] >= $fileCoin) {
                    bot('sendDocument', [
                        'chat_id' => $from_id, 'document' => $fileFileId, 'caption' => $fileCaption,
                        'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❤️ ($fileLike)", 'callback_data' => "like_$fileId"]]]])
                    ]);
                    $mincoin = (float)$user['coin'] - $fileCoin;
                    $file['members'][] = $from_id;
                    saveJson("file/$fileId.json", $file);
                    $user['coin'] = "$mincoin";
                    $user['file'] = (string)((int)$user['file'] + 1);
                    saveJson("users/$from_id.json", $user);
                    addStats('total_downloads');
                } else {
                    bot('sendMessage', [
                        'chat_id' => $from_id,
                        'text' => "❗️ ظرفیت دانلود رایگان این سورس به پایان رسیده است\n\n☑️ شما میتوانید با افزایش تیتانیوم حساب خود اقدام به دریافت سورس ها بدون محدودیت کنید\n\n👇🏻 از منوی پایین انتخاب کنید",
                        'reply_to_message_id' => $message_id, 'reply_markup' => $home
                    ]);
                }
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => '❌ خطا، سورس مورد نظر یافت نشد', 'reply_markup' => $home]);
            }
        } else {
            bot('sendMessage', [
                'chat_id' => $from_id,
                'text' => "☑️ برای استفاده از ربات « $botname » ابتدا باید وارد کانال شوید\n\n📣 @$channel1\n📣 @$channel2\n\n👈🏻 بعد از عضویت مجدد اقدام به دریافت سورس کنید",
                'reply_to_message_id' => $message_id, 'reply_markup' => $home
            ]);
        }
    }

    // === /start رفرال ===
    elseif (preg_match('/^\/start (.+)/', $text, $match) && !file_exists("users/$from_id.json") && strpos($match[1], 'file_') !== 0) {
        $referrer = $match[1];
        $memberCheck = bot('getChatMember', ['chat_id' => "@$channel2", 'user_id' => $from_id]);
        $memberStatus = isset($memberCheck->result->status) ? $memberCheck->result->status : 'left';

        $scoreJoin = (float)getSetting('score_join', 0);
        $user = initUser();
        $user['coin'] = $scoreJoin;
        $user['invite'] = "send $referrer";
        saveJson("users/$from_id.json", $user);

        if ($memberStatus != 'left') {
            bot('sendMessage', [
                'chat_id' => $from_id,
                'text' => "🌹 سلام $first_name عزیز به $botname خوش آمدید\n\n$maintext",
                'reply_to_message_id' => $message_id, 'reply_markup' => $home
            ]);
            $scoreInvite = (float)getSetting('score_invite', 1);
            if (file_exists("users/$referrer.json")) {
                $refUser = safeJsonRead("users/$referrer.json");
                $member = (int)(isset($refUser['member']) ? $refUser['member'] : 0) + 1;
                $coin = (float)(isset($refUser['coin']) ? $refUser['coin'] : 0) + $scoreInvite;
                bot('sendMessage', [
                    'chat_id' => $referrer,
                    'text' => "🌟 تبریک! کاربر [$from_id](tg://user?id=$from_id) با لینک دعوت شما وارد شد\n⬆️ $scoreInvite تیتانیوم به حساب شما افزوده شد\n\n💎 موجودی: $coin تیتانیوم\n👥 زیر مجموعه: $member نفر",
                    'parse_mode' => 'Markdown',
                ]);
                $refUser['member'] = "$member";
                $refUser['coin'] = "$coin";
                saveJson("users/$referrer.json", $refUser);
            }
            $user['invite'] = null;
            saveJson("users/$from_id.json", $user);
        } else {
            bot('sendMessage', [
                'chat_id' => $from_id,
                'text' => "☑️ برای استفاده از ربات « $botname » ابتدا باید وارد کانال شوید\n\n📣 @$channel1\n📣 @$channel2\n\n👇 بعد از عضویت روی « ✅ تایید عضویت » بزنید 👇",
                'reply_to_message_id' => $message_id,
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => '✅ تایید عضویت', 'callback_data' => 'join']]]])
            ]);
        }
    }

    // === /start ساده ===
    elseif ($text == '/start' || $text == '/start start') {
        $user = ensureUserExists($from_id);
        $scoreJoin = (float)getSetting('score_join', 0);
        if (!isset($user['joined'])) {
            $user['coin'] = (float)(isset($user['coin']) ? $user['coin'] : 0) + $scoreJoin;
            $user['joined'] = true;
        }
        $memberCheck = bot('getChatMember', ['chat_id' => "@$channel2", 'user_id' => $from_id]);
        $memberStatus = isset($memberCheck->result->status) ? $memberCheck->result->status : 'left';

        if ($memberStatus != 'left') {
            bot('sendMessage', [
                'chat_id' => $from_id,
                'text' => "🌹 سلام $first_name عزیز به $botname خوش آمدید\n\n$maintext",
                'reply_to_message_id' => $message_id, 'reply_markup' => $home
            ]);
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        } else {
            bot('sendMessage', [
                'chat_id' => $from_id,
                'text' => "☑️ برای استفاده از ربات « $botname » ابتدا باید وارد کانال شوید\n\n📣 @$channel1\n📣 @$channel2\n\n👇 بعد از عضویت روی « ✅ تایید عضویت » بزنید 👇",
                'reply_to_message_id' => $message_id,
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => '✅ تایید عضویت', 'callback_data' => 'join']]]])
            ]);
            saveJson("users/$from_id.json", $user);
        }
    }

    // === بازگشت‌ها ===
    elseif ($text == '🔙 بازگشت') {
        if (isOwner($from_id, $owner_id) && isset($user['admin_section'])) {
            // برگشت از زیرمنوهای ادمین
            $section = $user['admin_section'];
            unset($user['admin_section']);
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
            if ($section == 'titanium') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            } elseif ($section == 'score_settings') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش تیتانیوم", 'reply_markup' => getTitaniumKeyboard()]);
            } elseif ($section == 'texts') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            } elseif ($section == 'channel') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            } elseif ($section == 'admins') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "⬅️ به منوی اصلی بازگشتید\n\n$maintext", 'reply_markup' => $home]);
            }
        } else {
            bot('sendMessage', [
                'chat_id' => $from_id, 'text' => "⬅️ به منوی اصلی بازگشتید\n\n$maintext",
                'reply_to_message_id' => $message_id, 'reply_markup' => $home
            ]);
            $user['step'] = 'none';
            unset($user['admin_section']);
            saveJson("users/$from_id.json", $user);
        }
    }

    elseif ($text == '🔙 برگشت') {
        if (isOwner($from_id, $owner_id) && isset($user['admin_section'])) {
            $section = $user['admin_section'];
            unset($user['admin_section']);
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
            if ($section == 'titanium') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            } elseif ($section == 'score_settings') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش تیتانیوم", 'reply_markup' => getTitaniumKeyboard()]);
                $user['admin_section'] = 'titanium';
                saveJson("users/$from_id.json", $user);
            } elseif ($section == 'texts') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            } elseif ($section == 'channel') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            } elseif ($section == 'admins') {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            }
        } else {
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 به پنل مدیریت بازگشتید", 'reply_markup' => $adminPanelKeyboard]);
            $user['step'] = 'none';
            unset($user['admin_section']);
            saveJson("users/$from_id.json", $user);
        }
    }

    elseif ($text == '🔙 بازگشت به ربات') {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "⬅️ به منوی اصلی بازگشتید\n\n$maintext", 'reply_markup' => $home]);
        $user['step'] = 'none';
        unset($user['admin_section']);
        saveJson("users/$from_id.json", $user);
    }

    // === جوین اجباری ===
    elseif (!isAdmin($from_id, $list, $owner_id)) {
        $memberCheck = bot('getChatMember', ['chat_id' => "@$channel2", 'user_id' => $from_id]);
        $memberStatus = isset($memberCheck->result->status) ? $memberCheck->result->status : 'left';
        if ($memberStatus == 'left') {
            bot('sendMessage', [
                'chat_id' => $from_id,
                'text' => "☑️ برای استفاده از ربات « $botname » ابتدا باید وارد کانال شوید\n\n📣 @$channel1\n📣 @$channel2\n\n👇 بعد از عضویت روی « ✅ تایید عضویت » بزنید 👇",
                'reply_to_message_id' => $message_id,
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => '✅ تایید عضویت', 'callback_data' => 'join']]]])
            ]);
            ensureUserExists($from_id);
            goto end_processing;
        }
        goto process_buttons;
    } else {
        goto process_buttons;
    }

    process_buttons:

    // === /file_XXX ===
    if (preg_match('/^\/file_(.*)/', $text, $match)) {
        if (file_exists("file/{$match[1]}.json")) {
            $file = safeJsonRead("file/{$match[1]}.json");
            $fileLike = isset($file['like']) ? $file['like'] : 0;
            $fileDl = isset($file['download']) ? $file['download'] : 0;
            $fileLimit = isset($file['limit']) ? $file['limit'] : 0;
            $fileCoin = isset($file['coindownload']) ? $file['coindownload'] : 0;
            $filePhoto = isset($file['photo']) ? $file['photo'] : '';
            $fileCaption = isset($file['caption']) ? $file['caption'] : '';

            bot('sendPhoto', [
                'chat_id' => $from_id, 'photo' => $filePhoto, 'caption' => $fileCaption,
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => "📂 دریافت سورس", 'callback_data' => "file_{$match[1]}"]],
                    [['text' => "📥 دانلود رایگان: $fileDl از $fileLimit", 'callback_data' => 'download']],
                    [['text' => "❤️ ($fileLike)", 'callback_data' => "like_{$match[1]}"], ['text' => "📢 سورس ها", 'url' => "https://t.me/$channel1"]],
                    [['text' => "💎 تیتانیوم مورد نیاز = $fileCoin", 'url' => "https://t.me/$usernamebot?start=start"]],
                ]])
            ]);
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => '❌ خطا، سورس یافت نشد', 'reply_markup' => $home]);
        }
    }

    // =====================================================
    // === دکمه ارسال سورس ===
    // =====================================================
    elseif ($text == '📤 ارسال سورس') {
        $sendSourceText = getCustomText('send_source', $defaultSendSourceText);
        bot('sendMessage', [
            'chat_id' => $from_id, 'text' => $sendSourceText,
            'reply_to_message_id' => $message_id, 'reply_markup' => $back,
        ]);
        $user['step'] = 'sendsource';
        saveJson("users/$from_id.json", $user);
    }

    // === محبوب ترین ها ===
    elseif ($text == '🔥 محبوب ترین ها') {
        $Scan = @scandir('file');
        $result = '';
        if ($Scan) {
            $Scan = array_diff($Scan, ['.', '..']);
            $allfie = 0;
            foreach ($Scan as $Value) { if (is_file("file/$Value")) $allfie++; }
            $showCount = min($allfie, 18);
            for ($t = 0; $t < $showCount; $t++) {
                $topFile = top($t, 'like');
                if (empty($topFile) || !file_exists("file/$topFile.json")) continue;
                $fileData = safeJsonRead("file/$topFile.json");
                $fid = isset($fileData['id']) ? $fileData['id'] : $topFile;
                $fCaption = isset($fileData['caption']) ? $fileData['caption'] : '';
                $fLike = isset($fileData['like']) ? $fileData['like'] : 0;
                $name = explode("\n", $fCaption);
                $result .= "📌 نام سورس: {$name[0]}\n❤️ تعداد لایک: $fLike\n📥 دریافت سورس: /file_$fid\n\n";
            }
        }
        if (empty($result)) $result = "هنوز سورسی موجود نیست.\n";
        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "♥️ لیست سورس‌های محبوب\n\n$result\n━ ━ ━ ━\n🎁 لینک دعوت: t.me/$usernamebot?start=$from_id\n\n👨‍💻 تیم تیتان TITAN",
        ]);
    }

    // === جدیدترین ها ===
    elseif ($text == '🆕 جدیدترین ها') {
        $Scan = @scandir('file');
        $result = '';
        if ($Scan) {
            $Scan = array_diff($Scan, ['.', '..']);
            $allfie = 0;
            foreach ($Scan as $Value) { if (is_file("file/$Value")) $allfie++; }
            $showCount = min($allfie, 18);
            for ($t = 0; $t < $showCount; $t++) {
                $topFile = top($t, 'id');
                if (empty($topFile) || !file_exists("file/$topFile.json")) continue;
                $fileData = safeJsonRead("file/$topFile.json");
                $fid = isset($fileData['id']) ? $fileData['id'] : $topFile;
                $fCaption = isset($fileData['caption']) ? $fileData['caption'] : '';
                $fLike = isset($fileData['like']) ? $fileData['like'] : 0;
                $name = explode("\n", $fCaption);
                $result .= "📌 نام سورس: {$name[0]}\n❤️ تعداد لایک: $fLike\n📥 دریافت سورس: /file_$fid\n\n";
            }
        }
        if (empty($result)) $result = "هنوز سورسی موجود نیست.\n";
        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "🗂 لیست سورس‌های جدید\n\n$result\n━ ━ ━ ━\n👈🏻 کانال سورس‌ها: @$channel1\n\n👨‍💻 تیم تیتان TITAN",
        ]);
    }

    // === حساب کاربری ===
    elseif ($text == '👤 حساب کاربری') {
        $user = ensureUserExists($from_id);
        $userCoin = isset($user['coin']) ? $user['coin'] : 0;
        $userMember = isset($user['member']) ? $user['member'] : 0;
        $userFile = isset($user['file']) ? $user['file'] : 0;
        $userLike = isset($user['like']) ? $user['like'] : 0;
        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "👤 حساب کاربری شما در $botname:\n\n🆔 شناسه: $from_id\n🗣 نام: $first_name\n\n💎 موجودی حساب: $userCoin تیتانیوم\n👥 تعداد زیر مجموعه: $userMember نفر\n\n📁 تعداد فایل دریافت شده: $userFile\n👍🏻 تعداد لایک انجام شده: $userLike\n\n👨‍💻 تیم تیتان TITAN\n📣 @Confingfree2025 | @sourcetitan",
        ]);
    }

    // === افزایش تیتانیوم ===
    elseif ($text == '💎 افزایش تیتانیوم') {
        $user = ensureUserExists($from_id);
        $inviteText = getCustomText('invite_banner', $defaultInviteText);
        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "👇🏻 یکی از بخش‌های زیر را جهت افزایش تیتانیوم انتخاب کنید\n💎 تیتانیوم حساب شما: {$user['coin']}\n\n🗣 با دعوت دوستان تیتانیوم دریافت کنید",
            'reply_markup' => json_encode([
                'keyboard' => [[['text' => '🗣 دعوت دیگران']], [['text' => '🔙 بازگشت']]],
                'resize_keyboard' => true,
            ])
        ]);
    }

    // === پشتیبانی ===
    elseif ($text == '📞 پشتیبانی') {
        $supportText = getCustomText('support', $defaultSupportText);
        bot('sendMessage', [
            'chat_id' => $from_id, 'text' => $supportText,
            'reply_to_message_id' => $message_id, 'reply_markup' => $back
        ]);
        $user['step'] = 'sup';
        saveJson("users/$from_id.json", $user);
    }

    // === راهنما ===
    elseif ($text == '📖 راهنما') {
        $guideText = getCustomText('guide', $defaultGuideText);
        bot('sendMessage', ['chat_id' => $from_id, 'text' => $guideText, 'reply_to_message_id' => $message_id]);
    }

    // === دعوت دیگران ===
    elseif ($text == '🗣 دعوت دیگران') {
        $inviteText = getCustomText('invite_banner', $defaultInviteText);
        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "$inviteText\n\n👇🏻 لینک دعوت:\nt.me/$usernamebot?start=$from_id"
        ]);
    }

    // =====================================================
    // ========== پنل مدیریت (فقط مالک) ===================
    // =====================================================
    elseif (($text == '🔐 پنل مدیریت' || $text == 'پنل') && $tc == 'private') {
        if (isOwner($from_id, $owner_id)) {
            bot('sendMessage', [
                'chat_id' => $from_id,
                'text' => "📍 فرمانده عزیز به پنل مدیریت ربات خوش آمدید\n\n👨‍💻 تیم تیتان TITAN",
                'reply_markup' => $adminPanelKeyboard
            ]);
            $user['step'] = 'none';
            unset($user['admin_section']);
            saveJson("users/$from_id.json", $user);
        } else {
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "⛔️ شما دسترسی به پنل مدیریت ندارید."]);
        }
    }

    // =====================================================
    // ========== 💎 بخش تیتانیوم ==========================
    // =====================================================
    elseif ($text == '💎 بخش تیتانیوم' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش مدیریت تیتانیوم\n\nیک گزینه را انتخاب کنید:", 'reply_markup' => getTitaniumKeyboard()]);
        $user['step'] = 'none';
        $user['admin_section'] = 'titanium';
        saveJson("users/$from_id.json", $user);
    }

    // === تیتانیوم همگانی ===
    elseif ($text == '📤 تیتانیوم همگانی' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 فرمانده، چند تیتانیوم میخواهید به تمام اعضا انتقال دهید؟\n\nتعداد را ارسال کنید:", 'reply_markup' => $adminBack]);
        $user['step'] = 'mass_titanium';
        $user['admin_section'] = 'titanium';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'mass_titanium' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            $amount = (float)$text;
            if ($amount > 0) {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "✔️ در حال ارسال $amount تیتانیوم به تمام اعضا..."]);
                foreach (glob('users/*.json') as $array) {
                    $userID = str_replace(['users/', '.json'], '', $array);
                    if (is_numeric($userID)) {
                        $tu = safeJsonRead($array);
                        $tu['coin'] = (string)((float)(isset($tu['coin']) ? $tu['coin'] : 0) + $amount);
                        saveJson($array, $tu);
                    }
                }
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ $amount تیتانیوم به تمام اعضا ارسال شد"]);
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "❌ عدد نامعتبر"]);
            }
            $user['step'] = 'none';
            $user['admin_section'] = 'titanium';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش تیتانیوم", 'reply_markup' => getTitaniumKeyboard()]);
        }
    }

    // === ارسال تیتانیوم ===
    elseif ($text == '➕ ارسال تیتانیوم' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "💎 لطفا در سطر اول آیدی که میخواهید به آن تیتانیوم انتقال دهید بنویسید\nو در سطر دوم تعداد تیتانیوم که میخواهید بدهید بنویسید\n\nمثال:\n112233446\n50",
            'reply_markup' => $adminBack
        ]);
        $user['step'] = 'send_titanium';
        $user['admin_section'] = 'titanium';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'send_titanium' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            $all = explode("\n", $text);
            if (count($all) >= 2 && is_numeric(trim($all[0]))) {
                $targetId = trim($all[0]);
                $amount = (float)trim($all[1]);
                if (file_exists("users/$targetId.json") && $amount > 0) {
                    $targetUser = safeJsonRead("users/$targetId.json");
                    $currentCoin = (float)(isset($targetUser['coin']) ? $targetUser['coin'] : 0);
                    $user['temp_target'] = $targetId;
                    $user['temp_amount'] = $amount;
                    $user['step'] = 'confirm_send_titanium';
                    saveJson("users/$from_id.json", $user);
                    bot('sendMessage', [
                        'chat_id' => $from_id,
                        'text' => "👤 این شخص در حال حاضر $currentCoin تیتانیوم دارد.\n\n➕ مقدار ارسالی: $amount تیتانیوم\n💎 موجودی جدید: " . ($currentCoin + $amount) . " تیتانیوم\n\nآیا تایید میکنید؟",
                        'reply_markup' => getYesNoKeyboard()
                    ]);
                } else {
                    bot('sendMessage', ['chat_id' => $from_id, 'text' => "❌ کاربر یافت نشد یا عدد نامعتبر"]);
                    $user['step'] = 'none';
                    saveJson("users/$from_id.json", $user);
                    bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش تیتانیوم", 'reply_markup' => getTitaniumKeyboard()]);
                }
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "❌ فرمت نادرست"]);
                $user['step'] = 'none';
                saveJson("users/$from_id.json", $user);
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش تیتانیوم", 'reply_markup' => getTitaniumKeyboard()]);
            }
        }
    }

    elseif ($userStep == 'confirm_send_titanium' && isOwner($from_id, $owner_id)) {
        if ($text == '✅ بله') {
            $targetId = isset($user['temp_target']) ? $user['temp_target'] : '';
            $amount = isset($user['temp_amount']) ? (float)$user['temp_amount'] : 0;
            if (!empty($targetId) && file_exists("users/$targetId.json")) {
                $targetUser = safeJsonRead("users/$targetId.json");
                $coin = (float)(isset($targetUser['coin']) ? $targetUser['coin'] : 0) + $amount;
                $targetUser['coin'] = "$coin";
                saveJson("users/$targetId.json", $targetUser);
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ $amount تیتانیوم به کاربر $targetId ارسال شد"]);
                bot('sendMessage', ['chat_id' => $targetId, 'text' => "✅ $amount تیتانیوم از طرف مدیریت به شما ارسال شد.\n💎 موجودی جدید: $coin تیتانیوم"]);
            }
        } else {
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "❌ لغو شد"]);
        }
        unset($user['temp_target'], $user['temp_amount']);
        $user['step'] = 'none';
        $user['admin_section'] = 'titanium';
        saveJson("users/$from_id.json", $user);
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش تیتانیوم", 'reply_markup' => getTitaniumKeyboard()]);
    }

    // === کسر تیتانیوم ===
    elseif ($text == '➖ کسر تیتانیوم' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "💎 لطفا در سطر اول آیدی که میخواهید از آن تیتانیوم کسر کنید بنویسید\nو در سطر دوم تعداد تیتانیوم که میخواهید کسر کنید بنویسید\n\nمثال:\n112233446\n50",
            'reply_markup' => $adminBack
        ]);
        $user['step'] = 'deduct_titanium';
        $user['admin_section'] = 'titanium';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'deduct_titanium' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            $all = explode("\n", $text);
            if (count($all) >= 2 && is_numeric(trim($all[0]))) {
                $targetId = trim($all[0]);
                $amount = (float)trim($all[1]);
                if (file_exists("users/$targetId.json") && $amount > 0) {
                    $targetUser = safeJsonRead("users/$targetId.json");
                    $currentCoin = (float)(isset($targetUser['coin']) ? $targetUser['coin'] : 0);
                    $user['temp_target'] = $targetId;
                    $user['temp_amount'] = $amount;
                    $user['step'] = 'confirm_deduct_titanium';
                    saveJson("users/$from_id.json", $user);
                    $newCoin = max(0, $currentCoin - $amount);
                    bot('sendMessage', [
                        'chat_id' => $from_id,
                        'text' => "👤 این شخص در حال حاضر $currentCoin تیتانیوم دارد.\n\n➖ مقدار کسر: $amount تیتانیوم\n💎 موجودی جدید: $newCoin تیتانیوم\n\nآیا تایید میکنید؟",
                        'reply_markup' => getYesNoKeyboard()
                    ]);
                } else {
                    bot('sendMessage', ['chat_id' => $from_id, 'text' => "❌ کاربر یافت نشد یا عدد نامعتبر"]);
                    $user['step'] = 'none';
                    saveJson("users/$from_id.json", $user);
                    bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش تیتانیوم", 'reply_markup' => getTitaniumKeyboard()]);
                }
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "❌ فرمت نادرست"]);
                $user['step'] = 'none';
                saveJson("users/$from_id.json", $user);
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش تیتانیوم", 'reply_markup' => getTitaniumKeyboard()]);
            }
        }
    }

    elseif ($userStep == 'confirm_deduct_titanium' && isOwner($from_id, $owner_id)) {
        if ($text == '✅ بله') {
            $targetId = isset($user['temp_target']) ? $user['temp_target'] : '';
            $amount = isset($user['temp_amount']) ? (float)$user['temp_amount'] : 0;
            if (!empty($targetId) && file_exists("users/$targetId.json")) {
                $targetUser = safeJsonRead("users/$targetId.json");
                $coin = max(0, (float)(isset($targetUser['coin']) ? $targetUser['coin'] : 0) - $amount);
                $targetUser['coin'] = "$coin";
                saveJson("users/$targetId.json", $targetUser);
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ $amount تیتانیوم از کاربر $targetId کسر شد"]);
                bot('sendMessage', ['chat_id' => $targetId, 'text' => "⚠️ $amount تیتانیوم از حساب شما کسر شد.\n💎 موجودی جدید: $coin تیتانیوم"]);
            }
        } else {
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "❌ لغو شد"]);
        }
        unset($user['temp_target'], $user['temp_amount']);
        $user['step'] = 'none';
        $user['admin_section'] = 'titanium';
        saveJson("users/$from_id.json", $user);
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "💎 بخش تیتانیوم", 'reply_markup' => getTitaniumKeyboard()]);
    }

    // === تنظیمات امتیاز ===
    elseif ($text == '⚙️ تنظیمات امتیاز' && isOwner($from_id, $owner_id)) {
        $sa = getSetting('score_approve', 3);
        $si = getSetting('score_invite', 1);
        $sj = getSetting('score_join', 0);
        $sl = getSetting('score_like', 0);
        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "⚙️ تنظیمات امتیاز فعلی:\n\n🏆 تایید سورس: $sa تیتانیوم\n👥 زیر مجموعه: $si تیتانیوم\n🚪 موقع ورود: $sj تیتانیوم\n❤️ لایک پست: $sl تیتانیوم\n\nیک گزینه را انتخاب کنید:",
            'reply_markup' => getScoreSettingsKeyboard()
        ]);
        $user['step'] = 'none';
        $user['admin_section'] = 'score_settings';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($text == '🏆 امتیاز تایید سورس' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "🏆 فرمانده، امتیاز مورد نظر خود را ارسال کنید\n\n(میتوانید اعداد اعشاری مثل 0.5 هم ارسال کنید)", 'reply_markup' => $adminBack]);
        $user['step'] = 'set_score_approve';
        $user['admin_section'] = 'score_settings';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'set_score_approve' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            setSetting('score_approve', (float)$text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ امتیاز تایید سورس به $text تیتانیوم تنظیم شد"]);
            $user['step'] = 'none';
            $user['admin_section'] = 'score_settings';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "⚙️ تنظیمات امتیاز", 'reply_markup' => getScoreSettingsKeyboard()]);
        }
    }

    elseif ($text == '👥 امتیاز زیر مجموعه' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "👥 فرمانده، امتیاز مورد نظر خود را ارسال کنید\n\n(میتوانید اعداد اعشاری مثل 0.5 هم ارسال کنید)", 'reply_markup' => $adminBack]);
        $user['step'] = 'set_score_invite';
        $user['admin_section'] = 'score_settings';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'set_score_invite' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            setSetting('score_invite', (float)$text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ امتیاز زیر مجموعه به $text تیتانیوم تنظیم شد"]);
            $user['step'] = 'none';
            $user['admin_section'] = 'score_settings';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "⚙️ تنظیمات امتیاز", 'reply_markup' => getScoreSettingsKeyboard()]);
        }
    }

    elseif ($text == '🚪 امتیاز موقع ورود' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "🚪 فرمانده، امتیاز مورد نظر خود را ارسال کنید\n\n(میتوانید اعداد اعشاری مثل 0.5 هم ارسال کنید)", 'reply_markup' => $adminBack]);
        $user['step'] = 'set_score_join';
        $user['admin_section'] = 'score_settings';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'set_score_join' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            setSetting('score_join', (float)$text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ امتیاز موقع ورود به $text تیتانیوم تنظیم شد"]);
            $user['step'] = 'none';
            $user['admin_section'] = 'score_settings';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "⚙️ تنظیمات امتیاز", 'reply_markup' => getScoreSettingsKeyboard()]);
        }
    }

    elseif ($text == '❤️ امتیاز لایک پست' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "❤️ فرمانده، امتیاز مورد نظر خود را ارسال کنید\n\n(میتوانید اعداد اعشاری مثل 0.5 هم ارسال کنید)", 'reply_markup' => $adminBack]);
        $user['step'] = 'set_score_like';
        $user['admin_section'] = 'score_settings';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'set_score_like' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            setSetting('score_like', (float)$text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ امتیاز لایک پست به $text تیتانیوم تنظیم شد"]);
            $user['step'] = 'none';
            $user['admin_section'] = 'score_settings';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "⚙️ تنظیمات امتیاز", 'reply_markup' => getScoreSettingsKeyboard()]);
        }
    }

    // =====================================================
    // ========== 📊 آمار ربات ============================
    // =====================================================
    elseif ($text == '📊 آمار ربات' && isAdmin($from_id, $list, $owner_id)) {
        $Scan = @scandir('users');
        $alluser = 0; $activeUsers = 0;
        if ($Scan) {
            $Scan = array_diff($Scan, ['.', '..']);
            foreach ($Scan as $Value) {
                if (is_file("users/$Value")) {
                    $alluser++;
                    $uid = str_replace('.json', '', $Value);
                    $check = bot('getChatMember', ['chat_id' => "@$channel2", 'user_id' => $uid]);
                    if (isset($check->result->status) && $check->result->status != 'left' && $check->result->status != 'kicked') {
                        $activeUsers++;
                    }
                }
            }
        }
        // اگه تعداد کاربران زیاده از چک فعال صرفنظر کن
        if ($alluser > 100) $activeUsers = '~';

        $Scan2 = @scandir('file');
        $allfile = 0;
        if ($Scan2) { $Scan2 = array_diff($Scan2, ['.', '..']); foreach ($Scan2 as $Value) { if (is_file("file/$Value")) $allfile++; } }

        $totalLikes = getStats('total_likes', 0);
        $totalDownloads = getStats('total_downloads', 0);
        $approvedSources = getStats('approved_sources', 0);
        $rejectedSources = getStats('rejected_sources', 0);
        $lite = safeFileRead("Lite.txt", "نامشخص");

        // محاسبه لایک و دانلود از فایل‌ها
        $realLikes = 0; $realDownloads = 0;
        $fileScan = @scandir('file');
        if ($fileScan) {
            $fileScan = array_diff($fileScan, ['.', '..']);
            foreach ($fileScan as $fv) {
                if (is_file("file/$fv")) {
                    $fd = safeJsonRead("file/$fv");
                    $realLikes += (int)(isset($fd['like']) ? $fd['like'] : 0);
                    $realDownloads += (int)(isset($fd['download']) ? $fd['download'] : 0);
                }
            }
        }

        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "🤖 آمار ربات شما:\n\n▫️ تعداد کاربران : $alluser\n▫️ تعداد فایل : $allfile\n▫️ تعداد لایک ها : $realLikes\n▫️ تعداد دانلود ها : $realDownloads\n▫️ سورس های تایید شده : $approvedSources\n▫️ سورس های رد شده : $rejectedSources\n● اعتبار : $lite\n\n👨‍💻 تیم تیتان TITAN",
        ]);
    }

    // =====================================================
    // ========== 👤 ادمین ها ==============================
    // =====================================================
    elseif ($text == '👤 ادمین ها' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', [
            'chat_id' => $from_id,
            'text' => "🔹 یکی از گزینه‌ها را انتخاب کنید:",
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => '📜 لیست مدیران']],
                    [['text' => '➕ افزودن ادمین'], ['text' => '➖ حذف ادمین']],
                    [['text' => '🔙 برگشت']],
                ],
                'resize_keyboard' => true
            ])
        ]);
        $user['admin_section'] = 'admins';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($text == '📜 لیست مدیران' && isAdmin($from_id, $list, $owner_id)) {
        $admines = '';
        foreach ($list['admins'] as $id) {
            $admines .= "<a href='tg://user?id=$id'>$id</a>\n";
        }
        bot('sendMessage', ['chat_id' => $from_id, 'text' => '📍 لیست مدیران:' . PHP_EOL . $admines, 'parse_mode' => 'html']);
    }

    elseif ($text == '➕ افزودن ادمین' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "آیدی عددی فرد مورد نظر را ارسال کنید 🌱", 'reply_markup' => $adminBack]);
        $user['step'] = 'addadmin';
        $user['admin_section'] = 'admins';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'addadmin') {
        if ($text != '🔙 برگشت' && is_numeric($text)) {
            if (!in_array($text, $list['admins'])) {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ فرد با موفقیت ادمین شد"]);
                $list['admins'][] = $text;
                saveJson("lib/list.json", $list);
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "❗️ فرد مورد نظر از قبل مدیر ربات میباشد!"]);
            }
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        }
    }

    elseif ($text == '➖ حذف ادمین' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "آیدی عددی فرد مورد نظر را ارسال کنید 🌱", 'reply_markup' => $adminBack]);
        $user['step'] = 'removeadmin';
        $user['admin_section'] = 'admins';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'removeadmin') {
        if ($text != '🔙 برگشت' && is_numeric($text)) {
            if (in_array($text, $list['admins'])) {
                $search = array_search($text, $list['admins']);
                unset($list['admins'][$search]);
                $list['admins'] = array_values($list['admins']);
                saveJson("lib/list.json", $list);
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ فرد با موفقیت از ادمینی حذف شد"]);
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "❗️ فرد مورد نظر مدیر ربات نمیباشد!"]);
            }
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        }
    }

    // =====================================================
    // ========== 📤 آپلود سورس (ادمین) ====================
    // =====================================================
    elseif ($text == '📤 آپلود سورس' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 لطفا بنر سورس (عکس با کپشن) را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = 'sendbaner';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'sendbaner') {
        $phto = isset($update->message->photo) ? $update->message->photo : null;
        if ($phto) {
            $photo = end($message->photo)->file_id;
            $caption = isset($message->caption) ? $message->caption : '';
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 لطفا فایل اصلی سورس را ارسال کنید"]);
            $user['step'] = 'setcoin';
            saveJson("users/$from_id.json", $user);
            $datas['data'] = "$photo^$caption";
            saveJson("sendfile.json", $datas);
        }
    }

    elseif ($userStep == 'setcoin') {
        $fileDocId = isset($message->document->file_id) ? $message->document->file_id : '';
        if (!empty($fileDocId)) {
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 لطفا تعداد تیتانیوم برای دانلود را ارسال کنید"]);
            $user['step'] = 'sendfile';
            saveJson("users/$from_id.json", $user);
            $datas['data'] = "{$datas['data']}^$fileDocId";
            saveJson("sendfile.json", $datas);
        }
    }

    elseif ($userStep == 'sendfile') {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 لطفا محدودیت تعداد دانلود رایگان را ارسال کنید"]);
        $datas['data'] = "{$datas['data']}^$text";
        saveJson("sendfile.json", $datas);
        $user['step'] = 'sendlimit';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'sendlimit') {
        $user['step'] = 'none';
        saveJson("users/$from_id.json", $user);
        $datas = safeJsonRead("sendfile.json");
        $explode = explode('^', isset($datas['data']) ? $datas['data'] : '');
        $coinmeys = isset($explode[3]) ? $explode[3] : '0';

        $id = bot('sendPhoto', [
            'chat_id' => "@$channel1", 'photo' => $explode[0], 'caption' => isset($explode[1]) ? $explode[1] : '',
            'reply_markup' => json_encode(['inline_keyboard' => [
                [['text' => '📂 دریافت سورس', 'url' => "https://t.me/$usernamebot?start=file"]],
                [['text' => "📥 دانلود رایگان: 0 از $text", 'callback_data' => 'download']],
                [['text' => "❤️ (0)", 'callback_data' => "like"], ['text' => "🤖 ربات", 'url' => "https://t.me/$usernamebot?start=start"]],
                [['text' => "💎 تیتانیوم = $coinmeys", 'url' => "https://t.me/$usernamebot?start=start"]],
            ]])
        ]);

        if (isset($id->result->message_id)) {
            $msgId = $id->result->message_id;
            bot('editMessageReplyMarkup', [
                'chat_id' => "@$channel1", 'message_id' => $msgId,
                'reply_markup' => makeFileInlineKeyboard($msgId, 0, $text, 0, $coinmeys, $usernamebot, $botname)
            ]);
            $file = [
                'id' => "$msgId", 'file' => isset($explode[2]) ? $explode[2] : '',
                'photo' => $explode[0], 'caption' => isset($explode[1]) ? $explode[1] : '',
                'coindownload' => $coinmeys, 'like' => '0', 'download' => '0',
                'limit' => "$text", 'members' => [], 'likes' => [],
            ];
            saveJson("file/$msgId.json", $file);
        }
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ سورس با موفقیت به کانال @$channel1 ارسال شد"]);
        unset($datas['data']);
        saveJson("sendfile.json", $datas);
    }

    // =====================================================
    // ========== 🗑 حذف سورس =============================
    // =====================================================
    elseif ($text == '🗑 حذف سورس' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 لطفا شناسه سورس را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = 'deletefile';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'deletefile') {
        if ($text != '🔙 برگشت') {
            if (file_exists("file/$text.json")) {
                bot('deleteMessage', ['chat_id' => "@$channel1", 'message_id' => $text]);
                @unlink("file/$text.json");
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ سورس با موفقیت حذف شد"]);
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => '❌ شناسه یافت نشد']);
            }
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        }
    }

    // =====================================================
    // ========== ✏️ ویرایش سورس ===========================
    // =====================================================
    elseif ($text == '✏️ ویرایش سورس' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 لطفا شناسه سورس را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = 'editebaner';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'editebaner') {
        if ($text != '🔙 برگشت') {
            if (file_exists("file/$text.json")) {
                $fil = safeJsonRead("file/$text.json");
                $fCaption = isset($fil['caption']) ? $fil['caption'] : '';
                $fPhoto = isset($fil['photo']) ? $fil['photo'] : '';
                $fLike = isset($fil['like']) ? $fil['like'] : 0;
                $fLimit = isset($fil['limit']) ? $fil['limit'] : 0;
                $fId = isset($fil['id']) ? $fil['id'] : $text;
                $fCoin = isset($fil['coindownload']) ? $fil['coindownload'] : 0;
                $name = explode("\n", $fCaption);

                bot('sendPhoto', [
                    'chat_id' => $from_id, 'photo' => $fPhoto,
                    'caption' => "🔖نام: {$name[0]}\n📥دانلود: $fLimit\n❤️لایک: $fLike\n📇شناسه: $fId\n💎تیتانیوم: $fCoin\n📜توضیحات: $fCaption\n\nبرای ویرایش از کیبورد زیر استفاده کنید👇🏻:",
                    'reply_markup' => json_encode(['inline_keyboard' => [
                        [['text' => "📂ویرایش فایل️", 'callback_data' => "editefile_$text"]],
                        [['text' => "📥ویرایش محدودیت", 'callback_data' => "editemahdonlod_$text"], ['text' => "💎ویرایش تیتانیوم", 'callback_data' => "editecoindon_$text"]],
                        [['text' => "❤️ویرایش لایک️", 'callback_data' => "editelike_$text"]],
                        [['text' => "📮ارسال در کانال", 'callback_data' => "sendchanel_$text"], ['text' => "📜ویرایش توضیحات", 'callback_data' => "editecaption_$text"]],
                    ]])
                ]);
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => '❌ شناسه یافت نشد']);
            }
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        }
    }

    // =====================================================
    // ========== 📝 تنظیم کانال ===========================
    // =====================================================
    elseif ($text == '📝 تنظیم کانال' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', [
            'chat_id' => $from_id, 'text' => "📝 گزینه مورد نظر را انتخاب کنید",
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => '📍 کانال جوین اجباری'], ['text' => '📍 کانال سورس']],
                    [['text' => '🔙 برگشت']],
                ],
                'resize_keyboard' => true
            ])
        ]);
        $user['admin_section'] = 'channel';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($text == '📍 کانال سورس' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "آیدی کانال را بدون @ ارسال کنید\n⚠️ربات باید ادمین کانال باشد", 'reply_markup' => $adminBack]);
        $user['step'] = 'addch1';
        $user['admin_section'] = 'channel';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'addch1') {
        if ($text != '🔙 برگشت' && preg_match('/^[a-zA-Z0-9_]+$/', $text)) {
            Save("lib/channel1.txt", $text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ کانال سورس تنظیم شد: @$text"]);
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        }
    }

    elseif ($text == '📍 کانال جوین اجباری' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "آیدی کانال را بدون @ ارسال کنید\n⚠️ربات باید ادمین کانال باشد", 'reply_markup' => $adminBack]);
        $user['step'] = 'addch2';
        $user['admin_section'] = 'channel';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'addch2') {
        if ($text != '🔙 برگشت' && preg_match('/^[a-zA-Z0-9_]+$/', $text)) {
            Save("lib/channel2.txt", $text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ کانال جوین اجباری تنظیم شد: @$text"]);
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        }
    }

    // =====================================================
    // ========== 📋 تنظیم متون ============================
    // =====================================================
    elseif ($text == '📋 تنظیم متون' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', [
            'chat_id' => $from_id, 'text' => "📋 تنظیم متون ربات\n\nیک گزینه را انتخاب کنید:",
            'reply_markup' => getTextsKeyboard()
        ]);
        $user['step'] = 'none';
        $user['admin_section'] = 'texts';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($text == '📞 متن پشتیبانی' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📞 فرمانده، لطفا متن مورد نظر خود را ارسال کنید:", 'reply_markup' => $adminBack]);
        $user['step'] = 'set_text_support';
        $user['admin_section'] = 'texts';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'set_text_support' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            setCustomText('support', $text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ متن پشتیبانی با موفقیت تنظیم شد"]);
            $user['step'] = 'none';
            $user['admin_section'] = 'texts';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📋 تنظیم متون", 'reply_markup' => getTextsKeyboard()]);
        }
    }

    elseif ($text == '▶️ متن استارت' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "▶️ فرمانده، لطفا متن مورد نظر خود را ارسال کنید:", 'reply_markup' => $adminBack]);
        $user['step'] = 'set_text_start';
        $user['admin_section'] = 'texts';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'set_text_start' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            setCustomText('start', $text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ متن استارت با موفقیت تنظیم شد"]);
            $user['step'] = 'none';
            $user['admin_section'] = 'texts';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📋 تنظیم متون", 'reply_markup' => getTextsKeyboard()]);
        }
    }

    elseif ($text == '🗣 متن بنر زیرمجموعه‌گیری' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "🗣 فرمانده، لطفا متن مورد نظر خود را ارسال کنید:", 'reply_markup' => $adminBack]);
        $user['step'] = 'set_text_invite';
        $user['admin_section'] = 'texts';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'set_text_invite' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            setCustomText('invite_banner', $text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ متن بنر زیرمجموعه‌گیری با موفقیت تنظیم شد"]);
            $user['step'] = 'none';
            $user['admin_section'] = 'texts';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📋 تنظیم متون", 'reply_markup' => getTextsKeyboard()]);
        }
    }

    elseif ($text == '📖 متن راهنما' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📖 فرمانده، لطفا متن مورد نظر خود را ارسال کنید:", 'reply_markup' => $adminBack]);
        $user['step'] = 'set_text_guide';
        $user['admin_section'] = 'texts';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'set_text_guide' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            setCustomText('guide', $text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ متن راهنما با موفقیت تنظیم شد"]);
            $user['step'] = 'none';
            $user['admin_section'] = 'texts';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📋 تنظیم متون", 'reply_markup' => getTextsKeyboard()]);
        }
    }

    elseif ($text == '📤 متن ارسال سورس' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📤 فرمانده، لطفا متن مورد نظر خود را ارسال کنید:", 'reply_markup' => $adminBack]);
        $user['step'] = 'set_text_sendsource';
        $user['admin_section'] = 'texts';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'set_text_sendsource' && isOwner($from_id, $owner_id)) {
        if ($text != '🔙 برگشت') {
            setCustomText('send_source', $text);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ متن ارسال سورس با موفقیت تنظیم شد"]);
            $user['step'] = 'none';
            $user['admin_section'] = 'texts';
            saveJson("users/$from_id.json", $user);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📋 تنظیم متون", 'reply_markup' => getTextsKeyboard()]);
        }
    }

    // =====================================================
    // ========== 🔍 مشخصات کاربر =========================
    // =====================================================
    elseif ($text == '🔍 مشخصات کاربر' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "👈 آیدی عددی کاربر را ارسال نمایید", 'reply_markup' => $adminBack]);
        $user['step'] = 'holpbot';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'holpbot') {
        if ($text != '🔙 برگشت') {
            if (file_exists("users/$text.json")) {
                $uset = safeJsonRead("users/$text.json");
                bot('sendMessage', [
                    'chat_id' => $from_id,
                    'text' => "👤 مشخصات کاربر $text:\n\n💎 موجودی: " . (isset($uset['coin']) ? $uset['coin'] : 0) . " تیتانیوم\n👥 زیر مجموعه: " . (isset($uset['member']) ? $uset['member'] : 0) . " نفر\n📁 فایل: " . (isset($uset['file']) ? $uset['file'] : 0) . "\n👍🏻 لایک: " . (isset($uset['like']) ? $uset['like'] : 0)
                ]);
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "❌ این کاربر عضو ربات نیست"]);
            }
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        }
    }

    // =====================================================
    // ========== 📨 فوروارد همگانی ========================
    // =====================================================
    elseif ($text == '📨 فوروارد همگانی' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📨 لطفا پیام خود را فوروارد کنید", 'reply_markup' => $adminBack]);
        $user['step'] = 'fortoall';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'fortoall' && isAdmin($from_id, $list, $owner_id)) {
        if ($text != '🔙 برگشت') {
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✔️ فوروارد در حال ارسال..."]);
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
            foreach (glob('users/*.json') as $array) {
                $userID = str_replace(['users/', '.json'], '', $array);
                if (is_numeric($userID)) {
                    bot('forwardMessage', ['chat_id' => $userID, 'from_chat_id' => $from_id, 'message_id' => $message_id]);
                }
            }
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ فوروارد به تمامی کاربران انجام شد"]);
        }
    }

    // =====================================================
    // ========== 📩 ارسال همگانی ==========================
    // =====================================================
    elseif ($text == '📩 ارسال همگانی' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📩 لطفا متن یا رسانه خود را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = 'sendtoall';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'sendtoall' && isAdmin($from_id, $list, $owner_id)) {
        if ($text != '🔙 برگشت') {
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✔️ پیام در حال ارسال..."]);
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
            foreach (glob('users/*.json') as $array) {
                $userID = str_replace(['users/', '.json'], '', $array);
                if (is_numeric($userID)) {
                    bot('copyMessage', ['chat_id' => $userID, 'from_chat_id' => $from_id, 'message_id' => $message_id]);
                }
            }
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ پیام به تمامی کاربران ارسال شد"]);
        }
    }

    // =====================================================
    // ========== 🚫 مسدود کردن ============================
    // =====================================================
    elseif ($text == '🚫 مسدود کردن' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "🚫 لطفا شناسه عددی کاربر را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = 'block_user';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'block_user') {
        if ($text != '🔙 برگشت' && is_numeric($text)) {
            $block['list'][] = $text;
            saveJson("data/block.json", $block);
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ کاربر $text با موفقیت مسدود شد"]);
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        }
    }

    // =====================================================
    // ========== ✅ رفع مسدودیت ===========================
    // =====================================================
    elseif ($text == '✅ رفع مسدودیت' && isAdmin($from_id, $list, $owner_id)) {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ لطفا شناسه عددی کاربر را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = 'unblock_user';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'unblock_user') {
        if ($text != '🔙 برگشت' && is_numeric($text)) {
            if (in_array($text, $block['list']) || in_array("$text", $block['list'])) {
                $block['list'] = array_values(array_diff($block['list'], [$text, "$text"]));
                saveJson("data/block.json", $block);
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ مسدودیت کاربر $text رفع شد"]);
            } else {
                bot('sendMessage', ['chat_id' => $from_id, 'text' => "❗️ این کاربر مسدود نیست"]);
            }
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
        }
    }

    // =====================================================
    // ========== 👥 منو کاربران ==========================
    // =====================================================
    elseif ($text == '👥 منو کاربران' && isOwner($from_id, $owner_id)) {
        bot('sendMessage', [
            'chat_id' => $from_id, 'text' => "⬅️ به منوی کاربران بازگشتید\n\n$maintext",
            'reply_markup' => $home
        ]);
        $user['step'] = 'none';
        unset($user['admin_section']);
        saveJson("users/$from_id.json", $user);
    }

    // =====================================================
    // === Step: sendsource (کاربران) ======================
    // =====================================================
    elseif ($userStep == 'sendsource') {
        $phto = isset($update->message->photo) ? $update->message->photo : null;
        if ($phto) {
            $photo = end($message->photo)->file_id;
            $caption = isset($message->caption) ? $message->caption : '';
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 لطفا فایل اصلی سورس را ارسال کنید"]);
            $user['step'] = 'usersetcoin';
            $user['data'] = "$photo^$caption";
            saveJson("users/$from_id.json", $user);
        }
    }

    elseif ($userStep == 'usersetcoin') {
        $fileDocId = isset($message->document->file_id) ? $message->document->file_id : '';
        if (!empty($fileDocId)) {
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 لطفا تعداد تیتانیوم برای دانلود را ارسال کنید"]);
            $user['step'] = 'usersendfile';
            $user['data'] = "{$user['data']}^$fileDocId";
            saveJson("users/$from_id.json", $user);
        }
    }

    elseif ($userStep == 'usersendfile') {
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "📍 تعداد محدودیت دانلود رایگان را وارد کنید:"]);
        $user['data'] = "{$user['data']}^$text";
        $user['step'] = 'usersendlimit';
        saveJson("users/$from_id.json", $user);
    }

    elseif ($userStep == 'usersendlimit') {
        $user['data'] = "{$user['data']}^$text";
        $user['step'] = 'none';
        saveJson("users/$from_id.json", $user);
        $explode = explode('^', $user['data']);
        $coinmeys = isset($explode[3]) ? $explode[3] : '0';
        $ijjyd = bot('sendPhoto', [
            'chat_id' => $from_id, 'photo' => $explode[0], 'caption' => isset($explode[1]) ? $explode[1] : '',
            'reply_markup' => json_encode(['inline_keyboard' => [
                [['text' => '📂 دریافت سورس', 'url' => "https://t.me/$usernamebot?start=file"]],
                [['text' => "📥 دانلود رایگان: 0 از $text", 'callback_data' => 'download']],
                [['text' => "❤️ (0)", 'callback_data' => "like"], ['text' => "🤖 ربات", 'url' => "https://t.me/$usernamebot?start=start"]],
                [['text' => "💎 تیتانیوم = $coinmeys", 'url' => "https://t.me/$usernamebot?start=start"]],
            ]])
        ]);
        $msgId = isset($ijjyd->result->message_id) ? $ijjyd->result->message_id : 0;
        if ($msgId > 0) {
            $ojugf = bot('sendMessage', [
                'chat_id' => $from_id,
                'text' => "سورس شما با این محتویات به ادمین جهت بررسی و تایید ارسال شود؟\n\n❗️در سورس نباید اشاره‌ای به شخص یا کانالی شده باشد!",
                'reply_to_message_id' => $msgId,
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "✅ تایید", 'callback_data' => "taied-$msgId"]]]])
            ]);
            $ojugfId = isset($ojugf->result->message_id) ? $ojugf->result->message_id : 0;
            $fil = [
                'msgid' => "$ojugfId", 'userid' => "$from_id", 'id' => "$msgId",
                'file' => isset($explode[2]) ? $explode[2] : '', 'photo' => $explode[0],
                'caption' => isset($explode[1]) ? $explode[1] : '', 'coindownload' => $coinmeys,
                'like' => '0', 'download' => '0', 'limit' => "$text",
            ];
            saveJson("data/$msgId.json", $fil);
        }
        unset($user['data']);
        saveJson("users/$from_id.json", $user);
    }

    // === Step: sup ===
    elseif ($userStep == 'sup') {
        bot('sendMessage', [
            'chat_id' => $from_id, 'text' => '✅ پیام شما با موفقیت ارسال شد منتظر پاسخ پشتیبانی باشید',
            'reply_to_message_id' => $message_id, 'reply_markup' => $back
        ]);
        bot('copyMessage', [
            'chat_id' => $owner_id, 'from_chat_id' => $from_id, 'message_id' => $message_id,
            'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "👈🏻 پاسخ به کاربر", 'callback_data' => "pasokh-$from_id"]]]])
        ]);
        $user['step'] = 'none';
        saveJson("users/$from_id.json", $user);
    }

    // === ادمین step‌های ویرایش ===
    elseif (preg_match('/^set0coin_(.*)/', $userStep, $match)) {
        $fileDocId = isset($message->document->file_id) ? $message->document->file_id : '';
        if (!empty($fileDocId)) {
            bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ فایل با موفقیت ثبت شد"]);
            $user['step'] = 'none';
            saveJson("users/$from_id.json", $user);
            $fil = safeJsonRead("file/{$match[1]}.json");
            $fil['file'] = $fileDocId;
            saveJson("file/{$match[1]}.json", $fil);
        }
    }

    elseif (preg_match('/^set1coin_(.*)/', $userStep, $match)) {
        $file = safeJsonRead("file/{$match[1]}.json");
        if (!empty($file)) {
            bot('editMessageReplyMarkup', [
                'chat_id' => "@$channel1", 'message_id' => isset($file['id']) ? $file['id'] : $match[1],
                'reply_markup' => makeFileInlineKeyboard(isset($file['id']) ? $file['id'] : $match[1], isset($file['download']) ? $file['download'] : 0, $text, isset($file['like']) ? $file['like'] : 0, isset($file['coindownload']) ? $file['coindownload'] : 0, $usernamebot, $botname)
            ]);
            $file['limit'] = "$text";
            saveJson("file/{$match[1]}.json", $file);
        }
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ محدودیت دانلود تغییر کرد"]);
        $user['step'] = 'none';
        saveJson("users/$from_id.json", $user);
    }

    elseif (preg_match('/^set2coin_(.*)/', $userStep, $match)) {
        $file = safeJsonRead("file/{$match[1]}.json");
        if (!empty($file)) {
            bot('editMessageReplyMarkup', [
                'chat_id' => "@$channel1", 'message_id' => isset($file['id']) ? $file['id'] : $match[1],
                'reply_markup' => makeFileInlineKeyboard(isset($file['id']) ? $file['id'] : $match[1], isset($file['download']) ? $file['download'] : 0, isset($file['limit']) ? $file['limit'] : 0, isset($file['like']) ? $file['like'] : 0, $text, $usernamebot, $botname)
            ]);
            $file['coindownload'] = "$text";
            saveJson("file/{$match[1]}.json", $file);
        }
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ تیتانیوم تغییر کرد"]);
        $user['step'] = 'none';
        saveJson("users/$from_id.json", $user);
    }

    elseif (preg_match('/^set3coin_(.*)/', $userStep, $match)) {
        $file = safeJsonRead("file/{$match[1]}.json");
        if (!empty($file)) {
            bot('editMessageReplyMarkup', [
                'chat_id' => "@$channel1", 'message_id' => isset($file['id']) ? $file['id'] : $match[1],
                'reply_markup' => makeFileInlineKeyboard(isset($file['id']) ? $file['id'] : $match[1], isset($file['download']) ? $file['download'] : 0, isset($file['limit']) ? $file['limit'] : 0, $text, isset($file['coindownload']) ? $file['coindownload'] : 0, $usernamebot, $botname)
            ]);
            $file['like'] = "$text";
            saveJson("file/{$match[1]}.json", $file);
        }
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ لایک تغییر کرد"]);
        $user['step'] = 'none';
        saveJson("users/$from_id.json", $user);
    }

    elseif (preg_match('/^set4coin_(.*)/', $userStep, $match)) {
        $file = safeJsonRead("file/{$match[1]}.json");
        if (!empty($file)) {
            bot('editMessageCaption', [
                'chat_id' => "@$channel1", 'caption' => $text, 'message_id' => isset($file['id']) ? $file['id'] : $match[1],
                'reply_markup' => makeFileInlineKeyboard(isset($file['id']) ? $file['id'] : $match[1], isset($file['download']) ? $file['download'] : 0, isset($file['limit']) ? $file['limit'] : 0, isset($file['like']) ? $file['like'] : 0, isset($file['coindownload']) ? $file['coindownload'] : 0, $usernamebot, $botname)
            ]);
            $file['caption'] = "$text";
            saveJson("file/{$match[1]}.json", $file);
        }
        bot('sendMessage', ['chat_id' => $from_id, 'text' => "✅ کپشن تغییر کرد"]);
        $user['step'] = 'none';
        saveJson("users/$from_id.json", $user);
    }

    // === step msguser ===
    elseif (preg_match('/^msguser-(.*)-(.*)/', $userStep, $match)) {
        $dok = $match[1];
        $dok2val = $match[2];
        bot('EditMessageReplyMarkup', [
            'chat_id' => $from_id, 'message_id' => $dok2val,
            'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "✅ پاسخ داده شد", 'callback_data' => "0"]]]])
        ]);
        bot('copyMessage', ['chat_id' => $dok, 'from_chat_id' => $from_id, 'message_id' => $message_id]);
        bot('sendMessage', [
            'chat_id' => $from_id, 'text' => "✅ پاسخ داده شد", 'reply_to_message_id' => $dok2val,
            'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "پاسخ مجدد", 'callback_data' => "pasokh-$dok"]]]])
        ]);
        $user['step'] = "none";
        saveJson("users/$from_id.json", $user);
    }

    end_processing:

    // === بررسی رفرال ===
    if (isset($user['invite']) && preg_match('/^send (.*)/', $user['invite'], $match)) {
        $memberCheck = bot('getChatMember', ['chat_id' => "@$channel2", 'user_id' => $from_id]);
        $memberStatus = isset($memberCheck->result->status) ? $memberCheck->result->status : 'left';
        if ($memberStatus != 'left') {
            $referrerId = $match[1];
            $scoreInvite = (float)getSetting('score_invite', 1);
            if (file_exists("users/$referrerId.json")) {
                $refData = safeJsonRead("users/$referrerId.json");
                $member = (int)(isset($refData['member']) ? $refData['member'] : 0) + 1;
                $coin = (float)(isset($refData['coin']) ? $refData['coin'] : 0) + $scoreInvite;
                bot('sendMessage', [
                    'chat_id' => $referrerId,
                    'text' => "🌟 تبریک! کاربر [$from_id](tg://user?id=$from_id) با لینک دعوت شما وارد شد\n⬆️ $scoreInvite تیتانیوم اضافه شد\n\n💎 موجودی: $coin تیتانیوم\n👥 زیر مجموعه: $member نفر",
                    'parse_mode' => 'Markdown',
                ]);
                $refData['member'] = "$member";
                $refData['coin'] = "$coin";
                saveJson("users/$referrerId.json", $refData);
            }
            $user['invite'] = null;
            saveJson("users/$from_id.json", $user);
        }
    }
}

// =====================================================
// ============= پردازش CALLBACK QUERY ================
// =====================================================

if ($isCallback && $fromid > 0) {
    $user = safeJsonRead("users/$fromid.json");
    $userStep = getUserStep($user);

    // === join ===
    if ($data == 'join') {
        $memberCheck = bot('getChatMember', ['chat_id' => "@$channel2", 'user_id' => $fromid]);
        $memberStatus = isset($memberCheck->result->status) ? $memberCheck->result->status : 'left';
        if ($memberStatus != 'left') {
            $userHome = getUserKeyboard(isOwner($fromid, $owner_id));
            bot('sendMessage', [
                'chat_id' => $chatid, 'text' => "☑️ عضویت شما تایید شد\n\n$maintext",
                'reply_to_message_id' => $messageid, 'reply_markup' => $userHome
            ]);
        } else {
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback_query_id,
                'text' => "❌ هنوز داخل کانال @$channel2 عضو نیستی", 'show_alert' => true
            ]);
        }
    }

    // === download ===
    elseif ($data == 'download') {
        bot('answerCallbackQuery', [
            'callback_query_id' => $callback_query_id,
            'text' => '❗️ این دکمه جهت نمایش تعداد محدودیت دانلود است', 'show_alert' => true
        ]);
    }

    // === file_XXX ===
    elseif (preg_match('/^file_(.*)/', $data, $match)) {
        $fileId = $match[1];
        $user = ensureUserExists($fromid);
        $memberCheck = bot('getChatMember', ['chat_id' => "@$channel2", 'user_id' => $fromid]);
        $memberStatus = isset($memberCheck->result->status) ? $memberCheck->result->status : 'left';

        if ($memberStatus != 'left') {
            if (file_exists("file/$fileId.json")) {
                $file = safeJsonRead("file/$fileId.json");
                if (!isset($file['members'])) $file['members'] = [];
                $fileLike = isset($file['like']) ? $file['like'] : 0;
                $fileDownload = isset($file['download']) ? (int)$file['download'] : 0;
                $fileLimit = isset($file['limit']) ? (int)$file['limit'] : 0;
                $fileCoin = isset($file['coindownload']) ? (float)$file['coindownload'] : 0;

                if (in_array($fromid, $file['members'])) {
                    bot('sendDocument', [
                        'chat_id' => $fromid, 'document' => isset($file['file']) ? $file['file'] : '',
                        'caption' => isset($file['caption']) ? $file['caption'] : '',
                        'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❤️ ($fileLike)", 'callback_data' => "like_$fileId"]]]])
                    ]);
                } elseif ($fileDownload < $fileLimit) {
                    bot('sendDocument', [
                        'chat_id' => $chatid, 'document' => isset($file['file']) ? $file['file'] : '',
                        'caption' => isset($file['caption']) ? $file['caption'] : '',
                        'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❤️ ($fileLike)", 'callback_data' => "like_$fileId"]]]])
                    ]);
                    $download = $fileDownload + 1;
                    bot('editMessageReplyMarkup', [
                        'chat_id' => "@$channel1", 'message_id' => $fileId,
                        'reply_markup' => makeFileInlineKeyboard($fileId, $download, $fileLimit, $fileLike, $fileCoin, $usernamebot, $botname)
                    ]);
                    $file['members'][] = $fromid;
                    $file['download'] = "$download";
                    saveJson("file/$fileId.json", $file);
                    $user['file'] = (string)((int)(isset($user['file']) ? $user['file'] : 0) + 1);
                    saveJson("users/$fromid.json", $user);
                    addStats('total_downloads');
                } elseif ((float)(isset($user['coin']) ? $user['coin'] : 0) >= $fileCoin) {
                    bot('sendDocument', [
                        'chat_id' => $fromid, 'document' => isset($file['file']) ? $file['file'] : '',
                        'caption' => isset($file['caption']) ? $file['caption'] : '',
                        'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❤️ ($fileLike)", 'callback_data' => "like_$fileId"]]]])
                    ]);
                    $mincoin = (float)$user['coin'] - $fileCoin;
                    $file['members'][] = $fromid;
                    saveJson("file/$fileId.json", $file);
                    $user['coin'] = "$mincoin";
                    $user['file'] = (string)((int)(isset($user['file']) ? $user['file'] : 0) + 1);
                    saveJson("users/$fromid.json", $user);
                    addStats('total_downloads');
                } else {
                    bot('answerCallbackQuery', [
                        'callback_query_id' => $callback_query_id,
                        'text' => '❗️ ظرفیت دانلود رایگان تمام شده و تیتانیوم کافی ندارید', 'show_alert' => true
                    ]);
                }
            }
        } else {
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback_query_id,
                'text' => "❌ ابتدا در کانال @$channel2 عضو شوید", 'show_alert' => true
            ]);
        }
    }

    // === like_XXX ===
    elseif (preg_match('/^like_(.*)/', $data, $match)) {
        $fileId = $match[1];
        $user = ensureUserExists($fromid);
        if (file_exists("file/$fileId.json")) {
            $file = safeJsonRead("file/$fileId.json");
            if (!isset($file['likes'])) $file['likes'] = [];
            if (!in_array($fromid, $file['likes'])) {
                $like = (int)(isset($file['like']) ? $file['like'] : 0) + 1;
                $fileCoin = isset($file['coindownload']) ? $file['coindownload'] : 0;
                $fileDl = isset($file['download']) ? $file['download'] : 0;
                $fileLimit = isset($file['limit']) ? $file['limit'] : 0;
                bot('editMessageReplyMarkup', [
                    'chat_id' => "@$channel1", 'message_id' => $fileId,
                    'reply_markup' => makeFileInlineKeyboard($fileId, $fileDl, $fileLimit, $like, $fileCoin, $usernamebot, $botname)
                ]);
                $file['like'] = "$like";
                $file['likes'][] = $fromid;
                saveJson("file/$fileId.json", $file);
                $scoreLike = (float)getSetting('score_like', 0);
                $user['like'] = (string)((int)(isset($user['like']) ? $user['like'] : 0) + 1);
                $user['coin'] = (string)((float)(isset($user['coin']) ? $user['coin'] : 0) + $scoreLike);
                saveJson("users/$fromid.json", $user);
                addStats('total_likes');
                $likeMsg = '❤️ لایک شما ثبت شد';
                if ($scoreLike > 0) $likeMsg .= "\n💎 $scoreLike تیتانیوم دریافت کردید";
                bot('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => $likeMsg, 'show_alert' => true]);
            } else {
                bot('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => '❗️ شما قبلا لایک کرده‌اید', 'show_alert' => true]);
            }
        }
    }

    // === taied ===
    elseif (preg_match('/^taied-(.*)/', $data, $match)) {
        $fil = safeJsonRead("data/{$match[1]}.json");
        if (!empty($fil)) {
            bot('editMessageReplyMarkup', [
                'chat_id' => $fromid, 'message_id' => isset($fil['msgid']) ? $fil['msgid'] : '',
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "✅ ارسال شد", 'callback_data' => "0"]]]])
            ]);
            $id = bot('sendPhoto', [
                'chat_id' => $owner_id, 'photo' => isset($fil['photo']) ? $fil['photo'] : '',
                'caption' => isset($fil['caption']) ? $fil['caption'] : '',
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '📂 فایل سورس', 'callback_data' => "files_{$match[1]}"]],
                    [['text' => "📥 دانلود: 0 از " . (isset($fil['limit']) ? $fil['limit'] : 0), 'callback_data' => 'download']],
                    [['text' => "✅ تایید", 'callback_data' => "taieds-{$match[1]}"], ['text' => "❌ رد", 'callback_data' => "radsource-{$match[1]}"]],
                    [['text' => "💎 تیتانیوم = " . (isset($fil['coindownload']) ? $fil['coindownload'] : 0), 'url' => "https://t.me/$usernamebot?start=start"]],
                ]])
            ]);
            $newMsgId = isset($id->result->message_id) ? $id->result->message_id : '';
            $fil['msgid'] = "$newMsgId";
            saveJson("data/{$match[1]}.json", $fil);
        }
    }

    // === taieds ===
    elseif (preg_match('/^taieds-(.*)/', $data, $match)) {
        $fil = safeJsonRead("data/{$match[1]}.json");
        if (!empty($fil)) {
            bot('editMessageReplyMarkup', [
                'chat_id' => $fromid, 'message_id' => isset($fil['msgid']) ? $fil['msgid'] : '',
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "✅ تایید شد", 'callback_data' => "0"]]]])
            ]);
            $id = bot('sendPhoto', [
                'chat_id' => "@$channel1", 'photo' => isset($fil['photo']) ? $fil['photo'] : '',
                'caption' => isset($fil['caption']) ? $fil['caption'] : '',
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '📂 دریافت سورس', 'url' => "https://t.me/$usernamebot?start=file"]],
                    [['text' => "📥 دانلود: 0 از " . (isset($fil['limit']) ? $fil['limit'] : 0), 'callback_data' => 'download']],
                    [['text' => "❤️ (0)", 'callback_data' => "like"], ['text' => "🤖 ربات", 'url' => "https://t.me/$usernamebot?start=start"]],
                    [['text' => "💎 تیتانیوم = " . (isset($fil['coindownload']) ? $fil['coindownload'] : 0), 'url' => "https://t.me/$usernamebot?start=start"]],
                ]])
            ]);

            if (isset($id->result->message_id)) {
                $channelMsgId = $id->result->message_id;
                bot('editMessageReplyMarkup', [
                    'chat_id' => "@$channel1", 'message_id' => $channelMsgId,
                    'reply_markup' => makeFileInlineKeyboard($channelMsgId, 0, isset($fil['limit']) ? $fil['limit'] : 0, 0, isset($fil['coindownload']) ? $fil['coindownload'] : 0, $usernamebot, $botname)
                ]);
                bot('sendMessage', ['chat_id' => $fromid, 'text' => "✅ سورس به کانال @$channel1 ارسال شد"]);

                $newFile = [
                    'id' => "$channelMsgId", 'file' => isset($fil['file']) ? $fil['file'] : '',
                    'photo' => isset($fil['photo']) ? $fil['photo'] : '', 'caption' => isset($fil['caption']) ? $fil['caption'] : '',
                    'coindownload' => isset($fil['coindownload']) ? $fil['coindownload'] : '0',
                    'like' => '0', 'download' => '0', 'limit' => isset($fil['limit']) ? $fil['limit'] : '0',
                    'members' => [], 'likes' => [],
                ];
                saveJson("file/$channelMsgId.json", $newFile);
                @unlink("data/{$match[1]}.json");
                addStats('approved_sources');

                $userId = isset($fil['userid']) ? $fil['userid'] : '';
                $scoreApprove = (float)getSetting('score_approve', 3);
                if (!empty($userId) && file_exists("users/$userId.json")) {
                    $senderUser = safeJsonRead("users/$userId.json");
                    $coin = (float)(isset($senderUser['coin']) ? $senderUser['coin'] : 0) + $scoreApprove;
                    bot('sendMessage', ['chat_id' => $userId, 'text' => "🎉 تبریک\n✅ سورس شما تایید شد و $scoreApprove تیتانیوم هدیه دریافت کردید.\n\n🔰 منتظر سورس‌های بعدی شما هستیم.\n\n👨‍💻 تیم تیتان TITAN"]);
                    $senderUser['coin'] = "$coin";
                    saveJson("users/$userId.json", $senderUser);
                }
            }
        }
    }

    // === radsource ===
    elseif (preg_match('/^radsource-(.*)/', $data, $match)) {
        $fil = safeJsonRead("data/{$match[1]}.json");
        if (!empty($fil)) {
            bot('editMessageReplyMarkup', [
                'chat_id' => $fromid, 'message_id' => isset($fil['msgid']) ? $fil['msgid'] : '',
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❌ رد شد", 'callback_data' => "0"]]]])
            ]);
            bot('sendMessage', ['chat_id' => $fromid, 'text' => "📍 سورس رد شد"]);
            $userId = isset($fil['userid']) ? $fil['userid'] : '';
            if (!empty($userId)) {
                bot('sendMessage', ['chat_id' => $userId, 'text' => "⛔️ سورس شما رد شد.\n🔰 منتظر سورس‌های بعدی شما هستیم."]);
            }
            @unlink("data/{$match[1]}.json");
            addStats('rejected_sources');
        }
    }

    // === files_ ===
    elseif (preg_match('/^files_(.*)/', $data, $match)) {
        $fil = safeJsonRead("data/{$match[1]}.json");
        if (!empty($fil) && isset($fil['file'])) {
            bot('sendDocument', ['chat_id' => $fromid, 'document' => $fil['file'], 'caption' => "📂 فایل سورس ارسالی"]);
        } else {
            bot('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => '❌ فایل یافت نشد', 'show_alert' => true]);
        }
    }

    // === pasokh ===
    elseif (preg_match('/^pasokh-(.*)/', $data, $match)) {
        $dok = $match[1];
        bot('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => "✅ پاسخ خود را ارسال کنید", 'show_alert' => true]);
        $mma = bot('EditMessageReplyMarkup', [
            'chat_id' => $fromid, 'message_id' => $messageid,
            'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "انصراف", 'callback_data' => "enseraf-$dok"]]]])
        ]);
        $mmaId = isset($mma->result->message_id) ? $mma->result->message_id : $messageid;
        $user['step'] = "msguser-$dok-$mmaId";
        saveJson("users/$fromid.json", $user);
    }

    // === enseraf ===
    elseif (preg_match('/^enseraf-(.*)/', $data, $match)) {
        bot('EditMessageReplyMarkup', [
            'chat_id' => $fromid, 'message_id' => $messageid,
            'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "👈🏻 پاسخ به کاربر", 'callback_data' => "pasokh-{$match[1]}"]]]])
        ]);
        $user['step'] = "none";
        saveJson("users/$fromid.json", $user);
    }

    // === ویرایش‌های callback ===
    elseif (preg_match('/^editefile_(.*)/', $data, $match)) {
        bot('sendMessage', ['chat_id' => $fromid, 'text' => "📍 فایل جدید را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = "set0coin_{$match[1]}";
        saveJson("users/$fromid.json", $user);
    }

    elseif (preg_match('/^editemahdonlod_(.*)/', $data, $match)) {
        bot('sendMessage', ['chat_id' => $fromid, 'text' => "📍 محدودیت دانلود جدید را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = "set1coin_{$match[1]}";
        saveJson("users/$fromid.json", $user);
    }

    elseif (preg_match('/^editecoindon_(.*)/', $data, $match)) {
        bot('sendMessage', ['chat_id' => $fromid, 'text' => "📍 تیتانیوم جدید را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = "set2coin_{$match[1]}";
        saveJson("users/$fromid.json", $user);
    }

    elseif (preg_match('/^editelike_(.*)/', $data, $match)) {
        bot('sendMessage', ['chat_id' => $fromid, 'text' => "📍 تعداد لایک جدید را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = "set3coin_{$match[1]}";
        saveJson("users/$fromid.json", $user);
    }

    elseif (preg_match('/^editecaption_(.*)/', $data, $match)) {
        bot('sendMessage', ['chat_id' => $fromid, 'text' => "📍 کپشن جدید را ارسال کنید", 'reply_markup' => $adminBack]);
        $user['step'] = "set4coin_{$match[1]}";
        saveJson("users/$fromid.json", $user);
    }

    // === sendchanel ===
    elseif (preg_match('/^sendchanel_(.*)/', $data, $match)) {
        $file = safeJsonRead("file/{$match[1]}.json");
        if (!empty($file)) {
            $id = bot('sendPhoto', [
                'chat_id' => "@$channel1", 'photo' => isset($file['photo']) ? $file['photo'] : '',
                'caption' => isset($file['caption']) ? $file['caption'] : '',
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '📂 دریافت سورس', 'url' => "https://t.me/$usernamebot?start=file"]],
                    [['text' => "📥 0 از 0", 'callback_data' => 'download']],
                    [['text' => "❤️ (0)", 'callback_data' => "like"], ['text' => "🤖 ربات", 'url' => "https://t.me/$usernamebot?start=start"]],
                ]])
            ]);
            if (isset($id->result->message_id)) {
                $newMsgId = $id->result->message_id;
                bot('editMessageReplyMarkup', [
                    'chat_id' => "@$channel1", 'message_id' => $newMsgId,
                    'reply_markup' => makeFileInlineKeyboard($newMsgId, isset($file['download']) ? $file['download'] : 0, isset($file['limit']) ? $file['limit'] : 0, isset($file['like']) ? $file['like'] : 0, isset($file['coindownload']) ? $file['coindownload'] : 0, $usernamebot, $botname)
                ]);
                $newFile = $file;
                $newFile['id'] = "$newMsgId";
                saveJson("file/$newMsgId.json", $newFile);
            }
            bot('sendMessage', ['chat_id' => $fromid, 'text' => "✅ سورس به کانال ارسال شد"]);
        }
    }
}

// پاکسازی
if (file_exists('error_log')) @unlink('error_log');
ob_end_flush();
?>