<?php
/*
titan ربات مدیریت گروه تیتان - نسخه بهبود یافته
titan نویسنده: طاها محمدی - تیم تیتان
titan کانال: @pantherbot10
titan ربات: @TITAN0_0BOT
*/

// ========== تنظیمات اصلی =============
$token = '[TOKEN]';
$bot_username = "[BOT_USERNAME]";
$channel = "[CHANNEL]";
$Dev = [ADMIN]; // آیدی ادمین‌ها

// ============== امنیت ==========
$telegram_ip_ranges = [
    ['lower' => '149.154.160.0', 'upper' => '149.154.175.255'],
    ['lower' => '91.108.4.0',    'upper' => '91.108.7.255'],
];

if (!filter_var($_SERVER['REMOTE_ADDR'], FILTER_VALIDATE_IP)) {
    http_response_code(403);
    exit("دسترسی غیرمجاز");
}

$ip_dec = (float) sprintf("%u", ip2long($_SERVER['REMOTE_ADDR']));
$ok = false;

foreach ($telegram_ip_ranges as $range) {
    $lower_dec = (float) sprintf("%u", ip2long($range['lower']));
    $upper_dec = (float) sprintf("%u", ip2long($range['upper']));
    if ($ip_dec >= $lower_dec && $ip_dec <= $upper_dec) {
        $ok = true;
        break;
    }
}

if (!$ok) {
    http_response_code(403);
    exit("دسترسی غیرمجاز");
}

// ========== توابع کمکی ==============
include_once __DIR__ . '/jdf.php';

$apiURL = "https://api.telegram.org/bot{$token}/";
$dataFolder = __DIR__ . '/data/';

if (!file_exists($dataFolder)) {
    mkdir($dataFolder, 0777, true);
}

// فایل کاربران پی‌وی
$userFile = $dataFolder . 'user.json';
if (!file_exists($userFile)) {
    file_put_contents($userFile, json_encode(['userjop' => []]));
}
$user = json_decode(file_get_contents($userFile), true);

// ========== دریافت آپدیت ===============
$update = json_decode(file_get_contents('php://input'));
$message = $update->message ?? null;
$editedMsg = $update->edited_message ?? null;
$chatMember = $update->chat_member ?? null;
$callbackQ = $update->callback_query ?? null;

// متغیرهای پیام
$text = $message ? ($message->text ?? '') : '';
$chat = $message ? ($message->chat ?? null) : null;
$chat_id = $chat ? $chat->id : null;
$chat_type = $chat ? $chat->type : null;
$message_id = $message ? $message->message_id : null;
$from = $message ? ($message->from ?? null) : null;
$from_id = $from ? $from->id : null;
$first_name = $from ? ($from->first_name ?? '') : '';
$username = $from ? ($from->username ?? '') : '';
$newMembers = $message ? ($message->new_chat_members ?? []) : [];

// متغیرهای کال‌بک
$cb_data = $callbackQ ? ($callbackQ->data ?? '') : '';
$cb_from = $callbackQ ? ($callbackQ->from ?? null) : null;
$cb_from_id = $cb_from ? $cb_from->id : null;
$cb_msg = $callbackQ ? ($callbackQ->message ?? null) : null;
$cb_chat_id = $cb_msg ? $cb_msg->chat->id : null;
$cb_msg_id = $cb_msg ? $cb_msg->message_id : null;

// =============== توابع اصلی ============
function apiRequest($method, $params = []) {
    global $apiURL;
    $url = $apiURL . $method;
    $options = [
        'http' => [
            'header' => "Content-Type: application/json\r\n",
            'method' => 'POST',
            'content' => json_encode($params, JSON_UNESCAPED_UNICODE),
            'timeout' => 10,
        ]
    ];
    $context = stream_context_create($options);
    $result = @file_get_contents($url, false, $context);
    if ($result === false) {
        error_log("خطا در درخواست به تلگرام: {$method}");
        return null;
    }
    return json_decode($result, true);
}

function getGroupSettings($chatId) {
    global $dataFolder;
    $file = $dataFolder . "{$chatId}.json";
    if (file_exists($file)) {
        $json = file_get_contents($file);
        $arr = json_decode($json, true);
        if (is_array($arr)) return $arr;
    }
    
    $default = [
        'owner_id' => [ADMIN],
        'admins' => [],
        'specials' => [],
        'locks' => [
            'all' => false, 'link' => false, 'hashtag' => false, 'mention' => false,
            'english' => false, 'bot' => false, 'forward' => false, 'audio' => false,
            'voice' => false, 'sticker' => false, 'gif' => false, 'photo' => false,
            'video' => false, 'document' => false, 'poll' => false, 'contact' => false,
            'location' => false, 'text' => false,
        ],
        'filter' => [],
        'warns' => [],
        'warn_limit' => 3,
        'anti_spam' => [
            'enabled' => false, 'msg_per_sec' => 5, 'time_window' => 10, 'users' => [],
        ],
        'anti_delete' => false,
        'welcome_enabled' => true,
        'welcome_text' => "<b>👋 سلام <i>{FIRST_NAME}</i>، خوش آمدید!</b>",
        'anti_flood' => ['enabled' => false, 'max_forward' => 3],
        'created_at' => jdate('Y/m/d H:i'),
        'members' => [],
        'required_channels' => [],
        'awaiting_channel' => false,
        'channel_action' => ''
    ];
    
    file_put_contents($file, json_encode($default, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    return $default;
}

function saveGroupSettings($chatId, $settings) {
    global $dataFolder;
    file_put_contents($dataFolder . "{$chatId}.json", json_encode($settings, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

function replyText($chatId, $text, $message_id = null) {
    $params = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($message_id) $params['reply_to_message_id'] = $message_id;
    apiRequest('sendMessage', $params);
}

function shouldDeleteMessage($settings, $message) {
    $fromId = $message->from->id;
    if ($fromId == $settings['owner_id'] || in_array($fromId, $settings['admins']) || in_array($fromId, $settings['specials'])) {
        return false;
    }
    
    if ($settings['locks']['all']) return true;
    
    $text = $message->text ?? '';
    if ($settings['locks']['link'] && preg_match('/https?:\/\/|t\.me|\.[a-z]{2,}/i', $text)) return true;
    if ($settings['locks']['hashtag'] && strpos($text, '#') !== false) return true;
    if ($settings['locks']['mention'] && strpos($text, '@') !== false) return true;
    if ($settings['locks']['english'] && preg_match('/[a-zA-Z]/', $text)) return true;
    if ($settings['locks']['bot'] && isset($message->from->is_bot) && $message->from->is_bot) return true;
    if ($settings['locks']['forward'] && isset($message->forward_from)) return true;
    if ($settings['locks']['audio'] && isset($message->audio)) return true;
    if ($settings['locks']['voice'] && isset($message->voice)) return true;
    if ($settings['locks']['sticker'] && isset($message->sticker)) return true;
    if ($settings['locks']['gif'] && isset($message->animation)) return true;
    if ($settings['locks']['photo'] && isset($message->photo)) return true;
    if ($settings['locks']['video'] && isset($message->video)) return true;
    if ($settings['locks']['document'] && isset($message->document)) return true;
    if ($settings['locks']['poll'] && isset($message->poll)) return true;
    if ($settings['locks']['contact'] && isset($message->contact)) return true;
    if ($settings['locks']['location'] && isset($message->location)) return true;
    if ($settings['locks']['text'] && isset($message->text) && $message->text !== '') return true;
    
    return false;
}

function isSpam($settings, $chatId, $fromId) {
    if (!$settings['anti_spam']['enabled']) return false;
    
    $now = time();
    $window = $settings['anti_spam']['time_window'];
    $maxMsg = $settings['anti_spam']['msg_per_sec'];
    
    if (!isset($settings['anti_spam']['users'][$fromId])) {
        $settings['anti_spam']['users'][$fromId] = [];
    }
    
    $timestamps = array_filter(
        $settings['anti_spam']['users'][$fromId],
        function($t) use ($now, $window) {
            return ($now - $t) < $window;
        }
    );
    
    $timestamps[] = $now;
    $settings['anti_spam']['users'][$fromId] = $timestamps;
    saveGroupSettings($chatId, $settings);
    
    return count($timestamps) > $maxMsg;
}

function addWarning($settings, $userId) {
    if (!isset($settings['warns'][$userId])) {
        $settings['warns'][$userId] = 0;
    }
    $settings['warns'][$userId] += 1;
    return $settings;
}

// ==================== پاسخ‌های رندم ====================
function getRandomBotResponse() {
    $responses = [
        "تا تیتان اینجاست غم نداشته باش🤖\n  •ا•  @TITAN0_0BOT •ا•",
        "🫡🫡دستور بده فرمانده🫡 🫡\n  •ا•  @TITAN0_0BOT •ا•",
        "🥰🥰جانم عشقم من اینجام 😘😘\n  •ا•  @botsaz04bot •ا•",
        "ها؟ باز این اومد اعصابمون داغون کنه 😫\n  •ا•  @botsaz04bot •ا•",
        "چقدر صدام میکنی دیونه کردی منو اهههه 😮‍💨",
        "انلاینم هر وقت بگی در خدمتم 🤗",
        "این همه منو صدا میکنی خسته نمیشی ؟  خواننده الان باید بگه عجب صبری ربات دارد 😮‍💨😭😭",
        "چیه بزبزقندی 😅"
    ];
    return $responses[array_rand($responses)];
}

function getRandomPingResponse() {
    $responses = [
        "✪ ربات#apiروشن می‌باشد!✪\n⏳زمان پاسخ‌دهی0.6ثانیه⌛️\n┈┅┅━━ا• TITAN•ا━━┅┅┈\n▐ 📥 دریافت ≻0.9 ثانیه 📤\n▐ ♻️  ارسال ≺ 0.7 ثانیه  ♻️\n▐•ا•  @Botsazz0_1bot •ا•\n┈┅⬩◆پینگ سرور: عالی◆⬩┅┈",
        "༺ مُدیریَت آنْلاٰین میبٰاشَد! ༻\n⭑ا⭑ا⭑ا⭑★TITAN★⭑ا⭑ا⭑ا⭑\n🕞 زمان پاسخ دهی 0.3 ثانیه🕞\n►◆✪ سرعت سرور : عالی ✪◆◄\n🤖•ا• @TITAN0_0BOT •ا•🤖\n┈┅┅✅پینگ‌ سرور✅━┅┅┈‌‌‌‌"
    ];
    return $responses[array_rand($responses)];
}

function getRandomTractorResponse() {
    $responses = [
        "تراختور منه جاندی هم جاندی هیجاندی 🚜",
        "شهره سالدون ول وله سن جامی الدون اله داداش یتیشرسنه 😘🥰🥰🥰🚜",
        "یاشاسین تراختور یاشاسین تبریز یاشاسین اردبیل یاشاسین ارومیه یاشاسین زنجان قزوین یاشاسین اذربایجان 🚜🎖️",
        "چکیلیون تراختور گلیر حریفلری بیر بیر دلیر 🚜🚜"
    ];
    return $responses[array_rand($responses)];
}

// ==================== پردازش کال‌بک ====================
if ($callbackQ) {
    $data = $cb_data;
    $chatId = $cb_chat_id;
    $msgId = $cb_msg_id;
    $userId = $cb_from_id;
    $settings = getGroupSettings($chatId);

    $resStatus = apiRequest('getChatMember', ['chat_id' => $chatId, 'user_id' => $userId]);
    $status = ($resStatus['ok'] ?? false) ? $resStatus['result']['status'] : '';
    $isCreatorOrAdmin = in_array($status, ['creator', 'administrator']);
    $isOwner = ($userId == $settings['owner_id']);
    $isAdmin = ($isOwner || in_array($userId, $settings['admins']) || $isCreatorOrAdmin);
    $isSpecial = in_array($userId, $settings['specials']);
    
    if (!($isOwner || $isAdmin || $isCreatorOrAdmin || $isSpecial)) {
        apiRequest('answerCallbackQuery', [
            'callback_query_id' => $callbackQ->id,
            'text' => "دسترسی محدود!",
            'show_alert' => true
        ]);
        exit;
    }

    function callbackAlert($callback_query_id, $text) {
        apiRequest('answerCallbackQuery', [
            'callback_query_id' => $callback_query_id,
            'text' => $text,
            'show_alert' => true
        ]);
    }

    // ==================== منوهای اصلی ====================
    switch ($data) {
        case 'main_panel':
            $buttons = [
                [
                    ['text' => '🪪 اطلاعات', 'callback_data' => 'submenu_info'],
                    ['text' => '🔒 قفل‌ها', 'callback_data' => 'submenu_locks']
                ],
                [
                    ['text' => '🛠️ تنظیمات', 'callback_data' => 'submenu_settings_main'],
                    ['text' => '🔍 راهنما', 'callback_data' => 'show_help']
                ],
                [
                    ['text' => '❌ بستن پنل', 'callback_data' => 'close_panel']
                ]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>به پنل مدیریت تیتان خوش اومدی 🥇</b>\n\nبخش مورد نظر خود را #انتخاب کنید :\n┈┅━صفحه #اصلی ━┅┈",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE),
            ]);
            break;

        case 'submenu_info':
            $buttons = [
                [['text' => '📊 آمار گروه', 'callback_data' => 'submenu_stats']],
                [['text' => '👮 لیست مدیران', 'callback_data' => 'list_admins']],
                [['text' => '🌟 لیست ویژه‌ها', 'callback_data' => 'list_specials']],
                [['text' => '📢 کانال‌های الزامی', 'callback_data' => 'list_channels']],
                [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>🪪 اطلاعات گروه</b>\n\nلطفاً یک گزینه را انتخاب کنید:",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'submenu_locks':
            $locks = $settings['locks'];
            $buttons = [];
            foreach ($locks as $ln => $isLocked) {
                switch ($ln) {
                    case 'all': $labelName = 'همه موارد'; break;
                    case 'link': $labelName = 'لینک‌ها'; break;
                    case 'hashtag': $labelName = 'هشتگ‌ها'; break;
                    case 'mention': $labelName = 'منشن‌ها'; break;
                    case 'english': $labelName = 'متن انگلیسی'; break;
                    case 'bot': $labelName = 'پیام ربات‌ها'; break;
                    case 'forward': $labelName = 'فورواردها'; break;
                    case 'audio': $labelName = 'فایل صوتی'; break;
                    case 'voice': $labelName = 'ویس‌ها'; break;
                    case 'sticker': $labelName = 'استیکرها'; break;
                    case 'gif': $labelName = 'گیف‌ها'; break;
                    case 'photo': $labelName = 'تصاویر'; break;
                    case 'video': $labelName = 'ویدئوها'; break;
                    case 'document': $labelName = 'فایل‌ها'; break;
                    case 'poll': $labelName = 'نظرسنجی‌ها'; break;
                    case 'contact': $labelName = 'مخاطبان'; break;
                    case 'location': $labelName = 'مکان‌ها'; break;
                    case 'text': $labelName = 'متن'; break;
                    default: $labelName = $ln; break;
                }
                $icon = $isLocked ? '🔒' : '🔓';
                $buttons[] = [
                    ['text' => "{$icon} {$labelName}", 'callback_data' => "toggle_lock:{$ln}"]
                ];
            }
            $buttons[] = [['text' => '👈 برگشت', 'callback_data' => 'main_panel']];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>🔒 مدیریت قفل‌ها</b>\n\nبرای فعال/غیرفعال کردن روی دکمه‌ها کلیک کنید.",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE),
            ]);
            break;

        case 'submenu_settings_main':
            $buttons = [
                [['text' => '🚀 مدیریت مودها', 'callback_data' => 'submenu_modes']],
                [['text' => '📝 مدیریت فیلترها', 'callback_data' => 'submenu_filters']],
                [['text' => '👋 تنظیمات خوش‌آمد', 'callback_data' => 'submenu_welcome']],
                [['text' => '🚫 هشدار و بن', 'callback_data' => 'submenu_warns']],
                [
                    ['text' => '➕ کانال الزامی', 'callback_data' => 'add_channel'],
                    ['text' => '➖ حذف کانال', 'callback_data' => 'remove_channel']
                ],
                [['text' => '🛠 تنظیمات گروه', 'callback_data' => 'submenu_settings']],
                [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>🛠️ تنظیمات گروه</b>\n\nلطفاً یک گزینه را انتخاب کنید:",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'submenu_modes':
            $buttons = [
                [[
                    'text' => $settings['anti_spam']['enabled'] ? '✅ ضد اسپم فعال' : '❌ ضد اسپم غیرفعال',
                    'callback_data' => 'toggle_antispam'
                ]],
                [[
                    'text' => $settings['anti_delete'] ? '✅ ضد حذف فعال' : '❌ ضد حذف غیرفعال',
                    'callback_data' => 'toggle_antidelete'
                ]],
                [[
                    'text' => $settings['anti_flood']['enabled'] ? '✅ ضد فلوود فعال' : '❌ ضد فلوود غیرفعال',
                    'callback_data' => 'toggle_antiflood'
                ]],
                [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>🚀 مدیریت مودها</b>\n\nبرای تغییر وضعیت روی دکمه‌ها کلیک کنید.",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'submenu_admins':
            if (!$isOwner) {
                callbackAlert($callbackQ->id, "فقط مالک گروه می‌تواند مدیران را مدیریت کند.");
                break;
            }
            $buttons = [
                [
                    ['text' => '➕ افزودن مدیر', 'callback_data' => 'add_admin'],
                    ['text' => '➖ حذف مدیر', 'callback_data' => 'remove_admin']
                ],
                [['text' => '📋 لیست مدیران', 'callback_data' => 'list_admins']],
                [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>👮 مدیریت مدیران</b>\n\nبرای مدیریت مدیران از دکمه‌ها استفاده کنید.",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'submenu_specials':
            $buttons = [
                [
                    ['text' => '➕ افزودن ویژه', 'callback_data' => 'add_special'],
                    ['text' => '➖ حذف ویژه', 'callback_data' => 'remove_special']
                ],
                [['text' => '📋 لیست ویژه‌ها', 'callback_data' => 'list_specials']],
                [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>🌟 مدیریت کاربران ویژه</b>\n\nبرای مدیریت کاربران ویژه از دکمه‌ها استفاده کنید.",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'submenu_filters':
            $buttons = [
                [
                    ['text' => '➕ افزودن فیلتر', 'callback_data' => 'add_filter'],
                    ['text' => '➖ حذف فیلتر', 'callback_data' => 'remove_filter']
                ],
                [['text' => '📋 لیست فیلترها', 'callback_data' => 'list_filters']],
                [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>📝 مدیریت فیلترها</b>\n\nبرای مدیریت فیلتر کلمات از دکمه‌ها استفاده کنید.",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'submenu_welcome':
            $buttons = [
                [[
                    'text' => $settings['welcome_enabled'] ? '✅ خوش‌آمد فعال' : '❌ خوش‌آمد غیرفعال',
                    'callback_data' => 'toggle_welcome'
                ]],
                [['text' => '📋 نمایش متن خوش‌آمد', 'callback_data' => 'show_welcome']],
                [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>👋 تنظیمات خوش‌آمدگویی</b>\n\nبرای مدیریت خوش‌آمدگویی از دکمه‌ها استفاده کنید.",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'submenu_warns':
            $buttons = [
                [
                    ['text' => '⚠️ هشدار دستی', 'callback_data' => 'manual_warn'],
                    ['text' => '🚫 بن دستی', 'callback_data' => 'manual_ban']
                ],
                [
                    ['text' => '🔄 ریست هشدارها', 'callback_data' => 'reset_warns'],
                    ['text' => '📋 لیست هشدارها', 'callback_data' => 'list_warns']
                ],
                [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>🚫 مدیریت هشدار و بن</b>\n\nبرای مدیریت هشدارها از دکمه‌ها استفاده کنید.",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'submenu_settings':
            $buttons = [
                [
                    ['text' => '📌 پین پیام', 'callback_data' => 'pin_message'],
                    ['text' => '🗑 آن‌پین پیام', 'callback_data' => 'unpin_message']
                ],
                [['text' => '🔄 بازنشانی تنظیمات', 'callback_data' => 'reset_settings']],
                [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
            ];
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>🛠 تنظیمات گروه</b>\n\nبرای مدیریت تنظیمات از دکمه‌ها استفاده کنید.",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'submenu_stats':
            $resAdmin = apiRequest('getChatAdministrators', ['chat_id' => $chatId]);
            $adminsArr = ($resAdmin['ok'] ?? false) ? $resAdmin['result'] : [];
            $adminCount = count($adminsArr);
            
            $resMembers = apiRequest('getChatMembersCount', ['chat_id' => $chatId]);
            $memberCount = ($resMembers['ok'] ?? false) ? $resMembers['result'] : 0;
            
            $bannedCount = count($settings['warns']);
            
            $activeLocks = [];
            foreach ($settings['locks'] as $lockName => $isLocked) {
                if ($isLocked) {
                    switch ($lockName) {
                        case 'all': $labelName = 'همه موارد'; break;
                        case 'link': $labelName = 'لینک‌ها'; break;
                        case 'hashtag': $labelName = 'هشتگ‌ها'; break;
                        case 'mention': $labelName = 'منشن‌ها'; break;
                        case 'english': $labelName = 'متن انگلیسی'; break;
                        case 'bot': $labelName = 'پیام ربات‌ها'; break;
                        case 'forward': $labelName = 'فورواردها'; break;
                        case 'audio': $labelName = 'فایل صوتی'; break;
                        case 'voice': $labelName = 'ویس‌ها'; break;
                        case 'sticker': $labelName = 'استیکرها'; break;
                        case 'gif': $labelName = 'گیف‌ها'; break;
                        case 'photo': $labelName = 'تصاویر'; break;
                        case 'video': $labelName = 'ویدئوها'; break;
                        case 'document': $labelName = 'فایل‌ها'; break;
                        case 'poll': $labelName = 'نظرسنجی‌ها'; break;
                        case 'contact': $labelName = 'مخاطبان'; break;
                        case 'location': $labelName = 'مکان‌ها'; break;
                        case 'text': $labelName = 'متن'; break;
                        default: $labelName = $lockName; break;
                    }
                    $activeLocks[] = $labelName;
                }
            }
            
            $lockCount = count($activeLocks);
            $lockList = $lockCount > 0 ? implode("، ", $activeLocks) : "هیچ قفلی فعال نیست";
            
            $filterCount = count($settings['filter']);
            $welcomeStatus = $settings['welcome_enabled'] ? 'فعال' : 'غیرفعال';
            $specialCount = count($settings['specials']);
            $channelCount = count($settings['required_channels']);
            $channelList = $channelCount > 0 ? implode("، ", array_map(function($c){ return "@{$c}"; }, $settings['required_channels'])) : "هیچ کانالی تعیین نشده";
            
            $statsText = "<b>📊 آمار گروه:</b>\n\n";
            $statsText .= "🔹 تاریخ ایجاد تنظیمات: <code>{$settings['created_at']}</code>\n";
            $statsText .= "🔹 تعداد اعضا: <b>{$memberCount}</b>\n";
            $statsText .= "🔹 تعداد مدیران: <b>{$adminCount}</b>\n";
            $statsText .= "🔹 تعداد بن‌شده‌ها: <b>{$bannedCount}</b>\n\n";
            $statsText .= "🔸 تعداد قفل‌های فعال: <b>{$lockCount}</b>\n";
            $statsText .= "🔸 لیست قفل‌ها: {$lockList}\n\n";
            $statsText .= "🔸 تعداد فیلترها: <b>{$filterCount}</b>\n";
            $statsText .= "🔸 خوش‌آمدگویی: <b>{$welcomeStatus}</b>\n";
            $statsText .= "🔸 کاربران ویژه: <b>{$specialCount}</b>\n";
            $statsText .= "🔸 کانال‌های الزامی: <b>{$channelCount}</b>\n";
            $statsText .= "🔸 لیست کانال‌ها: {$channelList}\n";
            
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => $statsText,
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '👈 برگشت', 'callback_data' => 'submenu_info']]
                ]], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'list_channels':
            $channels = $settings['required_channels'];
            $list = '';
            if (count($channels) == 0) {
                $list = "<i>هیچ کانالی تعیین نشده است.</i>";
            } else {
                foreach ($channels as $channel) {
                    $list .= "• @{$channel}\n";
                }
            }
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>📢 کانال‌های الزامی:</b>\n\n{$list}\n\n👈 برای بازگشت، دکمه «👈 برگشت» را فشار دهید.",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '👈 برگشت', 'callback_data' => 'submenu_info']]
                ]], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'show_help':
            $helpText = "
<b>📖 راهنمای کامل ربات مدیریت گروه تیتان</b>

<b>🔹 دستورات اصلی:</b>
• <code>/panel</code> - نمایش پنل مدیریت
• <code>/install</code> یا <code>نصب</code> - نصب ربات در گروه
• <code>/help</code> - نمایش راهنما

<b>🔸 مدیریت مدیران:</b>
• ریپلای + <code>ادمین</code> یا <code>/promote</code> - افزودن مدیر
• ریپلای + <code>حذف ادمین</code> یا <code>/demote</code> - حذف مدیر
• <code>/adminlist</code> - لیست مدیران

<b>🔸 مدیریت کاربران ویژه:</b>
• ریپلای + <code>ویژه</code> یا <code>/addspecial</code> - افزودن کاربر ویژه
• ریپلای + <code>حذف ویژه</code> یا <code>/removespecial</code> - حذف کاربر ویژه
• <code>/speciallist</code> - لیست کاربران ویژه

<b>🔒 مدیریت قفل‌ها:</b>
• <code>قفل همه</code> یا <code>/lock all</code> - قفل همه موارد
• <code>بازکردن همه</code> یا <code>/unlock all</code> - بازکردن همه قفل‌ها
• <code>قفل لینک</code> یا <code>/lock link</code> - قفل ارسال لینک
• <code>بازکردن لینک</code> یا <code>/unlock link</code> - بازکردن قفل لینک

<b>🚫 سایر قفل‌ها:</b>
• لینک، هشتگ، منشن، انگلیسی، ربات، فوروارد
• صدا، ویس، استیکر، گیف، عکس، ویدیو
• فایل، نظرسنجی، مخاطب، مکان، متن

<b>🚀 مدیریت مودها:</b>
• <code>/antispam on</code> - فعال کردن ضد اسپم
• <code>/antispam off</code> - غیرفعال کردن ضد اسپم
• <code>/antidelete on</code> - فعال کردن ضد حذف
• <code>/antidelete off</code> - غیرفعال کردن ضد حذف
• <code>/antiflood on</code> - فعال کردن ضد فلوود
• <code>/antiflood off</code> - غیرفعال کردن ضد فلوود

<b>👋 خوش‌آمدگویی:</b>
• <code>/welcome on</code> - فعال کردن خوش‌آمد
• <code>/welcome off</code> - غیرفعال کردن خوش‌آمد
• <code>/getwelcome</code> - مشاهده متن خوش‌آمد

<b>📝 مدیریت فیلترها:</b>
• <code>/addfilter کلمه</code> - افزودن کلمه به فیلتر
• <code>/delfilter کلمه</code> - حذف کلمه از فیلتر
• <code>/filterlist</code> - لیست کلمات فیلتر شده

<b>🚫 مدیریت هشدار و بن:</b>
• ریپلای + <code>هشدار</code> یا <code>/warn</code> - اخطار به کاربر
• ریپلای + <code>بن</code> یا <code>/ban</code> - بن کاربر
• <code>/unban آیدی</code> - آن‌بن کردن کاربر
• <code>/setwarn تعداد</code> - تنظیم حد اخطار
• <code>/warninfo</code> - مشاهده اخطارهای کاربر

<b>🔇 مدیریت سکوت:</b>
• ریپلای + <code>سایلنت</code> یا <code>/mute</code> - سکوت کاربر
• ریپلای + <code>آن‌سایلنت</code> یا <code>/unmute</code> - لغو سکوت
• <code>/mute آیدی دقیقه</code> - سکوت کاربر به مدت معین

<b>📌 مدیریت پیام:</b>
• ریپلای + <code>/pin</code> - پین کردن پیام
• <code>/unpin</code> - آن‌پین کردن پیام
• <code>/purge تعداد</code> - حذف تعداد مشخصی پیام

<b>👤 اطلاعات کاربر:</b>
• ریپلای + <code>/info</code> - مشاهده اطلاعات کاربر

<b>👥 تگ اعضا:</b>
• <code>/tagall</code> یا <code>تگ همه</code> - تگ تمام اعضا

<b>📢 کانال‌های الزامی:</b>
• از پنل تنظیمات → کانال الزامی

<b>🤖 سایر امکانات:</b>
• پاسخ خودکار به کلمات خاص
• ضد اسپم پیشرفته
• ضد فلوود
• ضد حذف پیام
• پنل شیشه‌ای
• آمارگیر دقیق
• و ده‌ها قابلیت دیگر...

📞 پشتیبانی: @{$channel}
            ";
            
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => $helpText,
                'parse_mode' => 'HTML',
                'disable_web_page_preview' => true,
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '👈 برگشت', 'callback_data' => 'main_panel']]
                ]], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'close_panel':
            apiRequest('deleteMessage', [
                'chat_id' => $chatId,
                'message_id' => $msgId
            ]);
            break;
// ==================== توگل‌ها ====================
        case 'toggle_antispam':
            $settings['anti_spam']['enabled'] = !$settings['anti_spam']['enabled'];
            saveGroupSettings($chatId, $settings);
            callbackAlert($callbackQ->id, "ضد اسپم " . ($settings['anti_spam']['enabled'] ? 'فعال' : 'غیرفعال') . " شد.");
            break;

        case 'toggle_antidelete':
            $settings['anti_delete'] = !$settings['anti_delete'];
            saveGroupSettings($chatId, $settings);
            callbackAlert($callbackQ->id, "ضد حذف " . ($settings['anti_delete'] ? 'فعال' : 'غیرفعال') . " شد.");
            break;

        case 'toggle_antiflood':
            $settings['anti_flood']['enabled'] = !$settings['anti_flood']['enabled'];
            saveGroupSettings($chatId, $settings);
            callbackAlert($callbackQ->id, "ضد فلوود " . ($settings['anti_flood']['enabled'] ? 'فعال' : 'غیرفعال') . " شد.");
            break;

        case 'toggle_welcome':
            $settings['welcome_enabled'] = !$settings['welcome_enabled'];
            saveGroupSettings($chatId, $settings);
            callbackAlert($callbackQ->id, "خوش‌آمدگویی " . ($settings['welcome_enabled'] ? 'فعال' : 'غیرفعال') . " شد.");
            break;

        // ====== مدیریت ==============
        case 'add_channel':
            $settings['awaiting_channel'] = true;
            $settings['channel_action'] = 'add';
            saveGroupSettings($chatId, $settings);
            callbackAlert($callbackQ->id, "لطفاً یوزرنیم کانال را با @ ارسال کنید.");
            break;

        case 'remove_channel':
            $settings['awaiting_channel'] = true;
            $settings['channel_action'] = 'remove';
            saveGroupSettings($chatId, $settings);
            callbackAlert($callbackQ->id, "لطفاً یوزرنیم کانال را با @ ارسال کنید.");
            break;

        case 'add_admin':
            callbackAlert($callbackQ->id, "روی پیام کاربر ریپلای کنید و /promote را ارسال کنید.");
            break;

        case 'remove_admin':
            callbackAlert($callbackQ->id, "روی پیام کاربر ریپلای کنید و /demote را ارسال کنید.");
            break;

        case 'list_admins':
            $textAdmins = '';
            if (count($settings['admins']) == 0) {
                $textAdmins = "<i>هیچ مدیری تعیین نشده است.</i>";
            } else {
                foreach ($settings['admins'] as $adminId) {
                    $textAdmins .= "• <a href='tg://user?id={$adminId}'>ایدی {$adminId}</a>\n";
                }
            }
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>📋 لیست مدیران:</b>\n\n{$textAdmins}",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '👈 برگشت', 'callback_data' => 'submenu_admins']]
                ]], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'list_specials':
            $textSpecs = '';
            if (count($settings['specials']) == 0) {
                $textSpecs = "<i>هیچ کاربر ویژه‌ای تعیین نشده است.</i>";
            } else {
                foreach ($settings['specials'] as $spId) {
                    $textSpecs .= "• <a href='tg://user?id={$spId}'>ایدی {$spId}</a>\n";
                }
            }
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>📋 لیست کاربران ویژه:</b>\n\n{$textSpecs}",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '👈 برگشت', 'callback_data' => 'submenu_specials']]
                ]], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'list_filters':
            $textFilter = '';
            if (count($settings['filter']) == 0) {
                $textFilter = "<i>هیچ فیلتر فعالی وجود ندارد.</i>";
            } else {
                foreach ($settings['filter'] as $fw) {
                    $textFilter .= "• {$fw}\n";
                }
            }
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>📋 لیست فیلترها:</b>\n\n{$textFilter}",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '👈 برگشت', 'callback_data' => 'submenu_filters']]
                ]], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        case 'list_warns':
            $list = '';
            foreach ($settings['warns'] as $uId => $count) {
                $list .= "• <a href='tg://user?id={$uId}'>ایدی {$uId}</a> » {$count} اخطار\n";
            }
            if ($list === '') {
                $list = "<i>هیچ هشداری ثبت نشده است.</i>";
            }
            apiRequest('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $msgId,
                'text' => "<b>📋 لیست هشدارها:</b>\n\n{$list}",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => '👈 برگشت', 'callback_data' => 'submenu_warns']]
                ]], JSON_UNESCAPED_UNICODE)
            ]);
            break;

        // ================ سایر ================
        default:
            if (strpos($data, 'toggle_lock:') === 0) {
                $parts = explode(':', $data);
                $lockName = $parts[1] ?? '';
                if (isset($settings['locks'][$lockName])) {
                    $settings['locks'][$lockName] = !$settings['locks'][$lockName];
                    saveGroupSettings($chatId, $settings);
                    
                    switch ($lockName) {
                        case 'all': $labelName = 'همه موارد'; break;
                        case 'link': $labelName = 'لینک‌ها'; break;
                        case 'hashtag': $labelName = 'هشتگ‌ها'; break;
                        case 'mention': $labelName = 'منشن‌ها'; break;
                        case 'english': $labelName = 'متن انگلیسی'; break;
                        case 'bot': $labelName = 'پیام ربات‌ها'; break;
                        case 'forward': $labelName = 'فورواردها'; break;
                        case 'audio': $labelName = 'فایل صوتی'; break;
                        case 'voice': $labelName = 'ویس‌ها'; break;
                        case 'sticker': $labelName = 'استیکرها'; break;
                        case 'gif': $labelName = 'گیف‌ها'; break;
                        case 'photo': $labelName = 'تصاویر'; break;
                        case 'video': $labelName = 'ویدئوها'; break;
                        case 'document': $labelName = 'فایل‌ها'; break;
                        case 'poll': $labelName = 'نظرسنجی‌ها'; break;
                        case 'contact': $labelName = 'مخاطبان'; break;
                        case 'location': $labelName = 'مکان‌ها'; break;
                        case 'text': $labelName = 'متن'; break;
                        default: $labelName = $lockName; break;
                    }
                    
                    callbackAlert($callbackQ->id, "قفل {$labelName} " . ($settings['locks'][$lockName] ? 'فعال' : 'غیرفعال') . " شد.");
                }
            }
            break;
    }
    
    exit;
}

// ============ پردازش پیام در گروه =============
if ($message && $chat_type !== 'private') {
    $chatId = $chat_id;
    $fromId = $from_id;
    $settings = getGroupSettings($chatId);
    
    // افزودن کاربر به لیست اعضا
    if (!in_array($fromId, $settings['members'])) {
        $settings['members'][] = $fromId;
        saveGroupSettings($chatId, $settings);
    }
    
    // بررسی وضعیت کاربر
    $resStatus = apiRequest('getChatMember', ['chat_id' => $chatId, 'user_id' => $fromId]);
    $status = ($resStatus['ok'] ?? false) ? $resStatus['result']['status'] : '';
    $isCreatorOrAdmin = in_array($status, ['creator', 'administrator']);
    $isOwner = ($fromId == $settings['owner_id']);
    $isAdmin = ($isOwner || in_array($fromId, $settings['admins']) || $isCreatorOrAdmin);
    $isSpecial = in_array($fromId, $settings['specials']);
    
    // =========== پاسخ‌های رندم ==============
    if ($text !== '') {
        $lowerText = mb_strtolower($text);
        
        // پاسخ به کلمات ربات/تیتان
        $botKeywords = ['ربات', 'رباط', 'تیتان', 'رربات', 'ریبات', 'روبات', 'بات', 'بوتی', 'رات', 'رباتت', 'رببات', 'رووبات', 'رباة', 'رباات', 'ربااات', 'ربیات', 'bot', 'rbot', 'titan', 'what', 'robot'];
        foreach ($botKeywords as $keyword) {
            if (stripos($lowerText, $keyword) !== false) {
                apiRequest('sendMessage', [
                    'chat_id' => $chatId,
                    'text' => getRandomBotResponse(),
                    'reply_to_message_id' => $message_id
                ]);
                exit;
            }
        }
        
        // پاسخ به کلمات پینگ
        $pingKeywords = ['پینگ', 'سرعت', 'سرور', 'پیینگ', 'پپینگ', 'پونگ', 'پانگ', 'پیانگ', 'ping', 'server', 'onlin'];
        foreach ($pingKeywords as $keyword) {
            if (stripos($lowerText, $keyword) !== false) {
                apiRequest('sendMessage', [
                    'chat_id' => $chatId,
                    'text' => getRandomPingResponse(),
                    'reply_to_message_id' => $message_id
                ]);
                exit;
            }
        }
        
        // پاسخ به کلمات تراکتور
        $tractorKeywords = ['تراختور', 'تراکتور', 'تتراختور', 'تراکتورسازی', 'تراختورسازی', 'تراکترسازی'];
        foreach ($tractorKeywords as $keyword) {
            if (stripos($lowerText, $keyword) !== false) {
                apiRequest('sendMessage', [
                    'chat_id' => $chatId,
                    'text' => getRandomTractorResponse(),
                    'reply_to_message_id' => $message_id
                ]);
                exit;
            }
        }
    }
    
    //= اعضای جدید ======
    foreach ($newMembers as $new) {
        $newId = $new->id;
        
        if (!in_array($newId, $settings['members'])) {
            $settings['members'][] = $newId;
            saveGroupSettings($chatId, $settings);
        }
        
        if ($settings['welcome_enabled'] && $newId != $settings['owner_id'] && !in_array($newId, $settings['admins']) && !in_array($newId, $settings['specials'])) {
            $welcomeText = str_replace(
                ['{FIRST_NAME}'],
                [$new->first_name],
                $settings['welcome_text']
            );
            
            $sent = apiRequest('sendMessage', [
                'chat_id' => $chatId,
                'text' => $welcomeText,
                'parse_mode' => 'HTML'
            ]);
            
            if ($sent && ($sent['ok'] ?? false)) {
                $welMsgId = $sent['result']['message_id'];
                // حذف پیام خوش‌آمد بعد از 30 ثانیه
                sleep(30);
                apiRequest('deleteMessage', ['chat_id' => $chatId, 'message_id' => $welMsgId]);
            }
        }
    }
    
    // === کانال‌های الزامی ==============
    if ($settings['awaiting_channel'] && $isAdmin) {
        $channelUsername = trim($text);
        if (strpos($channelUsername, '@') === 0) {
            $cleanName = substr($channelUsername, 1);
            
            if ($settings['channel_action'] === 'add') {
                if (!in_array($cleanName, $settings['required_channels'])) {
                    $settings['required_channels'][] = $cleanName;
                    $reply = "✅ کانال {$channelUsername} به لیست الزامی‌ها اضافه شد.";
                } else {
                    $reply = "⚠️ این کانال قبلاً اضافه شده است.";
                }
            } else {
                if (($key = array_search($cleanName, $settings['required_channels'])) !== false) {
                    unset($settings['required_channels'][$key]);
                    $settings['required_channels'] = array_values($settings['required_channels']);
                    $reply = "✅ کانال {$channelUsername} از لیست حذف شد.";
                } else {
                    $reply = "⚠️ این کانال در لیست نیست.";
                }
            }
        } else {
            $reply = "⚠️ لطفاً یوزرنیم کانال را با @ ارسال کنید.";
        }
        
        $settings['awaiting_channel'] = false;
        $settings['channel_action'] = '';
        saveGroupSettings($chatId, $settings);
        replyText($chatId, $reply, $message_id);
        exit;
    }
    // ===== بررسی عضویت در کانال‌ها ==============
    if (!$isOwner && !$isAdmin && !$isSpecial && count($settings['required_channels']) > 0) {
        $notJoined = [];
        foreach ($settings['required_channels'] as $chan) {
            $res = apiRequest('getChatMember', ['chat_id' => "@{$chan}", 'user_id' => $fromId]);
            $status = ($res['ok'] ?? false) ? $res['result']['status'] : 'left';
            if ($status === 'left' || $status === 'kicked') {
                $notJoined[] = $chan;
            }
        }
        
        if (count($notJoined) > 0) {
            apiRequest('deleteMessage', ['chat_id' => $chatId, 'message_id' => $message_id]);
            
            $text = "<b>برای ادامه لطفا عضو کانال های زیر شوید🔗</b>";
            $keyboard = [];
            
            foreach ($notJoined as $chan) {
                $keyboard[] = [
                    ['text' => "@{$chan}", 'url' => "https://t.me/{$chan}"]
                ];
            }
            
            $keyboard[] = [
                ['text' => '✅ عضو شدم', 'callback_data' => 'i_joined']
            ];
            
            apiRequest('sendMessage', [
                'chat_id' => $chatId,
                'text' => $text,
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode([
                    'inline_keyboard' => $keyboard
                ], JSON_UNESCAPED_UNICODE)
            ]);
            
            exit;
        }
    }
    
    // ==================== ضد اسپم ====================
    if (isSpam($settings, $chatId, $fromId)) {
        apiRequest('deleteMessage', ['chat_id' => $chatId, 'message_id' => $message_id]);
        exit;
    }
    
    // ==================== بررسی قفل‌ها ====================
    if (shouldDeleteMessage($settings, $message)) {
        apiRequest('deleteMessage', ['chat_id' => $chatId, 'message_id' => $message_id]);
        exit;
    }
    
    // ==================== دستورات مدیریتی ====================
    $normalizedText = mb_strtolower(str_replace('‌', ' ', $text));
    $replyTo = $message->reply_to_message ?? null;
    $replyId = $replyTo ? $replyTo->from->id : null;
    
    // نصب ربات
    if (($normalizedText === 'نصب' || $normalizedText === '/install') && $isCreatorOrAdmin) {
        if ($settings['owner_id'] == 0) {
            $settings['owner_id'] = $fromId;
            saveGroupSettings($chatId, $settings);
            replyText($chatId, "<b>✅ ربات با موفقیت نصب شد!</b>\n<i>مالک گروه:</i> <a href='tg://user?id={$fromId}'>{$first_name}</a>\n\n<b>برای مشاهده پنل:</b> <code>/panel</code>");
        } else {
            $currentOwner = $settings['owner_id'];
            replyText($chatId, "<b>⚠️ ربات قبلاً نصب شده است.</b>\n<i>مالک گروه:</i> <a href='tg://user?id={$currentOwner}'>ایدی {$currentOwner}</a>");
        }
        exit;
    }
    
    if (($normalizedText === 'نصب' || $normalizedText === '/install') && !$isCreatorOrAdmin) {
        replyText($chatId, "⚠️ دسترسی محدود\nفقط مدیر یا مالک می‌تواند ربات را نصب کند.", $message_id);
        exit;
    }
    
    // نمایش پنل
    if (($normalizedText === 'پنل' || $normalizedText === '/panel') && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $buttons = [
            [
                ['text' => '🪪 اطلاعات', 'callback_data' => 'submenu_info'],
                ['text' => '🔒 قفل‌ها', 'callback_data' => 'submenu_locks']
            ],
            [
                ['text' => '🛠️ تنظیمات', 'callback_data' => 'submenu_settings_main'],
                ['text' => '🔍 راهنما', 'callback_data' => 'show_help']
            ],
            [
                ['text' => '❌ بستن پنل', 'callback_data' => 'close_panel']
            ]
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chatId,
            'text' => "<b>به پنل مدیریت تیتان خوش اومدی 🥇</b>\n\nبخش مورد نظر خود را #انتخاب کنید :\n┈┅━صفحه #اصلی ━┅┈",
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode(['inline_keyboard' => $buttons], JSON_UNESCAPED_UNICODE)
        ]);
        exit;
    }
    
    if (($normalizedText === 'پنل' || $normalizedText === '/panel') && !($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        replyText($chatId, "⚠️ دسترسی محدود\nفقط مدیران می‌توانند پنل را ببینند.", $message_id);
        exit;
    }
    
    // ===== دستورات با ریپلای =============
    if ($replyTo) {
        // افزودن مدیر
        if (($isOwner || $isAdmin || $isCreatorOrAdmin) && in_array($normalizedText, ['ادمین', '/promote'])) {
            if (!in_array($replyId, $settings['admins']) && $replyId != $settings['owner_id']) {
                $settings['admins'][] = $replyId;
                saveGroupSettings($chatId, $settings);
                replyText($chatId, "✅ <a href='tg://user?id={$replyId}'>ایدی {$replyId}</a> به مدیر ارتقا یافت.", $message_id);
            } else {
                replyText($chatId, "⚠️ این کاربر قبلاً مدیر یا مالک است.", $message_id);
            }
            exit;
        }
        
        // حذف مدیر
        if (($isOwner || $isAdmin || $isCreatorOrAdmin) && in_array($normalizedText, ['حذف ادمین', '/demote'])) {
            if (($key = array_search($replyId, $settings['admins'])) !== false) {
                unset($settings['admins'][$key]);
                $settings['admins'] = array_values($settings['admins']);
                saveGroupSettings($chatId, $settings);
                replyText($chatId, "✅ <a href='tg://user?id={$replyId}'>ایدی {$replyId}</a> از فهرست مدیران حذف شد.", $message_id);
            } else {
                replyText($chatId, "⚠️ این کاربر مدیر نیست.", $message_id);
            }
            exit;
        }
        
        // افزودن ویژه
        if (($isOwner || $isAdmin || $isCreatorOrAdmin) && in_array($normalizedText, ['ویژه', '/addspecial'])) {
            if (!in_array($replyId, $settings['specials'])) {
                $settings['specials'][] = $replyId;
                saveGroupSettings($chatId, $settings);
                replyText($chatId, "✅ <a href='tg://user?id={$replyId}'>ایدی {$replyId}</a> به کاربران ویژه اضافه شد.", $message_id);
            } else {
                replyText($chatId, "⚠️ این کاربر قبلاً ویژه بوده است.", $message_id);
            }
            exit;
        }
        
        // حذف ویژه
        if (($isOwner || $isAdmin || $isCreatorOrAdmin) && in_array($normalizedText, ['حذف ویژه', '/removespecial'])) {
            if (($key = array_search($replyId, $settings['specials'])) !== false) {
                unset($settings['specials'][$key]);
                $settings['specials'] = array_values($settings['specials']);
                saveGroupSettings($chatId, $settings);
                replyText($chatId, "✅ <a href='tg://user?id={$replyId}'>ایدی {$replyId}</a> از لیست کاربران ویژه حذف شد.", $message_id);
            } else {
                replyText($chatId, "⚠️ این کاربر ویژه نیست.", $message_id);
            }
            exit;
        }
        
        // هشدار
        if (($isOwner || $isAdmin || $isCreatorOrAdmin) && in_array($normalizedText, ['هشدار', '/warn'])) {
            $settings = addWarning($settings, $replyId);
            if ($settings['warns'][$replyId] >= $settings['warn_limit']) {
                apiRequest('kickChatMember', ['chat_id' => $chatId, 'user_id' => $replyId]);
                unset($settings['warns'][$replyId]);
                saveGroupSettings($chatId, $settings);
                replyText($chatId, "🚫 <a href='tg://user?id={$replyId}'>ایدی {$replyId}</a> به دلیل رسیدن به حد هشدار بن شد.");
            } else {
                saveGroupSettings($chatId, $settings);
                $count = $settings['warns'][$replyId];
                replyText($chatId, "⚠️ <a href='tg://user?id={$replyId}'>ایدی {$replyId}</a> هشدار شماره {$count} دریافت کرد.", $message_id);
            }
            exit;
        }
        
        // بن
        if (($isOwner || $isAdmin || $isCreatorOrAdmin) && in_array($normalizedText, ['بن', '/ban'])) {
            apiRequest('kickChatMember', ['chat_id' => $chatId, 'user_id' => $replyId]);
            replyText($chatId, "🚫 <a href='tg://user?id={$replyId}'>ایدی {$replyId}</a> بن شد.", $message_id);
            exit;
        }
        
        // سکوت
        if (($isOwner || $isAdmin || $isCreatorOrAdmin) && in_array($normalizedText, ['سایلنت', '/mute'])) {
            apiRequest('restrictChatMember', [
                'chat_id' => $chatId,
                'user_id' => $replyId,
                'permissions' => json_encode([
                    'can_send_messages' => false,
                    'can_send_media_messages' => false,
                    'can_send_polls' => false,
                    'can_send_other_messages' => false,
                    'can_add_web_page_previews' => false
                ])
            ]);
            replyText($chatId, "🔇 <a href='tg://user?id={$replyId}'>ایدی {$replyId}</a> سکوت شد.", $message_id);
            exit;
        }
        
        // آن‌سایلنت
        if (($isOwner || $isAdmin || $isCreatorOrAdmin) && in_array($normalizedText, ['/unmute', 'آن‌سایلنت', 'آن سایلنت'])) {
            apiRequest('restrictChatMember', [
                'chat_id' => $chatId,
                'user_id' => $replyId,
                'permissions' => json_encode([
                    'can_send_messages' => true,
                    'can_send_media_messages' => true,
                    'can_send_polls' => true,
                    'can_send_other_messages' => true,
                    'can_add_web_page_previews' => true
                ])
            ]);
            replyText($chatId, "🔊 <a href='tg://user?id={$replyId}'>ایدی {$replyId}</a> آن‌سایلنت شد.", $message_id);
            exit;
        }
        
        // تگ همه
        if (in_array($normalizedText, ['/tagall', 'تگ همه', 'تگهما'])) {
            $allText = "<b>👥 تمام اعضا:</b>\n\n";
            $members = $settings['members'] ?? [];
            
            foreach ($members as $mid) {
                $chatMember = apiRequest('getChatMember', ['chat_id' => $chatId, 'user_id' => $mid]);
                if (isset($chatMember['ok']) && $chatMember['ok']) {
                    $user = $chatMember['result']['user'];
                    $uname = $user['username'] ?? '';
                    $uid = $user['id'];
                    if ($uname !== '') {
                        $allText .= "@{$uname}\n";
                    } else {
                        $allText .= "<a href='tg://user?id={$uid}'>کاربر {$uid}</a>\n";
                    }
                }
            }
            
            apiRequest('sendMessage', [
                'chat_id' => $chatId,
                'text' => $allText,
                'parse_mode' => 'HTML',
                'reply_to_message_id' => $replyTo->message_id
            ]);
            exit;
        }
    }
    
    // ====== سایر دستورات =============
    $lockCommands = [
        'لینک' => 'link', 'هشتگ' => 'hashtag', 'منشن' => 'mention',
        'انگلیسی' => 'english', 'ربات' => 'bot', 'فوروارد' => 'forward',
        'صدا' => 'audio', 'ویس' => 'voice', 'استیکر' => 'sticker',
        'گیف' => 'gif', 'عکس' => 'photo', 'ویدیو' => 'video',
        'فایل' => 'document', 'نظرسنجی' => 'poll', 'مخاطب' => 'contact',
        'مکان' => 'location', 'متن' => 'text'
    ];
    
    foreach ($lockCommands as $persian => $key) {
        if (($normalizedText === "قفل {$persian}" || $normalizedText === "/lock {$key}") && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
            $settings['locks'][$key] = true;
            saveGroupSettings($chatId, $settings);
            replyText($chatId, "✅ قفل «{$persian}» فعال شد.", $message_id);
            exit;
        }
        
        if (($normalizedText === "بازکردن {$persian}" || $normalizedText === "/unlock {$key}") && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
            $settings['locks'][$key] = false;
            saveGroupSettings($chatId, $settings);
            replyText($chatId, "✅ قفل «{$persian}» غیرفعال شد.", $message_id);
            exit;
        }
    }
    // قفل همه
    if (($normalizedText === 'قفل همه' || $normalizedText === '/lock all') && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        foreach ($settings['locks'] as $k => $v) {
            $settings['locks'][$k] = true;
        }
        saveGroupSettings($chatId, $settings);
        replyText($chatId, "✅ همه قفل‌ها فعال شدند.", $message_id);
        exit;
    }
    
    // بازکردن همه
    if (($normalizedText === 'بازکردن همه' || $normalizedText === '/unlock all') && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        foreach ($settings['locks'] as $k => $v) {
            $settings['locks'][$k] = false;
        }
        saveGroupSettings($chatId, $settings);
        replyText($chatId, "✅ همه قفل‌ها غیرفعال شدند.", $message_id);
        exit;
    }
    
    // آن‌بن
    if (strpos($normalizedText, '/unban ') === 0 && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $parts = explode(' ', $text);
        $uid = end($parts);
        if (is_numeric($uid)) {
            apiRequest('unbanChatMember', ['chat_id' => $chatId, 'user_id' => $uid]);
            replyText($chatId, "✅ کاربر <code>{$uid}</code> آن‌بن شد.", $message_id);
        } else {
            replyText($chatId, "⚠️ آیدی نامعتبر.", $message_id);
        }
        exit;
    }
    
    // پین
    if (in_array($normalizedText, ['/pin', 'پین']) && ($isOwner || $isAdmin || $isCreatorOrAdmin) && $replyTo) {
        $pinMsgId = $replyTo->message_id;
        apiRequest('pinChatMessage', ['chat_id' => $chatId, 'message_id' => $pinMsgId]);
        replyText($chatId, "📌 پیام پین شد.", $message_id);
        exit;
    }
    
    // آن‌پین
    if (in_array($normalizedText, ['/unpin', 'آن‌پین', 'آن پین']) && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        apiRequest('unpinChatMessage', ['chat_id' => $chatId]);
        replyText($chatId, "🗑 پین حذف شد.", $message_id);
        exit;
    }
    
    // پاکسازی
    if (strpos($normalizedText, '/purge ') === 0 && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $num = (int) trim(substr($text, strlen('/purge ')));
        if ($num >= 1 && $num <= 300) {
            for ($i = 0; $i < $num; $i++) {
                $mid = $message_id - $i;
                apiRequest('deleteMessage', ['chat_id' => $chatId, 'message_id' => $mid]);
            }
            replyText($chatId, "✅ {$num} پیام حذف شدند.", $message_id);
        } else {
            replyText($chatId, "⚠️ عدد باید بین ۱ تا ۳۰۰ باشد.", $message_id);
        }
        exit;
    }
    
    // اطلاعات کاربر
    if (in_array($normalizedText, ['/info', 'اطلاعات']) && $replyTo) {
        $t = $replyTo->from;
        $role = $t->id == $settings['owner_id'] ? 'مالک' : 
                (in_array($t->id, $settings['admins']) ? 'ادمین' : 
                (in_array($t->id, $settings['specials']) ? 'ویژه' : 'عادی'));
        
        $infoText = "<b>👤 جزئیات کاربر:</b>\n\n";
        $fullname = trim(($t->first_name ?? '') . ' ' . ($t->last_name ?? ''));
        $infoText .= "• نام: <a href='tg://user?id={$t->id}'>{$fullname}</a>\n";
        $infoText .= "• یوزرنیم: @" . ($t->username ?? '-') . "\n";
        $infoText .= "• آیدی: <code>{$t->id}</code>\n";
        $infoText .= "• نقش: <b>{$role}</b>\n";
        
        replyText($chatId, $infoText, $message_id);
        exit;
    }
    
    // مود ضد اسپم
    if ($normalizedText === '/antispam on' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $settings['anti_spam']['enabled'] = true;
        saveGroupSettings($chatId, $settings);
        replyText($chatId, "✅ مود ضد اسپم فعال شد.", $message_id);
        exit;
    }
    
    if ($normalizedText === '/antispam off' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $settings['anti_spam']['enabled'] = false;
        $settings['anti_spam']['users'] = [];
        saveGroupSettings($chatId, $settings);
        replyText($chatId, "✅ مود ضد اسپم غیرفعال شد.", $message_id);
        exit;
    }
    
    // مود ضد حذف
    if ($normalizedText === '/antidelete on' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $settings['anti_delete'] = true;
        saveGroupSettings($chatId, $settings);
        replyText($chatId, "✅ مود ضد حذف فعال شد.", $message_id);
        exit;
    }
    
    if ($normalizedText === '/antidelete off' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $settings['anti_delete'] = false;
        saveGroupSettings($chatId, $settings);
        replyText($chatId, "✅ مود ضد حذف غیرفعال شد.", $message_id);
        exit;
    }
    
    // مود ضد فلوود
    if ($normalizedText === '/antiflood on' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $settings['anti_flood']['enabled'] = true;
        saveGroupSettings($chatId, $settings);
        replyText($chatId, "✅ مود ضد فلوود فعال شد.", $message_id);
        exit;
    }
    
    if ($normalizedText === '/antiflood off' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $settings['anti_flood']['enabled'] = false;
        saveGroupSettings($chatId, $settings);
        replyText($chatId, "✅ مود ضد فلوود غیرفعال شد.", $message_id);
        exit;
    }
    
    // خوش‌آمدگویی
    if ($normalizedText === '/welcome on' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $settings['welcome_enabled'] = true;
        saveGroupSettings($chatId, $settings);
        $txt = str_replace(['{FIRST_NAME}'], [$first_name], $settings['welcome_text']);
        replyText($chatId, "✅ خوش‌آمدگویی فعال شد.\n\nمتن پیام:\n{$txt}", $message_id);
        exit;
    }
    
    if ($normalizedText === '/welcome off' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $settings['welcome_enabled'] = false;
        saveGroupSettings($chatId, $settings);
        replyText($chatId, "✅ خوش‌آمدگویی غیرفعال شد.", $message_id);
        exit;
    }
    
    if ($normalizedText === '/getwelcome' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $txt = str_replace(['{FIRST_NAME}'], [$first_name], $settings['welcome_text']);
        replyText($chatId, "📋 متن خوش‌آمدگویی فعلی:\n\n{$txt}", $message_id);
        exit;
    }
    
    // مدیریت فیلترها
    if (strpos($normalizedText, '/addfilter ') === 0 && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $word = trim(substr($text, strlen('/addfilter ')));
        if ($word !== '' && !in_array($word, $settings['filter'])) {
            $settings['filter'][] = $word;
            saveGroupSettings($chatId, $settings);
            replyText($chatId, "✅ کلمه «{$word}» به فیلتر اضافه شد.", $message_id);
        } else {
            replyText($chatId, "⚠️ کلمه نامعتبر یا تکراری است.", $message_id);
        }
        exit;
    }
    
    if (strpos($normalizedText, '/delfilter ') === 0 && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $word = trim(substr($text, strlen('/delfilter ')));
        if (($key = array_search($word, $settings['filter'])) !== false) {
            unset($settings['filter'][$key]);
            $settings['filter'] = array_values($settings['filter']);
            saveGroupSettings($chatId, $settings);
            replyText($chatId, "✅ کلمه «{$word}» از فیلتر حذف شد.", $message_id);
        } else {
            replyText($chatId, "⚠️ این کلمه در فیلتر وجود ندارد.", $message_id);
        }
        exit;
    }
    
    if ($normalizedText === '/filterlist' && ($isOwner || $isAdmin || $isCreatorOrAdmin)) {
        $list = '';
        if (count($settings['filter']) == 0) {
            $list = "هیچ فیلتر فعالی وجود ندارد.";
        } else {
            foreach ($settings['filter'] as $fw) {
                $list .= "• {$fw}\n";
            }
        }
        replyText($chatId, "📋 لیست فیلترها:\n\n{$list}", $message_id);
        exit;
    }
    
    exit;
}

// ======= چت خصوصی (منوی پی‌وی) ============
if ($chat_type === 'private') {
    global $userFile, $user, $channel, $bot_username, $Dev;
    
    // دستور /start یا /panel
    if ($text == '/start' || $text == '/panel') {
        $keyboard = [
            'keyboard' => [
                [['text' => "➕ افزودن ربات به گروه"]],
                [
                    ['text' => "🔎 راهنما"],
                    ['text' => "🎖️ دستورات امکانات"]
                ],
                [
                    ['text' => "🫡 پشتیبانی"],
                    ['text' => "😍 تبلیغات رایگان"]
                ],
                [
                    ['text' => "🤖 خرید ربات"],
                    ['text' => "🛠️ ابزارها"]
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🤖 ربات مدیریت گروه تیتانTITAN\n\n💬 به برترین ربات #مدیریت گروه با امکانات بی نظیر و سرعت بالا و همیشه انلاین خوش آمدید !\n\n📞 راه های #ارتباطی و راهنمای ربات :\n\n▫️مرحله یکم : از طریق دکمه افزودن ربات به گروه #جدید ، ربات را به گروه اضافه کنید و سپس در گروه #ادمین کنید ، ربات با موفقیت #نصب می شود !\n\n▫️مرحله دوم : دستور پنل یا راهنما را در گروه #ارسال کنید و سپس ربات را #تنظیم کنید !\n\nا┈┅┅━✦━┅┅┈\n\nⓂ️ ربات ما یک ربات همه کاره واسه #مدیریت بهتر گروه و #محافظت از هرگونه فعالیت های مخرب یا ربات تبچی است !\n\n👌 ️پر امکانات ترین و پر #سرعترین ربات درحال حاضره تلگرام با بیشترین قابلیت و مدیریت عالی حتی در گروه 200 هزار نفره !\n\n┈┅┅━✦━┅┅┈\n\n💡 برای کسب #اطلاعات بیشتر درباره ربات لطفا از #دکمه های زیر استفاده کنید !  @$channel\n➖➖➖➖➖",
            'reply_markup' => json_encode($keyboard)
        ]);
        
        $user['userjop'][$from_id]['file'] = 'none';
        file_put_contents($userFile, json_encode($user, JSON_UNESCAPED_UNICODE));
        exit;
    }
    
    // افزودن ربات به گروه
    if ($text == "➕ افزودن ربات به گروه") {
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "برای افزودن ربات به گروه، روی دکمه زیر کلیک کنید:",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "➕ افزودن به گروه", 'url' => "https://t.me/$bot_username?startgroup=start"]]
                ]
            ])
        ]);
        exit;
    }
    
    // راهنما
    if ($text == "🔎 راهنما") {
        $tch = apiRequest('getChatMember', [
            'chat_id' => "@$channel",
            'user_id' => $from_id
        ]);
        
        if (isset($tch['ok']) && $tch['ok'] && in_array($tch['result']['status'], ['member', 'creator', 'administrator'])) {
            $keyboard = [
                'keyboard' => [
                    [
                        ['text' => "🏅 آموزش ادمین کردن"],
                        ['text' => "🎖 آموزش نصب"]
                    ],
                    [['text' => "🔙 بازگشت به منو"]]
                ],
                'resize_keyboard' => true
            ];
            
            apiRequest('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "🚦 راهنما\n\nلطفا بخش مورد نظر خود را انتخاب کنید:",
                'reply_markup' => json_encode($keyboard)
            ]);
        } else {
            apiRequest('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "📣 برای استفاده از امکانات ربات باید عضو کانال اطلاع‌رسانی شوید",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => "📢 عضویت در کانال", 'url' => "https://t.me/$channel"]]
                    ]
                ])
            ]);
        }
        exit;
    }
    // دستورات امکانات
    if ($text == "🎖️ دستورات امکانات") {
        $commands_text = "🎖️ امکانات ربات TITAN:\n\n⛓ 🔓 بیش از ۳۰ قفل ۵ حالته\n⛓ 👨‍🌾 پنل شیشه‌ای و رابط کاربری آسان\n⛓ 😈 مقابله با اعمال مخرب در گروه\n⛓ 🙇‍♂ خوش آمدگویی به اعضای جدید\n⛓ 👥 ادد اجباری\n⛓ 📡 جوین اجباری\n⛓ 🌀 آمارگیر دقیق گروه\n⛓ 👮‍♂ دستورات زماندار\n⛓ 🤵 پشتیبانی تمام وقت\n⛓ 🛠 جلوگیری از بَن شدن گروه\n⛓ ✂️ پاکسازی کلی گروه\n⛓ ⏳ آپتایم و بدون قطعی\n⛓ ⏰ قفل خودکار در ساعات معین\n⛓ 🚫 جلوگیری از اسپم\n⛓ 👨‍💻 درجه بندی کاربران توسط مالک\n⛓ 🧠 هوشمند در مقابل تبچی ها\n⛓ 🙍‍♂ تنظیم دسترسی ادمین های گروه\n⛓ 🖊 تنظیم دستور شخصی توسط مالک\n⛓ 📝 تنظیم قوانین گروه\n⛓ 📆 تنظیم لینک گروه\n⛓ 🎮 امکانات سرگرمی\n⛓ 💶 سرعت بالای پردازش\n⛓ ⬆️ بهترین در تلگرام\n⛓ ⛔️ فیلتر کردن کلمات\n⛓ 👨‍🔧 پنل اختصاصی برای هر کاربر\n⛓ 📝 گزارش فعالیت ها به مالک\n⛓ ♻️ پاکسازی انی و پرسرعت محتوا\n⛓ 🤐 سکوت زماندار کاربران\n⛓ 👮‍♂ بررسی پیام مدیران گروه\n⛓ 📝 ارائه گزارش دقیق به مالک\n⛓ 🗃 پاک کردن الفاظ رکیک\n⛓ 🔗 پاک کردن تبلیغات از گروه";
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $commands_text
        ]);
        exit;
    }
    
    // پشتیبانی
    if ($text == "🫡 پشتیبانی") {
        $keyboard = [
            'keyboard' => [
                [['text' => "🔙 بازگشت به منو"]]
            ],
            'resize_keyboard' => true
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🫡 پشتیبانی\n\nنظرات شما باعث دلگرمی ماست❤️\n➖➖➖➖➖\nانتقادات، پیشنهادات و نظرات خود را برای ما ارسال کنید✔️\n➖➖➖\nلطفا پیام خود را بنویسید:",
            'reply_markup' => json_encode($keyboard)
        ]);
        
        $user['userjop'][$from_id]['file'] = 'sup';
        file_put_contents($userFile, json_encode($user, JSON_UNESCAPED_UNICODE));
        exit;
    }
    
    // تبلیغات رایگان
    if ($text == "😍 تبلیغات رایگان") {
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🎖️ مجموعه گروه تبلیغات رایگان تیتان 🎖️",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "گروه1 تبلیغات رایگان", 'url' => "https://t.me/freetabtitan"]],
                    [['text' => "گروه2 تبلیغات رایگان", 'url' => "https://t.me/freetablig20"]],
                    [['text' => "گروه3 تبلیغات رایگان", 'url' => "https://t.me/freetablig30"]],
                    [['text' => "گروه4 تبلیغات رایگان", 'url' => "https://t.me/freetablig40"]],
                    [['text' => "گروه5 تبلیغات رایگان", 'url' => "https://t.me/freetabtitan50"]],
                    [['text' => "گروه6 تبلیغات رایگان", 'url' => "https://t.me/freetabtitan60"]]
                ]
            ])
        ]);
        exit;
    }
    
    // خرید ربات
    if ($text == "🤖 خرید ربات") {
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🤖 برای خرید ربات به سایت زیر مراجعه کنید:",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "🌐 خرید ربات", 'url' => "http://tiitan0098.ir/"]]
                ]
            ])
        ]);
        exit;
    }
    
    // ابزارها
    if ($text == "🛠️ ابزارها") {
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🛠️ ابزارها\n\nلطفا ابزار مورد نظر را انتخاب کنید:",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "🎵 موزیک یاب", 'url' => "https://t.me/Musiic2026_BOT"]],
                    [['text' => "🤗 دوستیابی", 'url' => "https://t.me/chatvip02bot"]],
                    [['text' => "🤖 ربات‌ساز", 'url' => "https://t.me/Botsazz0_1bot"]],
                    [['text' => "😀 سرگرمی", 'url' => "https://t.me/Fandog11bot"]],
                    [['text' => "🤖 ربات‌ساز 2", 'url' => "https://t.me/TITAN0_4BOT"]],
                    [['text' => "🏆 کد سورس ربات", 'url' => "https://t.me/sourcetitan"]],
                    [['text' => "🎮 برنامه مود شده", 'url' => "https://t.me/TITAN01APK"]]
                ]
            ])
        ]);
        exit;
    }
    
    // بازگشت به منو
    if ($text == "🔙 بازگشت به منو") {
        $keyboard = [
            'keyboard' => [
                [['text' => "➕ افزودن ربات به گروه"]],
                [
                    ['text' => "🔎 راهنما"],
                    ['text' => "🎖️ دستورات امکانات"]
                ],
                [
                    ['text' => "🫡 پشتیبانی"],
                    ['text' => "😍 تبلیغات رایگان"]
                ],
                [
                    ['text' => "🤖 خرید ربات"],
                    ['text' => "🛠️ ابزارها"]
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🤖 به منوی اصلی بازگشتید",
            'reply_markup' => json_encode($keyboard)
        ]);
        
        $user['userjop'][$from_id]['file'] = 'none';
        file_put_contents($userFile, json_encode($user, JSON_UNESCAPED_UNICODE));
        exit;
    }
    
    // آموزش ادمین کردن
    if ($text == "🏅 آموزش ادمین کردن") {
        $admin_text = "📍 آموزش ادمین کردن ربات در گروه\n➖➖\nℹ️ تلگرام فارسی:\n1️⃣ ربات را به گروه اضافه کنید\n2️⃣ به ویرایش گروه بروید\n3️⃣ قسمت مدیران\n4️⃣ افزودن مدیر\n5️⃣ @$bot_username را جستجو کنید\n6️⃣ تمام دسترسی‌ها را فعال کنید";
        
        $keyboard = [
            'keyboard' => [
                [
                    ['text' => "🔙 بازگشت به راهنما"],
                    ['text' => "🏠 منوی اصلی"]
                ]
            ],
            'resize_keyboard' => true
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $admin_text,
            'reply_markup' => json_encode($keyboard)
        ]);
        exit;
    }
    
    // آموزش نصب
    if ($text == "🎖 آموزش نصب") {
        $install_guide = "✅ آموزش نصب ربات:\n\n1️⃣ روی دکمه 'افزودن ربات به گروه' کلیک کنید\n2️⃣ گروه مورد نظر خود را انتخاب کنید\n3️⃣ ربات را در گروه ادمین کنید\n4️⃣ در گروه دستور /add یا 'نصب' را ارسال کنید\n5️⃣ با دستور /panel تنظیمات را انجام دهید\n\n🆔 @$bot_username";
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $install_guide,
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "➕ افزودن به گروه", 'url' => "https://t.me/$bot_username?startgroup=start"]]
                ]
            ])
        ]);
        exit;
    }
    
    // بازگشت به راهنما
    if ($text == "🔙 بازگشت به راهنما") {
        $keyboard = [
            'keyboard' => [
                [
                    ['text' => "🏅 آموزش ادمین کردن"],
                    ['text' => "🎖 آموزش نصب"]
                ],
                [['text' => "🔙 بازگشت به منو"]]
            ],
            'resize_keyboard' => true
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🚦 راهنما\n\nلطفا بخش مورد نظر خود را انتخاب کنید:",
            'reply_markup' => json_encode($keyboard)
        ]);
        exit;
    }
    
    // منوی اصلی
    if ($text == "🏠 منوی اصلی") {
        $keyboard = [
            'keyboard' => [
                [['text' => "➕ افزودن ربات به گروه"]],
                [
                    ['text' => "🔎 راهنما"],
                    ['text' => "🎖️ دستورات امکانات"]
                ],
                [
                    ['text' => "🫡 پشتیبانی"],
                    ['text' => "😍 تبلیغات رایگان"]
                ],
                [
                    ['text' => "🤖 خرید ربات"],
                    ['text' => "🛠️ ابزارها"]
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🤖 به منوی اصلی بازگشتید",
            'reply_markup' => json_encode($keyboard)
        ]);
        
        $user['userjop'][$from_id]['file'] = 'none';
        file_put_contents($userFile, json_encode($user, JSON_UNESCAPED_UNICODE));
        exit;
    }
    
    // پردازش پیام پشتیبانی
    if ($user['userjop'][$from_id]['file'] == 'sup' && $text != "🔙 بازگشت به منو") {
        $keyboard = [
            'keyboard' => [
                [['text' => "🔙 بازگشت به منو"]]
            ],
            'resize_keyboard' => true
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ پیام شما برای پشتیبانی ارسال شد\nبا تشکر از نظر شما",
            'reply_markup' => json_encode($keyboard)
        ]);
        
        // ارسال به ادمین
        if (!empty($Dev)) {
            apiRequest('sendMessage', [
                'chat_id' => $Dev[0],
                'text' => "📩 پیام جدید از کاربر:\n\n👤 نام: $first_name\n🆔 ایدی: $from_id\n📝 پیام: $text"
            ]);
        }
        
        $user['userjop'][$from_id]['file'] = 'none';
        file_put_contents($userFile, json_encode($user, JSON_UNESCAPED_UNICODE));
        exit;
    }
    
    // پاسخ به پیام‌های ریپلای از ادمین
    if ($message && $message->reply_to_message && in_array($from_id, $Dev)) {
        $reply = $message->reply_to_message->forward_from->id ?? null;
        if ($reply) {
            apiRequest('sendMessage', [
                'chat_id' => $reply,
                'text' => "👤 پاسخ پشتیبان:\n\n$text"
            ]);
            
            apiRequest('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "✅ پیام شما برای کاربر ارسال شد"
            ]);
        }
        exit;
    }
    
    // اگر هیچکدام از دستورات بالا نبود، نمایش منوی اصلی
    $keyboard = [
        'keyboard' => [
            [['text' => "➕ افزودن ربات به گروه"]],
            [
                ['text' => "🔎 راهنما"],
                ['text' => "🎖️ دستورات امکانات"]
            ],
            [
                ['text' => "🫡 پشتیبانی"],
                ['text' => "😍 تبلیغات رایگان"]
            ],
            [
                ['text' => "🤖 خرید ربات"],
                ['text' => "🛠️ ابزارها"]
            ]
        ],
        'resize_keyboard' => true,
        'one_time_keyboard' => false
    ];
    
    apiRequest('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🤖 به ربات مدیریت گروه تیتان خوش آمدید!\n\nبرای شروع از دکمه‌های زیر استفاده کنید:",
        'reply_markup' => json_encode($keyboard)
    ]);
    
    exit;
}

// ======team titan===== پایان ======teeam titan=======
?>