$k_main = js(['inline_keyboard' => [
    [['text' => '⚙️ مدیریت', 'callback_data' => 'management'], ['text' => '🔧 تنظیمات', 'callback_data' => 'settings']],
    [['text' => '📞 پشتیبانی', 'callback_data' => 'support'], ['text' => '📚 راهنما', 'callback_data' => 'help']],
    [['text' => '🎮 تفریح و سرگرمی', 'callback_data' => 'fun']],
    [['text' => '✅ تایید و بستن', 'callback_data' => 'close']]
]]);

$b = function($m) {
    return js(['inline_keyboard' => [
        [['text' => '🏛 برگشت', 'callback_data' => 'back_' . $m]]
    ]]);
};

if ($cmd == 'panel' or $cmd == 'پنل') {
    reply("• لطفا بخش مورد نظر خود را انتخاب کنید :", $k_main);
}

if ($data == 'close') {
    edit("• پنل با موفقیت بسته شد!");
}

// مدیریت - صفحه اول
$k_management1 = js(['inline_keyboard' => [
    [['text' => '• پیکربندی ربات', 'callback_data' => 'config']],
    [['text' => '• مالکان گروه', 'callback_data' => 'owners']],
    [['text' => '• مدیران ربات', 'callback_data' => 'admins']],
    [['text' => '+ ویژه‌ها', 'callback_data' => 'vips'], ['text' => '+ اخطاری‌ها', 'callback_data' => 'warns']],
    [['text' => '• افراد اخراجی', 'callback_data' => 'banned']],
    [['text' => '• افراد بی‌صدا', 'callback_data' => 'silenced']],
    [['text' => '• فعالیت مدیران', 'callback_data' => 'admin_activity']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'back_main'], ['text' => 'صفحه بعد ☞', 'callback_data' => 'management2']]
]]);

// مدیریت - صفحه دوم (آخر)
$k_management2 = js(['inline_keyboard' => [
    [['text' => '• قوانین گروه', 'callback_data' => 'rules']],
    [['text' => '• اعضای معاف از جوین', 'callback_data' => 'exempt_join']],
    [['text' => '• اطلاعات تکمیل', 'callback_data' => 'complete_info']],
    [['text' => '+ آمار چپ', 'callback_data' => 'stats_left'], ['text' => '+ آمار ادد', 'callback_data' => 'stats_add']],
    [['text' => '• لیست تگ', 'callback_data' => 'tag_list']],
    [['text' => '• اعضای معاف از ادد', 'callback_data' => 'exempt_add']],
    [['text' => '+ فیلتر کلمات', 'callback_data' => 'filter_words'], ['text' => '+ ورود ممنوع', 'callback_data' => 'entry_ban']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'management1']],
    [['text' => '✅ تأیید و برگشت', 'callback_data' => 'back_main']]
]]);

// تنظیمات اصلی
$k_settings = js(['inline_keyboard' => [
    [['text' => '+ قفل چند حالت', 'callback_data' => 'multi_lock']],
    [['text' => '+ قفل یک حالت', 'callback_data' => 'single_lock']],
    [['text' => '+ تنظیم حالت گروه', 'callback_data' => 'group_mode']],
    [['text' => '✅ تأیید و برگشت', 'callback_data' => 'back_main']]
]]);

// راهنما
$k_help = js(['inline_keyboard' => [
    [['text' => '📋 دستورات کاربری', 'callback_data' => 'user_cmds']],
    [['text' => '🧹 پاکسازی', 'callback_data' => 'clean_cmds'], ['text' => '⚙️ مدیریتی', 'callback_data' => 'manage_cmds']],
    [['text' => '🔒 دستورات قفلی', 'callback_data' => 'lock_cmds']],
    [['text' => '🎮 سرگرمی', 'callback_data' => 'fun_cmds'], ['text' => '⚡ اجباری', 'callback_data' => 'force_cmds']],
    [['text' => '✅ تایید و برگشت', 'callback_data' => 'back_main']]
]]);

// پشتیبانی
$k_support = js(['inline_keyboard' => [
    [['text' => '🤝 اسپانسر', 'callback_data' => 'sponsor']],
    [['text' => '📜 دستورات', 'callback_data' => 'cmds_list']],
    [['text' => '🤖 افزودن ربات به گروه جدید', 'callback_data' => 'add_bot']],
    [['text' => '👨‍💻 سازنده', 'callback_data' => 'creator']],
    [['text' => '👥 گروه‌ها', 'callback_data' => 'groups']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'back_main'], ['text' => '✅ تایید بستن پنل', 'callback_data' => 'close']]
]]);

// قفل چند حالت - صفحه 1
$k_multi_lock1 = js(['inline_keyboard' => [
    [['text' => '+ قفل لینک : حذف پیام 🗑️', 'callback_data' => 'lock_link']],
    [['text' => '+ قفل فوروارد : حذف پیام 🗑️', 'callback_data' => 'lock_forward']],
    [['text' => '+ قفل یوزرنیم : غیرفعال ❌', 'callback_data' => 'lock_username']],
    [['text' => '+ قفل هشتگ : غیرفعال ❌', 'callback_data' => 'lock_hashtag']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'settings']]
]]);

// قفل چند حالت - صفحه 2
$k_multi_lock2 = js(['inline_keyboard' => [
    [['text' => '+ قفل فارسی : غیرفعال ❌', 'callback_data' => 'lock_persian']],
    [['text' => '+ قفل انگلیسی : غیرفعال ❌', 'callback_data' => 'lock_english']],
    [['text' => '+ قفل فحش : غیرفعال ❌', 'callback_data' => 'lock_badword']],
    [['text' => '+ قفل موقعیت : غیرفعال ❌', 'callback_data' => 'lock_location']],
    [['text' => '+ قفل ایموجی : غیرفعال ❌', 'callback_data' => 'lock_emoji']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'multi_lock1'], ['text' => 'صفحه بعد ☞', 'callback_data' => 'multi_lock3']]
]]);

// قفل چند حالت - صفحه 3
$k_multi_lock3 = js(['inline_keyboard' => [
    [['text' => '+ قفل متن : غیرفعال ❌', 'callback_data' => 'lock_text']],
    [['text' => '+ قفل گیف : غیرفعال ❌', 'callback_data' => 'lock_gif']],
    [['text' => '+ قفل مخاطب : غیرفعال ❌', 'callback_data' => 'lock_contact']],
    [['text' => '+ قفل عکس : غیرفعال ❌', 'callback_data' => 'lock_photo']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'multi_lock2'], ['text' => 'صفحه بعد ☞', 'callback_data' => 'multi_lock4']]
]]);

// قفل چند حالت - صفحه 4
$k_multi_lock4 = js(['inline_keyboard' => [
    [['text' => '+ قفل فیلم : غیرفعال ❌', 'callback_data' => 'lock_video']],
    [['text' => '+ قفل صدا : غیرفعال ❌', 'callback_data' => 'lock_voice']],
    [['text' => '+ قفل موزیک : غیرفعال ❌', 'callback_data' => 'lock_audio']],
    [['text' => '+ قفل بازی : غیرفعال ❌', 'callback_data' => 'lock_game']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'multi_lock3'], ['text' => 'صفحه بعد ☞', 'callback_data' => 'multi_lock5']]
]]);

// قفل چند حالت - صفحه 5
$k_multi_lock5 = js(['inline_keyboard' => [
    [['text' => '+ قفل استیکر : غیرفعال ❌', 'callback_data' => 'lock_sticker']],
    [['text' => '+ قفل فایل : غیرفعال ❌', 'callback_data' => 'lock_file']],
    [['text' => '+ قفل اینلاین : غیرفعال ❌', 'callback_data' => 'lock_inline']],
    [['text' => '+ قفل سلفی : غیرفعال ❌', 'callback_data' => 'lock_selfie']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'multi_lock4']],
    [['text' => '✅ تأیید و برگشت', 'callback_data' => 'settings']]
]]);

// قفل تک حالته
$k_single_lock = js(['inline_keyboard' => [
    [['text' => '+ قفل لینک : غیرفعال ❌', 'callback_data' => 'slock_link']],
    [['text' => '+ قفل فوروارد : غیرفعال ❌', 'callback_data' => 'slock_forward']],
    [['text' => '+ قفل یوزرنیم : غیرفعال ❌', 'callback_data' => 'slock_username']],
    [['text' => '+ قفل هشتگ : غیرفعال ❌', 'callback_data' => 'slock_hashtag']],
    [['text' => '+ قفل فارسی : غیرفعال ❌', 'callback_data' => 'slock_persian']],
    [['text' => '+ قفل انگلیسی : غیرفعال ❌', 'callback_data' => 'slock_english']],
    [['text' => '+ قفل فحش : غیرفعال ❌', 'callback_data' => 'slock_badword']],
    [['text' => '+ قفل موقعیت : غیرفعال ❌', 'callback_data' => 'slock_location']],
    [['text' => '+ قفل ایموجی : غیرفعال ❌', 'callback_data' => 'slock_emoji']],
    [['text' => '+ قفل متن : غیرفعال ❌', 'callback_data' => 'slock_text']],
    [['text' => '+ قفل گیف : غیرفعال ❌', 'callback_data' => 'slock_gif']],
    [['text' => '+ قفل مخاطب : غیرفعال ❌', 'callback_data' => 'slock_contact']],
    [['text' => '+ قفل عکس : غیرفعال ❌', 'callback_data' => 'slock_photo']],
    [['text' => '+ قفل فیلم : غیرفعال ❌', 'callback_data' => 'slock_video']],
    [['text' => '+ قفل صدا : غیرفعال ❌', 'callback_data' => 'slock_voice']],
    [['text' => '+ قفل موزیک : غیرفعال ❌', 'callback_data' => 'slock_audio']],
    [['text' => '+ قفل بازی : غیرفعال ❌', 'callback_data' => 'slock_game']],
    [['text' => '+ قفل استیکر : غیرفعال ❌', 'callback_data' => 'slock_sticker']],
    [['text' => '+ قفل فایل : غیرفعال ❌', 'callback_data' => 'slock_file']],
    [['text' => '+ قفل اینلاین : غیرفعال ❌', 'callback_data' => 'slock_inline']],
    [['text' => '+ قفل سلفی : غیرفعال ❌', 'callback_data' => 'slock_selfie']],
    [['text' => '✅ تأیید و برگشت', 'callback_data' => 'settings']]
]]);

// تنظیم حالت گروه - صفحه 1
$k_group_mode1 = js(['inline_keyboard' => [
    [['text' => '+ قفل سراسری : غیرفعال ❌', 'callback_data' => 'global_lock']],
    [['text' => '+ وضعیت قفل خودکار', 'callback_data' => 'auto_lock_status']],
    [['text' => '+ زمان قفل خودکار: ---', 'callback_data' => 'auto_lock_time']],
    [['text' => '+ زمان بازشدن خودکار: ---', 'callback_data' => 'auto_unlock_time']],
    [['text' => '+ پاکسازی خودکار : غیرفعال ❌', 'callback_data' => 'auto_clean']],
    [['text' => '+ سخت‌گیری اصلی : غیرفعال ❌', 'callback_data' => 'hard_main']],
    [['text' => '+ سخت‌گیری فرعی : غیرفعال ❌', 'callback_data' => 'hard_secondary']],
    [['text' => '+ قفل ویرایش رسانه : کاربر', 'callback_data' => 'lock_media_edit']],
    [['text' => '+ مقام‌ها با خروج : پاک بشه', 'callback_data' => 'rank_on_leave']],
    [['text' => '+ پیام‌ها با اخراج : پاک بشه', 'callback_data' => 'msg_on_kick']],
    [['text' => '+ ارسال باسوآن : غیرفعال ❌', 'callback_data' => 'send_basuan']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'settings'], ['text' => 'صفحه بعد ☞', 'callback_data' => 'group_mode2']]
]]);

// تنظیم حالت گروه - صفحه 2
$k_group_mode2 = js(['inline_keyboard' => [
    [['text' => '+ عدم خیانت مدیران : غیرفعال ❌', 'callback_data' => 'no_admin_betrayal']],
    [['text' => '+ گزارش دستورات : غیرفعال ❌', 'callback_data' => 'cmd_report']],
    [['text' => '+ وضعیت دستورات : به مالکان', 'callback_data' => 'cmd_status']],
    [['text' => '+ گزارش حذف : غیرفعال ❌', 'callback_data' => 'delete_report']],
    [['text' => '+ شناسایی تبچی : خودکار', 'callback_data' => 'detect_tabchi']],
    [['text' => '+ حالت ضد تبچی : محدود', 'callback_data' => 'anti_tabchi_mode']],
    [['text' => '+ حالت ورود ممنوع : خاموش', 'callback_data' => 'entry_ban_mode']],
    [['text' => '+ حالت فیلتر کلمات : حذف پیام', 'callback_data' => 'filter_mode']],
    [['text' => '+ حالت قفل لینک : کلی', 'callback_data' => 'lock_link_mode']],
    [['text' => '+ حالت قفل یوزرنیم : کلی', 'callback_data' => 'lock_username_mode']],
    [['text' => '+ حالت قفل فوروارد : کلی', 'callback_data' => 'lock_forward_mode']],
    [['text' => '+ حالت قفل رییالی : کلی', 'callback_data' => 'lock_real_mode']],
    [['text' => '+ حالت قفل استیکر : کلی', 'callback_data' => 'lock_sticker_mode']],
    [['text' => '+ حالت تحرک استیکر : کلی', 'callback_data' => 'sticker_animation_mode']],
    [['text' => '+ نوع قفل استیکر : کلی', 'callback_data' => 'lock_sticker_type']],
    [['text' => '+ حالت قفل ایموجی : کلی', 'callback_data' => 'lock_emoji_mode']],
    [['text' => '+ نوع قفل ایموجی : کلی', 'callback_data' => 'lock_emoji_type']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'group_mode1'], ['text' => 'صفحه بعد ☞', 'callback_data' => 'group_mode3']]
]]);

// تنظیم حالت گروه - صفحه 3
$k_group_mode3 = js(['inline_keyboard' => [
    [['text' => '+ خوشامدگویی گروه : فعال ✅', 'callback_data' => 'welcome']],
    [['text' => '+ دعوت به بازگشت : غیرفعال ❌', 'callback_data' => 'invite_back']],
    [['text' => '+ حذف پیام ربات : روشن', 'callback_data' => 'bot_msg_delete']],
    [['text' => '+ زمان حذف پیام : 30 ثانیه', 'callback_data' => 'delete_time']],
    [['text' => '+ وضعیت هرزنامه : غیرفعال ❌', 'callback_data' => 'spam_status']],
    [['text' => '+ حساسیت هرزنامه : 300 ک', 'callback_data' => 'spam_sensitivity']],
    [['text' => '+ وضعیت رگبار : غیرفعال ❌', 'callback_data' => 'flood_status']],
    [['text' => '+ تعداد پیام رگبار : 5 پیام', 'callback_data' => 'flood_count']],
    [['text' => '+ مقدار زمان رگبار : 3 ثانیه', 'callback_data' => 'flood_time']],
    [['text' => '+ وضعیت اخطار : سکوت', 'callback_data' => 'warn_status']],
    [['text' => '+ تعداد اخطار : 3 بار', 'callback_data' => 'warn_count']],
    [['text' => '+ پاسخ به دستور : فعال ✅', 'callback_data' => 'cmd_reply']],
    [['text' => '+ وضعیت پاسخگویی : مدیران', 'callback_data' => 'reply_status']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'group_mode2'], ['text' => 'صفحه بعد ☞', 'callback_data' => 'group_mode4']]
]]);

// تنظیم حالت گروه - صفحه 4 (آخر)
$k_group_mode4 = js(['inline_keyboard' => [
    [['text' => '+ تنظیمات رسانه موقت', 'callback_data' => 'temp_media_settings']],
    [['text' => '+ حالت عدم ممیزند : غیرفعال ❌', 'callback_data' => 'no_mention_mode']],
    [['text' => '+ حالت عدم فیلترینگ : غیرفعال ❌', 'callback_data' => 'no_filter_mode']],
    [['text' => '+ اجبار اَند : خاموش', 'callback_data' => 'force_end']],
    [['text' => '+ حالت اَند : همه اعضا', 'callback_data' => 'end_mode']],
    [['text' => '+ اجبار عضویت : خاموش', 'callback_data' => 'force_membership']],
    [['text' => '+ حالت عضویت : همه اعضا', 'callback_data' => 'membership_mode']],
    [['text' => '+ نوع عضویت : فردی', 'callback_data' => 'membership_type']],
    [['text' => '+ محدودیت ارسال : غیرفعال ❌', 'callback_data' => 'send_limit']],
    [['text' => '+ زمان محدودیت : 1 روز', 'callback_data' => 'limit_time']],
    [['text' => '+ محدودیت عضو ویژه : غیرفعال ❌', 'callback_data' => 'vip_limit']],
    [['text' => '+ گزارش تخلف : غیرفعال ❌', 'callback_data' => 'violation_report']],
    [['text' => '+ وضعیت تخلف : به مالکان', 'callback_data' => 'violation_status']],
    [['text' => '+ ساعت گروه : در هر دو', 'callback_data' => 'group_time']],
    [['text' => '+ رویداد در گروه : فعال ✅', 'callback_data' => 'event_in_group']],
    [['text' => '+ سنجاق رویداد : فعال ✅', 'callback_data' => 'pin_event']],
    [['text' => '☜ صفحه قبل', 'callback_data' => 'group_mode3']],
    [['text' => '✅ تأیید و برگشت', 'callback_data' => 'settings']]
]]);

// تفریح و سرگرمی (نمونه)
$k_fun = js(['inline_keyboard' => [
    [['text' => '🎲 بازی', 'callback_data' => 'game']],
    [['text' => '😂 جوک', 'callback_data' => 'joke']],
    [['text' => '🏛 برگشت', 'callback_data' => 'back_main']]
]]);
// مدیریت callback_data
if ($data == 'management') {
    edit("# مدیریت ربات تیتان\n\nقسمت مورد نظر را انتخاب کنید:", $k_management1);
}

if ($data == 'management2') {
    edit("# پنل مدیریت تیتان\n\nقسمت مورد نظر را انتخاب کنید:", $k_management2);
}

if ($data == 'settings') {
    edit("# تنظیمات گروه تیتان\n\nقسمت مورد نظر را انتخاب کنید:", $k_settings);
}

if ($data == 'help') {
    edit("# راهنمای تیتان\n\nقسمت مورد نظر را انتخاب کنید:", $k_help);
}

if ($data == 'support') {
    edit("# پشتیبانی تیتان\n\nقسمت مورد نظر را انتخاب کنید:", $k_support);
}

if ($data == 'fun') {
    reply("# تفریح و سرگرمی\n\nقسمت مورد نظر را انتخاب کنید:", $k_fun);
}

// مدیریت زیرمنوهای تنظیمات
if ($data == 'multi_lock') {
    edit("# تنظیمات قفل چند حالت - صفحه اول\n\n(هر قفل با فشار بین ۶ حالت تغییر می‌کند)\nقسمت مورد نظر را انتخاب کنید:", $k_multi_lock1);
}

if ($data == 'multi_lock3') {
    edit("# تنظیمات قفل چند حالت - صفحه سوم\n\n(هر قفل با فشار بین ۶ حالت تغییر می‌کند)\nقسمت مورد نظر را انتخاب کنید:", $k_multi_lock3);
}

if ($data == 'multi_lock4') {
    edit("# تنظیمات قفل چند حالت - صفحه چهارم\n\n(هر قفل با فشار بین ۶ حالت تغییر می‌کند)\nقسمت مورد نظر را انتخاب کنید:", $k_multi_lock4);
}

if ($data == 'multi_lock5') {
    edit("# تنظیمات قفل چند حالت - صفحه پنجم\n\n(هر قفل با فشار بین ۶ حالت تغییر می‌کند)\nقسمت مورد نظر را انتخاب کنید:", $k_multi_lock5);
}

if ($data == 'single_lock') {
    edit("# تنظیمات قفل تک حالته\n\n(هر قفل فقط یک حالت دارد)\nقسمت مورد نظر را انتخاب کنید:", $k_single_lock);
}

if ($data == 'group_mode') {
    edit("# تنظیم حالت گروه - صفحه اول\n\nقسمت مورد نظر را انتخاب کنید:", $k_group_mode1);
}

if ($data == 'group_mode2') {
    edit("# تنظیم حالت گروه - صفحه دوم\n\nقسمت مورد نظر را انتخاب کنید:", $k_group_mode2);
}

if ($data == 'group_mode3') {
    edit("# تنظیم حالت گروه - صفحه سوم\n\nقسمت مورد نظر را انتخاب کنید:", $k_group_mode3);
}

if ($data == 'group_mode4') {
    edit("# تنظیم حالت گروه - صفحه آخر\n\nقسمت مورد نظر را انتخاب کنید:", $k_group_mode4);
}

// برگشت به منوی اصلی
if (preg_match('/^back_/', $data)) {
    $back_to = str_replace('back_', '', $data);
    
    if ($back_to == 'main') {
        edit("# تیتان ~ پنل مدیریت پیشرفته\n\nقسمت مورد نظر را انتخاب کنید:", $k_main);
    }
    elseif ($back_to == 'management1') {
        edit("# مدیریت ربات تیتان\n\nقسمت مورد نظر را انتخاب کنید:", $k_management1);
    }
    elseif ($back_to == 'settings') {
        edit("# تنظیمات گروه تیتان\n\nقسمت مورد نظر را انتخاب کنید:", $k_settings);
    }
    elseif ($back_to == 'help') {
        edit("# راهنمای تیتان\n\nقسمت مورد نظر را انتخاب کنید:", $k_help);
    }
}

// پردازش قفل‌ها (نمونه)
$lock_states = [
    'حذف پیام 🗑️',
    'سکوت کاربر 🤐',
    'اخطار ⚠️',
    'اخراج 🚫',
    'بن کامل ⛔️',
    'غیرفعال ❌'
];

if (preg_match('/^lock_(.+)/', $data, $matches)) {
    $lock_type = $matches[1];
    
    // دریافت وضعیت فعلی از دیتابیس
    $current_lock = $ne->select('groups', ['locked'], ['chat_id' => $chat])->fetchArray();
    $lock_data = json_decode($current_lock['locked'] ?? '{}', true);
    
    // تغییر وضعیت
    if (!isset($lock_data[$lock_type])) {
        $lock_data[$lock_type] = 0;
    }
    
    $lock_data[$lock_type] = ($lock_data[$lock_type] + 1) % 6;
    
    // ذخیره در دیتابیس
    $ne->update('groups', ['locked' => json_encode($lock_data)], ['chat_id' => $chat]);
    
    // آپدیت دکمه
    $current_state = $lock_states[$lock_data[$lock_type]];
    $new_text = "+ قفل " . str_replace('_', ' ', $lock_type) . " : " . $current_state;
    
    // آپدیت inline keyboard
    $message_id = $update->callback_query->message->message_id;
    $current_keyboard = $update->callback_query->message->reply_markup;
    
    // یافتن و آپدیت دکمه مربوطه
    foreach ($current_keyboard->inline_keyboard as &$row) {
        foreach ($row as &$button) {
            if (strpos($button->text, "قفل " . str_replace('_', ' ', $lock_type)) !== false) {
                $button->text = $new_text;
            }
        }
    }
    
    // ارسال آپدیت
    editMessageReplyMarkup($chat, $message_id, $current_keyboard);
}

// پردازش قفل‌های تک حالته
if (preg_match('/^slock_(.+)/', $data, $matches)) {
    $lock_type = $matches[1];
    
    // دریافت وضعیت فعلی از دیتابیس
    $current_lock = $ne->select('groups', ['single_locked'], ['chat_id' => $chat])->fetchArray();
    $lock_data = json_decode($current_lock['single_locked'] ?? '{}', true);
    
    // تغییر وضعیت
    $lock_data[$lock_type] = !isset($lock_data[$lock_type]) || $lock_data[$lock_type] == 0 ? 1 : 0;
    
    // ذخیره در دیتابیس
    $ne->update('groups', ['single_locked' => json_encode($lock_data)], ['chat_id' => $chat]);
    
    // آپدیت دکمه
    $current_state = $lock_data[$lock_type] == 1 ? 'فعال ✅' : 'غیرفعال ❌';
    $new_text = "+ قفل " . str_replace('_', ' ', $lock_type) . " : " . $current_state;
    
    // آپدیت inline keyboard
    $message_id = $update->callback_query->message->message_id;
    $current_keyboard = $update->callback_query->message->reply_markup;
    
    // یافتن و آپدیت دکمه مربوطه
    foreach ($current_keyboard->inline_keyboard as &$row) {
        foreach ($row as &$button) {
            if (strpos($button->text, "قفل " . str_replace('_', ' ', $lock_type)) !== false) {
                $button->text = $new_text;
            }
        }
    }
    
    // ارسال آپدیت
    editMessageReplyMarkup($chat, $message_id, $current_keyboard);
}

// مدیریت لیست‌ها
if ($data == 'vips') {
    // دریافت لیست ویژه‌ها از دیتابیس
    $vips = $ne->select('groups', ['vip_list'], ['chat_id' => $chat])->fetchArray();
    $vip_list = json_decode($vips['vip_list'] ?? '[]', true);
    
    if (empty($vip_list)) {
        $message = "📭 لیست ویژه‌ها خالی است.";
    } else {
        $message = "📋 لیست کاربران ویژه:\n\n";
        foreach ($vip_list as $index => $vip) {
            $message .= ($index + 1) . ". " . $vip['name'] . " (ID: " . $vip['user_id'] . ")\n";
        }
    }
    
    $k_vips = js(['inline_keyboard' => [
        [['text' => '➕ افزودن ویژه', 'callback_data' => 'add_vip']],
        [['text' => '🗑️ پاکسازی لیست', 'callback_data' => 'clear_vips']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_management1']]
    ]]);
    
    edit($message, $k_vips);
}

if ($data == 'warns') {
    // دریافت لیست اخطارها از دیتابیس
    $warns = $ne->select('groups', ['warn_list'], ['chat_id' => $chat])->fetchArray();
    $warn_list = json_decode($warns['warn_list'] ?? '[]', true);
    
    if (empty($warn_list)) {
        $message = "📭 لیست اخطاری‌ها خالی است.";
    } else {
        $message = "⚠️ لیست کاربران دارای اخطار:\n\n";
        foreach ($warn_list as $index => $warn) {
            $message .= ($index + 1) . ". " . $warn['name'] . " (ID: " . $warn['user_id'] . ") - " . $warn['count'] . " اخطار\n";
        }
    }
    
    $k_warns = js(['inline_keyboard' => [
        [['text' => '🔄 تنظیم تعداد اخطار', 'callback_data' => 'set_warn_count']],
        [['text' => '🗑️ پاکسازی لیست', 'callback_data' => 'clear_warns']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_management1']]
    ]]);
    
    edit($message, $k_warns);
}

if ($data == 'banned') {
    // دریافت لیست بن شده‌ها از دیتابیس
    $bans = $ne->select('groups', ['ban_list'], ['chat_id' => $chat])->fetchArray();
    $ban_list = json_decode($bans['ban_list'] ?? '[]', true);
    
    if (empty($ban_list)) {
        $message = "📭 لیست افراد اخراجی خالی است.";
    } else {
        $message = "⛔️ لیست کاربران اخراجی:\n\n";
        foreach ($ban_list as $index => $ban) {
            $message .= ($index + 1) . ". " . $ban['name'] . " (ID: " . $ban['user_id'] . ")\n";
        }
    }
    
    $k_bans = js(['inline_keyboard' => [
        [['text' => '➕ افزودن به لیست بن', 'callback_data' => 'add_ban']],
        [['text' => '🗑️ پاکسازی لیست', 'callback_data' => 'clear_bans']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_management1']]
    ]]);
    
    edit($message, $k_bans);
}

if ($data == 'silenced') {
    // دریافت لیست سایلنت شده‌ها از دیتابیس
    $silents = $ne->select('groups', ['silent_list'], ['chat_id' => $chat])->fetchArray();
    $silent_list = json_decode($silents['silent_list'] ?? '[]', true);
    
    if (empty($silent_list)) {
        $message = "📭 لیست افراد بی‌صدا خالی است.";
    } else {
        $message = "🤐 لیست کاربران بی‌صدا:\n\n";
        foreach ($silent_list as $index => $silent) {
            $message .= ($index + 1) . ". " . $silent['name'] . " (ID: " . $silent['user_id'] . ")\n";
        }
    }
    
    $k_silents = js(['inline_keyboard' => [
        [['text' => '➕ افزودن به لیست سکوت', 'callback_data' => 'add_silent']],
        [['text' => '🗑️ پاکسازی لیست', 'callback_data' => 'clear_silents']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_management1']]
    ]]);
    
    edit($message, $k_silents);
}

// تنظیمات حالت گروه
if ($data == 'global_lock') {
    // تغییر حالت قفل سراسری
    $settings = $ne->select('groups', ['group_settings'], ['chat_id' => $chat])->fetchArray();
    $group_settings = json_decode($settings['group_settings'] ?? '{}', true);
    
    $group_settings['global_lock'] = !isset($group_settings['global_lock']) || $group_settings['global_lock'] == 0 ? 1 : 0;
    
    $ne->update('groups', ['group_settings' => json_encode($group_settings)], ['chat_id' => $chat]);
    
    $state = $group_settings['global_lock'] == 1 ? 'فعال ✅' : 'غیرفعال ❌';
    $new_text = "+ قفل سراسری : " . $state;
    
    // آپدیت دکمه
    $message_id = $update->callback_query->message->message_id;
    $current_keyboard = $update->callback_query->message->reply_markup;
    
    foreach ($current_keyboard->inline_keyboard as &$row) {
        foreach ($row as &$button) {
            if (strpos($button->text, "قفل سراسری") !== false) {
                $button->text = $new_text;
            }
        }
    }
    
    editMessageReplyMarkup($chat, $message_id, $current_keyboard);
}

// پشتیبانی و اطلاعات
if ($data == 'creator') {
    $info = "👨‍💻 سازنده: @hamsterIIR\n🆔 ایدی سودو: 1049800789\n📞 پشتیبانی: @hamesterr2026\n📢 کانال ربات: @Confingfree2025\n👥 گروه پشتیبانی: @pantehr2026";
    $k_info = js(['inline_keyboard' => [
        [['text' => '🏛 برگشت', 'callback_data' => 'back_support']]
    ]]);
    
    edit($info, $k_info);
}

if ($data == 'sponsor') {
    $sponsor_info = "🤝 اسپانسر\n\nربات تیتان با حمایت:\n• تیم TITAN F16\n• @hamsterIIR\n\nبرای اسپانسر شدن با سازنده در ارتباط باشید.";
    $k_sponsor = js(['inline_keyboard' => [
        [['text' => '👨‍💻 تماس با سازنده', 'url' => 'https://t.me/hamsterIIR']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_support']]
    ]]);
    
    edit($sponsor_info, $k_sponsor);
}

if ($data == 'add_bot') {
    $add_text = "🤖 برای افزودن ربات به گروه جدید:\n\n1. ابتدا ربات را ادمین کامل کنید\n2. سپس از منوی مدیریت استفاده نمایید\n3. دسترسی‌های لازم را اعمال کنید\n\n🔗 لینک ربات: https://t.me/" . $bot_username;
    $k_add = js(['inline_keyboard' => [
        [['text' => '➕ افزودن به گروه', 'url' => 'https://t.me/' . $bot_username . '?startgroup=new']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_support']]
    ]]);
    
    edit($add_text, $k_add);
}

// راهنمای دستورات
if ($data == 'user_cmds') {
    $help_text = "📋 دستورات کاربری:\n\n";
    $help_text .= "• /start - شروع کار با ربات\n";
    $help_text .= "• /panel - نمایش پنل مدیریت\n";
    $help_text .= "• /me - اطلاعات حساب شما\n";
    $help_text .= "• /id - دریافت شناسه\n";
    $help_text .= "• /info - اطلاعات کاربر\n";
    $help_text .= "• /rules - قوانین گروه\n";
    $help_text .= "• /link - لینک گروه\n";
    
    $k_help_cmds = js(['inline_keyboard' => [
        [['text' => '🧹 پاکسازی', 'callback_data' => 'clean_cmds']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_help']]
    ]]);
    
    edit($help_text, $k_help_cmds);
}

if ($data == 'clean_cmds') {
    $help_text = "🧹 دستورات پاکسازی:\n\n";
    $help_text .= "• حذف 100 - پاکسازی 100 پیام\n";
    $help_text .= "• پاکسازی مدیران - پاکسازی لیست مدیران\n";
    $help_text .= "• پاکسازی لیست ویژه - پاکسازی کاربران ویژه\n";
    $help_text .= "• پاکسازی اخطار - پاکسازی لیست اخطار\n";
    $help_text .= "• پاکسازی بن - پاکسازی لیست بن\n";
    $help_text .= "• پاکسازی سکوت - پاکسازی لیست سکوت\n";
    
    $k_help_cmds = js(['inline_keyboard' => [
        [['text' => '🔒 قفلی', 'callback_data' => 'lock_cmds']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_help']]
    ]]);
    
    edit($help_text, $k_help_cmds);
}

if ($data == 'lock_cmds') {
    $help_text = "🔒 دستورات قفلی:\n\n";
    $help_text .= "• قفل لینک - فعال‌سازی قفل لینک\n";
    $help_text .= "• بازکردن لینک - غیرفعال‌سازی قفل لینک\n";
    $help_text .= "• قفل فارسی - فعال‌سازی قفل فارسی\n";
    $help_text .= "• قفل انگلیسی - فعال‌سازی قفل انگلیسی\n";
    $help_text .= "• قفل فوروارد - فعال‌سازی قفل فوروارد\n";
    $help_text .= "• قفل رگبار - فعال‌سازی قفل رگبار\n";
    
    $k_help_cmds = js(['inline_keyboard' => [
        [['text' => '🎮 سرگرمی', 'callback_data' => 'fun_cmds']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_help']]
    ]]);
    
    edit($help_text, $k_help_cmds);
}
if ($data == 'fun_cmds') {
    $help_text = "🎮 دستورات سرگرمی:\n\n";
    $help_text .= "• تقویم - نمایش تقویم\n";
    $help_text .= "• شعر - ارسال شعر تصادفی\n";
    $help_text .= "• فال - گرفتن فال\n";
    $help_text .= "• نرخ ارز - نرخ ارزهای دیجیتال\n";
    $help_text .= "• هواشناسی [شهر] - وضعیت آب و هوا\n";
    $help_text .= "• استیکر به عکس - تبدیل استیکر\n";
    $help_text .= "• عکس به استیکر - تبدیل عکس\n";
    $help_text .= "• بگوو [متن] - تکرار متن\n";
    
    $k_help_cmds = js(['inline_keyboard' => [
        [['text' => '⚡ اجباری', 'callback_data' => 'force_cmds']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_help']]
    ]]);
    
    edit($help_text, $k_help_cmds);
}

if ($data == 'force_cmds') {
    $help_text = "⚡ دستورات اجباری:\n\n";
    $help_text .= "• اجبار عضویت فعال - فعال کردن اد اجباری\n";
    $help_text .= "• اجبار عضویت غیرفعال - غیرفعال کردن\n";
    $help_text .= "• تنظیم اجبار عضویت 5 - تعداد افراد\n";
    $help_text .= "• وضعیت اجبار عضویت جدید/همه\n";
    $help_text .= "• پاکسازی سابقه اجبار عضویت\n";
    $help_text .= "• تنظیم زمان اجبار عضویت 60\n";
    $help_text .= "• معاف - معاف کردن کاربر\n";
    $help_text .= "• اجبار حضور فعال - عضویت در کانال\n";
    
    $k_help_cmds = js(['inline_keyboard' => [
        [['text' => '📋 کاربری', 'callback_data' => 'user_cmds']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_help']]
    ]]);
    
    edit($help_text, $k_help_cmds);
}

if ($data == 'manage_cmds') {
    $help_text = "⚙️ دستورات مدیریتی:\n\n";
    $help_text .= "• پیکربندی - ارتقای ادمین‌ها\n";
    $help_text .= "• تنظیم مدیر - ارتقای مدیر\n";
    $help_text .= "• حذف مدیر - عزل مدیر\n";
    $help_text .= "• لیست مدیران - نمایش مدیران\n";
    $help_text .= "• تنظیم ویژه - ویژه کردن کاربر\n";
    $help_text .= "• حذف ویژه - عزل کاربر ویژه\n";
    $help_text .= "• افزودن ادمین - ادمین گروه کردن\n";
    $help_text .= "• حذف ادمین - عزل ادمین گروه\n";
    
    $k_help_cmds = js(['inline_keyboard' => [
        [['text' => '🔒 قفلی', 'callback_data' => 'lock_cmds']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_help']]
    ]]);
    
    edit($help_text, $k_help_cmds);
}

// اطلاعات پایانی پنل
if ($data == 'complete_info') {
    $group_info = Neman('getChat', ['chat_id' => $chat])->result;
    $members_count = Neman('getChatMembersCount', ['chat_id' => $chat])->result;
    $admins_count = count(Neman('getChatAdministrators', ['chat_id' => $chat])->result);
    
    $info_text = "📊 اطلاعات تکمیل گروه:\n\n";
    $info_text .= "👥 نام گروه: " . ($group_info->title ?? "ناشناس") . "\n";
    $info_text .= "🆔 آیدی گروه: " . $chat . "\n";
    $info_text .= "👥 تعداد اعضا: " . $members_count . " نفر\n";
    $info_text .= "👨‍✈️ تعداد مدیران: " . $admins_count . " نفر\n";
    $info_text .= "🤖 وضعیت ربات: فعال ✅\n";
    $info_text .= "📅 تاریخ نصب: " . date("Y/m/d") . "\n";
    $info_text .= "⏰ آخرین بروزرسانی: " . date("H:i:s") . "\n";
    
    $k_info = js(['inline_keyboard' => [
        [['text' => '🔄 بروزرسانی', 'callback_data' => 'refresh_info']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_management1']]
    ]]);
    
    edit($info_text, $k_info);
}

if ($data == 'refresh_info') {
    $group_info = Neman('getChat', ['chat_id' => $chat])->result;
    $members_count = Neman('getChatMembersCount', ['chat_id' => $chat])->result;
    $admins_count = count(Neman('getChatAdministrators', ['chat_id' => $chat])->result);
    
    $info_text = "📊 اطلاعات تکمیل گروه:\n\n";
    $info_text .= "👥 نام گروه: " . ($group_info->title ?? "ناشناس") . "\n";
    $info_text .= "🆔 آیدی گروه: " . $chat . "\n";
    $info_text .= "👥 تعداد اعضا: " . $members_count . " نفر\n";
    $info_text .= "👨‍✈️ تعداد مدیران: " . $admins_count . " نفر\n";
    $info_text .= "🤖 وضعیت ربات: فعال ✅\n";
    $info_text .= "📅 تاریخ نصب: " . date("Y/m/d") . "\n";
    $info_text .= "⏰ آخرین بروزرسانی: " . date("H:i:s") . "\n";
    
    $k_info = js(['inline_keyboard' => [
        [['text' => '🔄 بروزرسانی', 'callback_data' => 'refresh_info']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_management1']]
    ]]);
    
    alert("✅ اطلاعات با موفقیت بروزرسانی شد!", true);
    edit($info_text, $k_info);
}

// مدیریت قوانین
if ($data == 'rules') {
    $rules_data = $ne->select('groups', ['rules'], ['chat_id' => $chat])->fetchArray();
    $rules = $rules_data['rules'] ?? "📝 قوانین گروه تنظیم نشده است.\n\nاز بخش تنظیمات می‌توانید قوانین را تعیین کنید.";
    
    $k_rules = js(['inline_keyboard' => [
        [['text' => '✏️ ویرایش قوانین', 'callback_data' => 'edit_rules']],
        [['text' => '🗑️ حذف قوانین', 'callback_data' => 'delete_rules']],
        [['text' => '🏛 برگشت', 'callback_data' => 'back_management1']]
    ]]);
    
    edit("📜 قوانین گروه:\n\n" . $rules, $k_rules);
}

// پیام نهایی
$footer = "
نویسنده: تیم تیتان 
نام ربات: TITAN F16
ایدی سودو: @hamsterIIR
آیدی سودو: 1049800789
پشتیبانی: @hamesterr2026
کانال ربات: @Confingfree2025
گروه پشتیبانی: @pantehr2026
";

// تابع کمکی برای ایجاد inline keyboard
function createKeyboard($buttons, $back_button = null) {
    $keyboard = [];
    
    foreach ($buttons as $row) {
        $keyboard_row = [];
        foreach ($row as $button) {
            $keyboard_row[] = [
                'text' => $button['text'],
                'callback_data' => $button['callback_data']
            ];
        }
        $keyboard[] = $keyboard_row;
    }
    
    if ($back_button) {
        $keyboard[] = [['text' => '🏛 برگشت', 'callback_data' => $back_button]];
    }
    
    return json_encode(['inline_keyboard' => $keyboard]);
}

// تابع برای تغییر وضعیت قفل‌ها
function toggleLock($chat_id, $lock_type, $current_state) {
    global $ne;
    
    $states = ['غیرفعال ❌', 'حذف پیام 🗑️', 'سکوت کاربر 🤐', 'اخطار ⚠️', 'اخراج 🚫', 'بن کامل ⛔️'];
    
    $current_index = array_search($current_state, $states);
    $next_index = ($current_index + 1) % count($states);
    $new_state = $states[$next_index];
    
    // ذخیره در دیتابیس
    $lock_data = $ne->select('groups', ['locks'], ['chat_id' => $chat_id])->fetchArray();
    $locks = json_decode($lock_data['locks'] ?? '{}', true);
    $locks[$lock_type] = $next_index;
    $ne->update('groups', ['locks' => json_encode($locks)], ['chat_id' => $chat_id]);
    
    return $new_state;
}

// تابع برای تغییر وضعیت تک حالته
function toggleSingleLock($chat_id, $lock_type, $current_state) {
    global $ne;
    
    $new_state = $current_state == 'غیرفعال ❌' ? 'فعال ✅' : 'غیرفعال ❌';
    
    // ذخیره در دیتابیس
    $lock_data = $ne->select('groups', ['single_locks'], ['chat_id' => $chat_id])->fetchArray();
    $locks = json_decode($lock_data['single_locks'] ?? '{}', true);
    $locks[$lock_type] = $new_state == 'فعال ✅' ? 1 : 0;
    $ne->update('groups', ['single_locks' => json_encode($locks)], ['chat_id' => $chat_id]);
    
    return $new_state;
}

// تابع برای نمایش پیام تأیید
function showConfirmation($message, $callback_data = null) {
    $keyboard = [];
    
    if ($callback_data) {
        $keyboard = [
            'inline_keyboard' => [
                [['text' => '✅ تأیید', 'callback_data' => $callback_data . '_confirm']],
                [['text' => '❌ لغو', 'callback_data' => $callback_data . '_cancel']]
            ]
        ];
    }
    
    return ['text' => $message, 'reply_markup' => json_encode($keyboard)];
}

// مدیریت تأییدها
if (preg_match('/^(.+)_confirm$/', $data, $matches)) {
    $action = $matches[1];
    
    switch ($action) {
        case 'clear_vips':
            $ne->update('groups', ['vip_list' => '[]'], ['chat_id' => $chat]);
            alert("✅ لیست ویژه‌ها با موفقیت پاک شد!", true);
            edit("📭 لیست ویژه‌ها خالی است.", $k_vips);
            break;
            
        case 'clear_warns':
            $ne->update('groups', ['warn_list' => '[]'], ['chat_id' => $chat]);
            alert("✅ لیست اخطارها با موفقیت پاک شد!", true);
            edit("📭 لیست اخطاری‌ها خالی است.", $k_warns);
            break;
            
        case 'clear_bans':
            $ne->update('groups', ['ban_list' => '[]'], ['chat_id' => $chat]);
            alert("✅ لیست بن‌ها با موفقیت پاک شد!", true);
            edit("📭 لیست افراد اخراجی خالی است.", $k_bans);
            break;
            
        case 'clear_silents':
            $ne->update('groups', ['silent_list' => '[]'], ['chat_id' => $chat]);
            alert("✅ لیست سکوت‌ها با موفقیت پاک شد!", true);
            edit("📭 لیست افراد بی‌صدا خالی است.", $k_silents);
            break;
            
        case 'delete_rules':
            $ne->update('groups', ['rules' => ''], ['chat_id' => $chat]);
            alert("✅ قوانین گروه با موفقیت حذف شد!", true);
            edit("📝 قوانین گروه حذف شد.", $k_rules);
            break;
    }
}

if (preg_match('/^(.+)_cancel$/', $data, $matches)) {
    $action = $matches[1];
    alert("❌ عملیات لغو شد!", true);
}

// تابع اصلی برای نمایش منوها
function showMenu($menu_name, $chat_id, $message_id = null) {
    global $k_main, $k_management1, $k_management2, $k_settings, $k_help, $k_support;
    
    $menus = [
        'main' => ['text' => "# تیتان ~ پنل مدیریت پیشرفته\n\nقسمت مورد نظر را انتخاب کنید:", 'keyboard' => $k_main],
        'management' => ['text' => "# مدیریت ربات تیتان\n\nقسمت مورد نظر را انتخاب کنید:", 'keyboard' => $k_management1],
        'management2' => ['text' => "# پنل مدیریت تیتان\n\nقسمت مورد نظر را انتخاب کنید:", 'keyboard' => $k_management2],
        'settings' => ['text' => "# تنظیمات گروه تیتان\n\nقسمت مورد نظر را انتخاب کنید:", 'keyboard' => $k_settings],
        'help' => ['text' => "# راهنمای تیتان\n\nقسمت مورد نظر را انتخاب کنید:", 'keyboard' => $k_help],
        'support' => ['text' => "# پشتیبانی تیتان\n\nقسمت مورد نظر را انتخاب کنید:", 'keyboard' => $k_support]
    ];
    
    if (isset($menus[$menu_name])) {
        $menu = $menus[$menu_name];
        
        if ($message_id) {
            editMessageText($chat_id, $message_id, $menu['text'], $menu['keyboard']);
        } else {
            sendMessage($chat_id, $menu['text'], $menu['keyboard']);
        }
    }
}

// تابع برای ایجاد دکمه‌های پویا
function createDynamicButtons($buttons_config, $current_state = null) {
    $keyboard = [];
    
    foreach ($buttons_config as $row) {
        $keyboard_row = [];
        foreach ($row as $button) {
            if (is_array($button) && isset($button['text']) && isset($button['callback_data'])) {
                $button_text = $button['text'];
                
                // اگر وضعیت فعلی داده شده، دکمه را آپدیت کن
                if ($current_state && isset($button['state_key'])) {
                    $state_value = $current_state[$button['state_key']] ?? 0;
                    $button_text = str_replace('{state}', getStateText($button['state_key'], $state_value), $button_text);
                }
                
                $keyboard_row[] = [
                    'text' => $button_text,
                    'callback_data' => $button['callback_data']
                ];
            }
        }
        if (!empty($keyboard_row)) {
            $keyboard[] = $keyboard_row;
        }
    }
    
    return json_encode(['inline_keyboard' => $keyboard]);
}

// تابع کمکی برای دریافت متن وضعیت
function getStateText($state_key, $state_value) {
    $states = [
        'lock' => ['غیرفعال ❌', 'حذف پیام 🗑️', 'سکوت کاربر 🤐', 'اخطار ⚠️', 'اخراج 🚫', 'بن کامل ⛔️'],
        'toggle' => ['غیرفعال ❌', 'فعال ✅'],
        'mode' => ['خاموش', 'روشن', 'نیمه فعال']
    ];
    
    foreach ($states as $key => $state_array) {
        if (strpos($state_key, $key) !== false) {
            return $state_array[$state_value] ?? $state_array[0];
        }
    }
    
    return 'غیرفعال ❌';
}

// تابع برای ذخیره تنظیمات
function saveSettings($chat_id, $settings_type, $settings_data) {
    global $ne;
    
    $current_settings = $ne->select('groups', [$settings_type], ['chat_id' => $chat_id])->fetchArray();
    $settings = json_decode($current_settings[$settings_type] ?? '{}', true);
    
    // ادغام تنظیمات جدید با قدیمی
    $settings = array_merge($settings, $settings_data);
    
    $ne->update('groups', [$settings_type => json_encode($settings)], ['chat_id' => $chat_id]);
    
    return true;
}

// تابع برای بارگذاری تنظیمات
function loadSettings($chat_id, $settings_type) {
    global $ne;
    
    $current_settings = $ne->select('groups', [$settings_type], ['chat_id' => $chat_id])->fetchArray();
    return json_decode($current_settings[$settings_type] ?? '{}', true);
}

// پایان کد
?>